<?php
/* ͕h~̂߂̓{ꕶłB
   ̃\[Xt@C Shift_JIS ŕۑĂ܂B
   Above is a Japanese strings to avoid charset mis-understanding.
   This source file is saved with Shift_JIS.

   ***** DO NOT EDIT THIS FILE WITH WORDPRESS ADMIN PANEL *****
*/

/* ==================================================
 *   KtaiService_imode class
   ================================================== */

if ( !defined('KTAI_IMODE_UID') ) {
	define('KTAI_IMODE_UID', false);
}

class KtaiService_imode extends KtaiServices {
	static public $networks;
	static public $pictograms;

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	parent::__construct($user_agent);
	$this->operator = 'DoCoMo';
	$this->image_pictograms = false;
	$this->use_redir = true;
	$this->show_plugin_icon = false;
	$this->pcview_enabled = false;
	$this->sub_ID_available = true;
	if ( KTAI_IMODE_UID ) {
		$this->sub_ID = ( isset($_GET['uid']) && preg_match('/^\d+$/', $_GET['uid']) ) ? $_GET['uid'] : NULL;
	} else {
		$this->sub_ID = isset($_SERVER['HTTP_X_DCMGUID']) ? $_SERVER['HTTP_X_DCMGUID'] : NULL;
	}
	$this->cookie_available = false;
	$this->ext_css_available = false;
	$this->available_js_version = false;
	$this->charset = 'SJIS-win';
	$this->mime_type = 'text/html';
	$this->require_id_msg = "ERROR: Please send your mobile phone info, or configure to notify your i-mode ID.\nGo iMenu &gt; Charges &amp;Apply/Prefs &gt; 4.Options &gt; i-mode ID notify preference.";
	// http://www.nttdocomo.co.jp/service/imode/make/content/pictograph/basic/

	// http://www.nttdocomo.co.jp/service/imode/make/content/ip/
	// Last Update: 2010-11
	$this->networks = array(
		'210.153.84.0/24',
		'210.136.161.0/24',
		'210.153.86.0/24',
		'124.146.174.0/24', // Since 2008-10-10
		'124.146.175.0/24', // Since 2009-12-15
		'202.229.176.0/24', // Since 2010-May
		'202.229.177.0/24', // Since 2010-May
		'202.229.178.0/24', // Since 2010-May
	);
	// http://www.nttdocomo.co.jp/service/imode/make/content/pictograph/
	self::$pictograms = array(
		'd001' => "\xf8\x9f", // 
		'd002' => "\xf8\xa0", // ܂
		'd003' => "\xf8\xa1", // J
		'd004' => "\xf8\xa2", //  
		'd005' => "\xf8\xa3", // 
		'd006' => "\xf8\xa4", // 䕗
		'd007' => "\xf8\xa5", // 
		'd008' => "\xf8\xa6", // J
		'd009' => "\xf8\xa7", // r
		'd010' => "\xf8\xa8", // 
		'd011' => "\xf8\xa9", // oq
		'd012' => "\xf8\xaa", // I
		'd013' => "\xf8\xab", // q
		'd014' => "\xf8\xac", // 
		'd015' => "\xf8\xad", // V
		'd016' => "\xf8\xae", // 嶍
		'd017' => "\xf8\xaf", // ˎ
		'd018' => "\xf8\xb0", // Rr
		'd019' => "\xf8\xb1", // r
		'd020' => "\xf8\xb2", // 
		'd021' => "\xf8\xb3", // X|[c
		'd022' => "\xf8\xb4", // 싅
		'd023' => "\xf8\xb5", // St
		'd024' => "\xf8\xb6", // ejX
		'd025' => "\xf8\xb7", // TbJ[
		'd026' => "\xf8\xb8", // XL[
		'd027' => "\xf8\xb9", // oXPbg{[
		'd028' => "\xf8\xba", // [^[X|[c (`FbJ[tbO)
		'd029' => "\xf8\xbb", // |Pbgx
		'd030' => "\xf8\xbc", // d
		'd031' => "\xf8\xbd", // nS
		'd032' => "\xf8\xbe", // V
		'd033' => "\xf8\xbf", //  (Z_)
		'd034' => "\xf8\xc0", //  (RV)
		'd035' => "\xf8\xc1", // oX
		'd036' => "\xf8\xc2", // D
		'd037' => "\xf8\xc3", // s@
		'd038' => "\xf8\xc4", // 
		'd039' => "\xf8\xc5", // r
		'd040' => "\xf8\xc6", // X֋
		'd041' => "\xf8\xc7", // a@
		'd042' => "\xf8\xc8", // s
		'd043' => "\xf8\xc9", // ATM
		'd044' => "\xf8\xca", // ze
		'd045' => "\xf8\xcb", // Rrj
		'd046' => "\xf8\xcc", // K\X^h
		'd047' => "\xf8\xcd", // ԏ
		'd048' => "\xf8\xce", // M
		'd049' => "\xf8\xcf", // gC
		'd050' => "\xf8\xd0", // Xg
		'd051' => "\xf8\xd1", // iX
		'd052' => "\xf8\xd2", // o[ (}eB[j)
		'd053' => "\xf8\xd3", // r[
		'd054' => "\xf8\xd4", // t@[Xgt[h (no[K[)
		'd055' => "\xf8\xd5", // ueBbN
		'd056' => "\xf8\xd6", // e@ ()
		'd057' => "\xf8\xd7", // JIP
		'd058' => "\xf8\xd8", // f
		'd059' => "\xf8\xd9", // E΂ߏ
		'd060' => "\xf8\xda", // Vn (ؔn)
		'd061' => "\xf8\xdb", // y (wbhz)
		'd062' => "\xf8\xdc", // A[g
		'd063' => "\xf8\xdd", // 
		'd064' => "\xf8\xde", // Cxg (T[JX)
		'd065' => "\xf8\xdf", // `Pbg
		'd066' => "\xf8\xe0", // i
		'd067' => "\xf8\xe1", // ։
		'd068' => "\xf8\xe2", // J
		'd069' => "\xf8\xe3", // Jo
		'd070' => "\xf8\xe4", // {
		'd071' => "\xf8\xe5", // {
		'd072' => "\xf8\xe6", // v[g
		'd073' => "\xf8\xe7", // o[Xf[
		'd074' => "\xf8\xe8", // db
		'd075' => "\xf8\xe9", // gѓdb
		'd076' => "\xf8\xea", // 
		'd077' => "\xf8\xeb", // TV
		'd078' => "\xf8\xec", // Q[
		'd079' => "\xf8\xed", // CD
		'd080' => "\xf8\xee", // n[g
		'd081' => "\xf8\xef", // Xy[h
		'd082' => "\xf8\xf0", // _C
		'd083' => "\xf8\xf1", // Nu
		'd084' => "\xf8\xf2", // 
		'd085' => "\xf8\xf3", // 
		'd086' => "\xf8\xf4", //  (O[)
		'd087' => "\xf8\xf5", //  (`L)
		'd088' => "\xf8\xf6", //  (p[)
		'd089' => "\xf8\xf7", // E΂߉
		'd090' => "\xf8\xf8", // ΂ߏ
		'd091' => "\xf8\xf9", // 
		'd092' => "\xf8\xfa", // 
		'd093' => "\xf8\xfb", // ዾ
		'd094' => "\xf8\xfc", // Ԉ֎q
		'd095' => "\xf9\x40", // V
		'd096' => "\xf9\x41", // ⌇
		'd097' => "\xf9\x42", // 
		'd098' => "\xf9\x43", // O
		'd099' => "\xf9\x44", // 
		'd100' => "\xf9\x45", // 
		'd101' => "\xf9\x46", // L
		'd102' => "\xf9\x47", // ][g (bg)
		'd103' => "\xf9\x48", // NX}X
		'd104' => "\xf9\x49", // ΂߉
		'd105' => "\xf9\x72", // phone to
		'd106' => "\xf9\x73", // mail to
		'd107' => "\xf9\x74", // fax to
		'd108' => "\xf9\x75", // i[h
		'd109' => "\xf9\x76", // i[h (gt)
		'd110' => "\xf9\x77", // [
		'd111' => "\xf9\x78", // hR
		'd112' => "\xf9\x79", // hR|Cg
		'd113' => "\xf9\x7a", // L
		'd114' => "\xf9\x7b", // 
		'd115' => "\xf9\x7c", // ID
		'd116' => "\xf9\x7d", // pX[h
		'd117' => "\xf9\x7e", // L
		'd118' => "\xf9\x80", // NA
		'd119' => "\xf9\x81", // T[` (ׂ)
		'd120' => "\xf9\x82", // NEW
		'd121' => "\xf9\x83", // ʒu
		'd122' => "\xf9\x84", // t[_C
		'd123' => "\xf9\x85", // V[v_C
		'd124' => "\xf9\x86", // oQ
		'd125' => "\xf9\x87", // 1 (one)
		'd126' => "\xf9\x88", // 2 (two)
		'd127' => "\xf9\x89", // 3 (three)
		'd128' => "\xf9\x8a", // 4 (four)
		'd129' => "\xf9\x8b", // 5 (five)
		'd130' => "\xf9\x8c", // 6 (six)
		'd131' => "\xf9\x8d", // 7 (seven)
		'd132' => "\xf9\x8e", // 8 (eight)
		'd133' => "\xf9\x8f", // 9 (nine)
		'd134' => "\xf9\x90", // 0 (zero)
		'd135' => "\xf9\xb0", //  (OK)
		'd136' => "\xf9\x91", // n[g
		'd137' => "\xf9\x92", // hn[g
		'd138' => "\xf9\x93", // 
		'd139' => "\xf9\x94", // n[g (n[g)
		'd140' => "\xf9\x95", // [ ()
		'd141' => "\xf9\x96", //  ({)
		'd142' => "\xf9\x97", // ` (_)
		'd143' => "\xf9\x98", // ₾` (߂)
		'd144' => "\xf9\x99", // ӂӂ
		'd145' => "\xf9\x9a", // Obh ()
		'd146' => "\xf9\x9b", //  ()
		'd147' => "\xf9\x9c", // C ()
		'd148' => "\xf9\x9d", // 킢
		'd149' => "\xf9\x9e", // LX}[N
		'd150' => "\xf9\x9f", // ҂҂ (V)
		'd151' => "\xf9\xa0", // Ђ߂
		'd152' => "\xf9\xa1", // ނ ({)
		'd153' => "\xf9\xa2", // p`
		'd154' => "\xf9\xa3", // e
		'd155' => "\xf9\xa4", // [h
		'd156' => "\xf9\xa5", // obh ()
		'd157' => "\xf9\xa6", //  ()
		'd158' => "\xf9\xa7", // exclamation
		'd159' => "\xf9\xa8", // exclamation and question
		'd160' => "\xf9\xa9", // double exclamation
		'd161' => "\xf9\xaa", // ǂ (Ռ)
		'd162' => "\xf9\xab", //  (юU銾)
		'd163' => "\xf9\xac", // [ ()
		'd164' => "\xf9\xad", // _bV (o)
		'd165' => "\xf9\xae", // [ (L1)
		'd166' => "\xf9\xaf", // [ (L2)
		'd167' => "\xf9\x50", // J`R
		'd168' => "\xf9\x51", // ӂ
		'd169' => "\xf9\x52", // y
		'd170' => "\xf9\x55", // le
		'd171' => "\xf9\x56", // 
		'd172' => "\xf9\x57", // 
		'd173' => "\xf9\x5b", // soon
		'd174' => "\xf9\x5c", // on
		'd175' => "\xf9\x5d", // end
		'd176' => "\xf9\x5e", // v
		'd201' => "\xf9\xb1", // iAv
		'd202' => "\xf9\xb2", // iAv (gt)
		'd203' => "\xf9\xb3", // TVc ({[_[)
		'd204' => "\xf9\xb4", // ܌z
		'd205' => "\xf9\xb5", // 
		'd206' => "\xf9\xb6", // W[Y
		'd207' => "\xf9\xb7", // Xm{
		'd208' => "\xf9\xb8", // `y
		'd209' => "\xf9\xb9", // hA
		'd210' => "\xf9\xba", // h
		'd211' => "\xf9\xbb", // p\R
		'd212' => "\xf9\xbc", // u^[
		'd213' => "\xf9\xbd", // `
		'd214' => "\xf9\xbe", // M
		'd215' => "\xf9\xbf", // 
		'd216' => "\xf9\xc0", // w
		'd217' => "\xf9\xc1", // v
		'd218' => "\xf9\xc2", // ]
		'd219' => "\xf9\xc3", // ̂
		'd220' => "\xf9\xc4", // rv
		'd221' => "\xf9\xc5", // lĂ
		'd222' => "\xf9\xc6", // قƂ
		'd223' => "\xf9\xc7", // ⊾ ()
		'd224' => "\xf9\xc8", // ⊾2 ()
		'd225' => "\xf9\xc9", // ՂȊ
		'd226' => "\xf9\xca", // {P[Ƃ
		'd227' => "\xf9\xcb", // ڂn[g ()
		'd228' => "\xf9\xcc", // wOK
		'd229' => "\xf9\xcd", // ׁ[
		'd230' => "\xf9\xce", // EBN
		'd231' => "\xf9\xcf", // ꂵ
		'd232' => "\xf9\xd0", // ܂
		'd233' => "\xf9\xd1", // L2
		'd234' => "\xf9\xd2", // 
		'd235' => "\xf9\xd3", // 
		'd236' => "\xf9\xd4", // NG
		'd237' => "\xf9\xd5", // Nbv
		'd238' => "\xf9\xd6", // Rs[Cg (C)
		'd239' => "\xf9\xd7", // g[h}[N (TM)
		'd240' => "\xf9\xd8", // l
		'd241' => "\xf9\xd9", // }
		'd242' => "\xf9\xda", // TCN
		'd243' => "\xf9\xdb", // WX^[hg[h}[N (R)
		'd244' => "\xf9\xdc", // 댯Ex (!)
		'd245' => "\xf9\xdd", // ֎~
		'd246' => "\xf9\xde", // 󎺁EȁE
		'd247' => "\xf9\xdf", // i}[N
		'd248' => "\xf9\xe0", // EȁE
		'd249' => "\xf9\xe1", // 󍶉E
		'd250' => "\xf9\xe2", // ㉺
		'd251' => "\xf9\xe3", // wZ
		'd252' => "\xf9\xe4", // g
		'd253' => "\xf9\xe5", // xmR
		'd254' => "\xf9\xe6", // N[o[
		'd255' => "\xf9\xe7", // 
		'd256' => "\xf9\xe8", // `[bv
		'd257' => "\xf9\xe9", // oii
		'd258' => "\xf9\xea", // 
		'd259' => "\xf9\xeb", // 
		'd260' => "\xf9\xec", // ݂
		'd261' => "\xf9\xed", // 
		'd262' => "\xf9\xee", // ɂ
		'd263' => "\xf9\xef", // V[gP[L
		'd264' => "\xf9\xf0", // Ƃ (傱t)
		'd265' => "\xf9\xf1", // ǂԂ
		'd266' => "\xf9\xf2", // p
		'd267' => "\xf9\xf3", // ނ
		'd268' => "\xf9\xf4", // Ђ悱
		'd269' => "\xf9\xf5", // yM
		'd270' => "\xf9\xf6", // 
		'd271' => "\xf9\xf7", // ܂! ()
		'd272' => "\xf9\xf8", // EbVbV ()
		'd273' => "\xf9\xf9", // E}
		'd274' => "\xf9\xfa", // u^
		'd275' => "\xf9\xfb", // COX
		'd276' => "\xf9\xfc", //  ()
	);
	return;
}

/* ==================================================
 * @param	boolean $allow_search_engine
 * @return	boolean $in_network
 */
public function in_network($allow_search_engine = false) {
	return parent::in_network(self::$networks, $allow_search_engine);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function replace_smiley($buffer) {
	$smiles = array(
		'icon_smile.gif'     => self::$pictograms['d140'],
		'icon_biggrin.gif'   => self::$pictograms['d231'],
		'icon_sad.gif'       => self::$pictograms['d143'],
		'icon_surprised.gif' => self::$pictograms['d276'],
		'icon_eek.gif'       => self::$pictograms['d276'],
		'icon_confused.gif'  => self::$pictograms['d221'],
		'icon_cool.gif'      => self::$pictograms['d271'],
		'icon_mad.gif'       => self::$pictograms['d141'],
		'icon_razz.gif'      => self::$pictograms['d229'],
		'icon_neutral.gif'   => self::$pictograms['d226'],
		'icon_wink.gif'      => self::$pictograms['d230'],
		'icon_lol.gif'       => self::$pictograms['d229'],
		'icon_redface.gif'   => self::$pictograms['d227'],
		'icon_cry.gif'       => self::$pictograms['d234'],
		'icon_evil.gif'      => self::$pictograms['d225'],
		'icon_twisted.gif'   => self::$pictograms['d225'],
		'icon_rolleyes.gif'  => self::$pictograms['d221'],
		'icon_exclaim.gif'   => self::$pictograms['d244'],
		'icon_question.gif'  => '(?)',
		'icon_idea.gif'      => self::$pictograms['d151'],
		'icon_arrow.gif'     => self::$pictograms['d173'],
		'icon_mrgreen.gif'   => self::$pictograms['d272'],
	);
	$smiles = apply_filters('ktai_smiley_table', $smiles, __CLASS__);
	$smiles = apply_filters('smiley_table/ktai_style.php', $smiles);
	return parent::replace_smiley($buffer, $smiles);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function convert_pict($buffer) {
	// http://www.au.kddi.com/email/emoji/
	// http://mb.softbank.jp/mb/service/3G/mail/pictogram/
	// http://www.nttdocomo.co.jp/service/mail/imode_mail/emoji_convert/
	// http://www.willcom-inc.com/ja/service/e_mail/pdf/conversiontable.pdf
	$translated = self::$pictograms + array(
		'1'     => self::$pictograms['d244'], // u!v
		'2'     => self::$pictograms['d158'], // u!v
		'3'     => '?', // u?v
		'4'     => self::$pictograms['d124'], // uQv
		'5'     => '', // Op1
		'6'     => '', // EOp1
		'7'     => '', // Op2
		'8'     => '', // EOp2
		'9'     => '', // lp 1
		'10'    => '', // lp 2
		'11'    => '[i]', // CtH[VV{
		'12'    => self::$pictograms['d275'], // COX
		'13'    => '[Xs[J[]', // Xs[J[
		'14'    => '$', // h}[N
		'15'    => self::$pictograms['d098'], //  1
		'16'    => self::$pictograms['d005'], // Ȃ
		'17'    => '', // lp 1
		'18'    => '', // lp 2
		'19'    => '', // H` 1
		'20'    => '', // H` 2
		'21'    => '', // lp 1
		'22'    => '', // lp 2
		'23'    => '', // H` 1
		'24'    => '', // H` 2
		'25'    => self::$pictograms['d220'], // rv
		'26'    => '+', // vX
		'27'    => '-', // }CiX
		'28'    => '', //  1
		'29'    => '', //  1
		'30'    => '', //  1
		'31'    => self::$pictograms['d245'], // ۂɎ΂ߐ
		'32'    => '', // Op 1
		'33'    => '', // Op 1
		'34'    => '', // Op 2
		'35'    => '', // Op 2
		'36'    => '', // H` 1
		'37'    => '', // H` 2
		'38'    => '', // lp 1
		'39'    => '', // lp 2
		'40'    => '', //  1
		'41'    => '', //  2
		'42'    => self::$pictograms['d090'], //  2 ()
		'43'    => self::$pictograms['d089'], //  2 (E)
		'44'    => self::$pictograms['d001'], // z
		'45'    => self::$pictograms['d022'], // 싅{[
		'46'    => self::$pictograms['d176'], // v
		'47'    => self::$pictograms['d097'], //  2 ()
		'48'    => self::$pictograms['d208'], // x
		'49'    => '[e]', // vbVs (e)
		'50'    => self::$pictograms['d170'], // 
		'51'    => self::$pictograms['d136'], // n[g
		'52'    => self::$pictograms['d052'], // }eB[j (JNeOX)
		'53'    => self::$pictograms['d254'], // lt
		'54'    => self::$pictograms['d239'], // g[h}[N (TM)
		'55'    => '~', // 
		'56'    => self::$pictograms['d076'], //  1
		'57'    => self::$pictograms['d217'], // v 1
		'58'    => self::$pictograms['d217'], // v 2
		'59'    => '[tbs[]', // tbs[fBXN 1
		'60'    => '*', // ̌
		'61'    => '~', // oc 1
		'62'    => '~', // oc 2
		'63'    => '', // E 1
		'64'    => '', //  1
		'65'    => self::$pictograms['d053'], // }OJbv
		'66'    => '', // 
		'67'    => '[J_[]', // J_[
		'68'    => self::$pictograms['d140'], // X}CtFCX
		'69'    => '', //  2
		'70'    => self::$pictograms['d059'], // E 2 (E)
		'71'    => self::$pictograms['d104'], //  2 ()
		'72'    => self::$pictograms['d216'], // WG[
		'73'    => '', // `FbN}[N 1
		'74'    => self::$pictograms['d100'], //  (v[h)
		'75'    => '', //  3
		'76'    => self::$pictograms['d150'], // Xp[N
		'77'    => self::$pictograms['d151'], // d
		'78'    => self::$pictograms['d268'], // 
		'79'    => '[tH_]', // tH_ 1 ()
		'80'    => self::$pictograms['d140'], //  1
		'81'    => self::$pictograms['d238'], // Rs[Cg}[N (C)
		'82'    => self::$pictograms['d243'], // WX^[h}[N (R)
		'83'    => self::$pictograms['d069'], // u[tP[X (nhobN)
		'84'    => '[JtH_]', // tH_ 2 (J)
		'85'    => self::$pictograms['d074'], // db 1 (vbVz)
		'86'    => self::$pictograms['d076'], // oRg
		'87'    => '[NWbgJ[h]',// NWbgJ[h
		'88'    => '', // Op 3
		'89'    => '', // Op 3
		'90'    => '[USA]', // USA ()
		'91'    => self::$pictograms['d076'], // m[g 3
		'92'    => self::$pictograms['d076'], // Nbv{[h
		'93'    => self::$pictograms['d051'], // Jbv
		'94'    => self::$pictograms['d068'], // J
		'95'    => self::$pictograms['d003'], // J
		'96'    => '[tbg{[]', // tbg{[
		'97'    => self::$pictograms['d070'], // { 1
		'98'    => self::$pictograms['d245'], // ֎~
		'99'    => self::$pictograms['d048'], // M
		'100'   => self::$pictograms['d070'], // { 2
		'101'   => self::$pictograms['d070'], // { 3
		'102'   => self::$pictograms['d070'], // { 4
		'103'   => self::$pictograms['d076'], //  2
		'104'   => self::$pictograms['d056'], // ͂
		'105'   => '[J_[]', // Ђ߂J_[
		'106'   => self::$pictograms['d065'], // `PbgELbv
		'107'   => self::$pictograms['d002'], // 
		'108'   => self::$pictograms['d110'], // 
		'109'   => self::$pictograms['d113'], // ؎ (CHECK)
		'110'   => self::$pictograms['d058'], // rfIJ
		'111'   => self::$pictograms['d058'], // nfBJ
		'112'   => self::$pictograms['d038'], // 
		'113'   => self::$pictograms['d256'], //  (`[bv)
		'114'   => '[iCt]', // iCt
		'115'   => '[rfIe[v]', // rfIe[v
		'116'   => self::$pictograms['d093'], // ߂
		'117'   => '', //  1
		'118'   => self::$pictograms['d117'], //  2
		'119'   => self::$pictograms['d119'], // ނ߂
		'120'   => self::$pictograms['d116'], // 
		'121'   => self::$pictograms['d076'], // m[g 1
		'122'   => self::$pictograms['d076'], // m[g 2 (J)
		'123'   => '[{gƃibg]', // {g & ibg
		'124'   => self::$pictograms['d055'], //  (nCq[)
		'125'   => self::$pictograms['d033'], // 
		'126'   => '[tbs[]', // tbs[ 2
		'127'   => '[_Ot]', // `[g (_Ot)
		'128'   => '[܂Ot]', // Ot 1 (܂Ot)
		'129'   => self::$pictograms['d110'], // [{bNX
		'130'   => '[d]', // d
		'131'   => '[Roldex]', // Roldex
		'132'   => '', // `FbN}[N 2
		'134'   => self::$pictograms['d100'], // 
		'135'   => '[dr]', // dr
		'136'   => '[XN[]', // XN[
		'137'   => '[e]', // т傤
		'138'   => self::$pictograms['d116'], // O
		'139'   => self::$pictograms['d065'], // hD
		'140'   => '', // wmF
		'141'   => '', // wmFE
		'142'   => self::$pictograms['d070'], // 䒠
		'143'   => self::$pictograms['d237'], // Nbv
		'144'   => self::$pictograms['d072'], // v[g
		'145'   => '[D]', // D
		'146'   => self::$pictograms['d050'], // Sn 1 (iCtƃtH[N)
		'147'   => self::$pictograms['d070'], // {
		'148'   => '[gbN]', // gbN
		'149'   => self::$pictograms['d214'], // Gsc
		'150'   => '[IDO]', // S (PDC)
		'151'   => self::$pictograms['d106'], //  2
		'152'   => self::$pictograms['d213'], // `
		'153'   => self::$pictograms['d110'] . "", // M BOX
		'154'   => self::$pictograms['d106'], // M BOX
		'155'   => self::$pictograms['d074'], // db 2 (b)
		'156'   => self::$pictograms['d039'], // HE
		'157'   => '', // K 1 ()
		'158'   => '', // K 2 (Op)
		'159'   => '[܂Ot]', // Ot 2
		'160'   => self::$pictograms['d050'], // H 2 (}K)
		'161'   => self::$pictograms['d075'], // db 3 (g)
		'162'   => '[RZg]', // RZg
		'163'   => self::$pictograms['d170'], // Ƒ
		'164'   => self::$pictograms['d071'], // N
		'165'   => self::$pictograms['d072'], // pbP[W
		'166'   => self::$pictograms['d107'], // FAX
		'167'   => self::$pictograms['d001'] . self::$pictograms['d002'], // Ƃǂ܂
		'168'   => self::$pictograms['d037'], // s@
		'169'   => self::$pictograms['d102'], // {[g (D)
		'170'   => '[TCR]', // TCR
		'171'   => self::$pictograms['d076'], // V
		'172'   => self::$pictograms['d030'], // d
		'173'   => '@', // SuN
		'174'   => ' ', // uN
		'175'   => ' ', // 41uN
		'176'   => self::$pictograms['d066'], // i
		'177'   => self::$pictograms['d067'], // ։
		'178'   => self::$pictograms['d094'], // Ԉ֎q
		'179'   => '[S]', // t}[N
		'180'   => self::$pictograms['d125'], // lp 1
		'181'   => self::$pictograms['d126'], // lp 2
		'182'   => self::$pictograms['d127'], // lp 3
		'183'   => self::$pictograms['d128'], // lp 4
		'184'   => self::$pictograms['d129'], // lp 5
		'185'   => self::$pictograms['d130'], // lp 6
		'186'   => self::$pictograms['d131'], // lp 7
		'187'   => self::$pictograms['d132'], // lp 8
		'188'   => self::$pictograms['d133'], // lp 9
		'189'   => self::$pictograms['d134'], // lp 10
		'190'   => self::$pictograms['d006'], // 䕗
		'191'   => self::$pictograms['d004'], // 䂫
		'192'   => self::$pictograms['d009'], //  (Ђ)
		'193'   => self::$pictograms['d010'], //  ()
		'194'   => self::$pictograms['d011'], //  (oq)
		'195'   => self::$pictograms['d012'], //  (ɍ)
		'196'   => self::$pictograms['d013'], //  ()
		'197'   => self::$pictograms['d014'], //  (Ƃߍ)
		'198'   => self::$pictograms['d015'], //  (V)
		'199'   => self::$pictograms['d016'], //  ()
		'200'   => self::$pictograms['d017'], //  (č)
		'201'   => self::$pictograms['d018'], //  (€)
		'202'   => self::$pictograms['d019'], //  (r)
		'203'   => self::$pictograms['d020'], //  ()
		'204'   => '[֌]', //  (ւт)
		'205'   => self::$pictograms['d043'], // ATM
		'206'   => self::$pictograms['d045'], // 24 HOURS (Rrj)
		'207'   => self::$pictograms['d049'], // gC
		'208'   => self::$pictograms['d047'], // p[LO
		'209'   => self::$pictograms['d035'], // oX
		'210'   => self::$pictograms['d121'], // Aei (ʒu}[N)
		'211'   => self::$pictograms['d036'], // ` (}[N)
		'212'   => self::$pictograms['d042'], // s
		'213'   => self::$pictograms['d046'], // KXX^h
		'214'   => '[n}]', // n}
		'215'   => self::$pictograms['d218'], // ]
		'216'   => self::$pictograms['d035'], // oX
		'217'   => self::$pictograms['d032'], // V
		'218'   => self::$pictograms['d240'], // }\
		'219'   => self::$pictograms['d025'], // TbJ[
		'220'   => self::$pictograms['d024'], // ejX
		'221'   => self::$pictograms['d207'], // Xm[{[h
		'222'   => self::$pictograms['d028'], // `FbJ[tbO ([^[X|[c)
		'223'   => self::$pictograms['d060'], // Vn
		'224'   => self::$pictograms['d147'], // 
		'225'   => self::$pictograms['d264'], //  (Ԃ傤)
		'226'   => self::$pictograms['d167'], // f ()
		'227'   => self::$pictograms['d172'], // ̋
		'228'   => '[^[]', // ^[
		'229'   => '[777]', // Xbg (777)
		'230'   => '[]', //  (A^̂)
		'231'   => '', // I|
		'232'   => self::$pictograms['d078'], // Q[̃Rg[
		'233'   => self::$pictograms['d210'], // ܋
		'234'   => self::$pictograms['d103'], // NX}Xc[
		'235'   => self::$pictograms['d261'], // Ԍ ()
		'236'   => '[]', // 
		'237'   => '[{]', //  (jE̊)
		'238'   => '[Z]', // XCJ
		'239'   => self::$pictograms['d263'], // P[L
		'240'   => '[tCp]', // tCp (ڋʏĂ)
		'241'   => self::$pictograms['d255'], // 
		'242'   => '[͓]', // ӂ
		'243'   => '[]', // C`S
		'244'   => self::$pictograms['d262'], // ɂ
		'245'   => self::$pictograms['d054'], // no[K[ (t@[Xgt[h)
		'246'   => '[~]', // 
		'247'   => '[e]', // 
		'248'   => self::$pictograms['d273'], // 
		'249'   => '[]', // 
		'250'   => '[^]', // 
		'251'   => self::$pictograms['d101'], // L
		'252'   => self::$pictograms['d269'], // yM
		'253'   => '[a]', // 
		'254'   => self::$pictograms['d274'], // Ԃ
		'255'   => '[q̖]', // ₵̂
		'256'   => '[]', // Ђ܂
		'257'   => self::$pictograms['d140'], //  1 (ꂵJI)
		'258'   => self::$pictograms['d141'], //  2 (JI)
		'259'   => self::$pictograms['d143'], //  3 (ȂJI)
		'260'   => self::$pictograms['d144'], //  4 (ꂽJI)
		'261'   => self::$pictograms['d157'], //  (ZZZ...)
		'262'   => self::$pictograms['d152'], // { (Jb)
		'263'   => self::$pictograms['d235'], //  (܁E)
		'264'   => self::$pictograms['d229'], // 炩 (ׂ)
		'265'   => self::$pictograms['d138'], // n[g 2 (Ă)
		'266'   => self::$pictograms['d139'], // n[g 3 (傫 & )
		'267'   => self::$pictograms['d150'], // Xp[N 2 (L}[N)
		'268'   => self::$pictograms['d154'], // e
		'269'   => '[]', // 
		'270'   => '[SOS]', // { (SOS)
		'271'   => '[͂]', // ͂
		'272'   => '' . self::$pictograms['d136'], // n[g 5 (Ă)
		'273'   => self::$pictograms['d149'], // LX}[N
		'274'   => self::$pictograms['d170'], // Fl
		'275'   => self::$pictograms['d006'], // Ȃ
		'276'   => self::$pictograms['d091'], //  ()
		'277'   => '' . self::$pictograms['d225'] . '', // 
		'278'   => self::$pictograms['d155'], // Ԋ
		'279'   => self::$pictograms['d241'], // ۔
		'280'   => '[100__]', // 100__
		'281'   => self::$pictograms['d153'], // p`
		'282'   => self::$pictograms['d164'], // _bV
		'283'   => '[E`]', // E`}[N
		'284'   => '', // lwTC
		'285'   => '()', // }
		'286'   => '[hN]', // ǂ
		'287'   => self::$pictograms['d228'], // уTC (w)
		'288'   => self::$pictograms['d077'], // er
		'289'   => self::$pictograms['d057'], // }CN
		'290'   => self::$pictograms['d204'], // z
		'291'   => self::$pictograms['d155'], // fB
		'292'   => '[M^[]', // M^[ (GL)
		'293'   => '[oCI]', // oCI (NVbN)
		'294'   => self::$pictograms['d061'], // wbhtH
		'295'   => self::$pictograms['d205'], // g
		'296'   => '[sXg]', // ANV (sXg)
		'297'   => '[GXe]', // GXe
		'298'   => '[EZ]', // EZ }[N
		'299'   => self::$pictograms['d114'], //  (FREE)
		'300'   => self::$pictograms['d079'], // CD/DVD
		'301'   => self::$pictograms['d203'], // wl
		'302'   => '[UFO]', // UFO
		'303'   => self::$pictograms['d150'], // XV (UP!)
		'304'   => '[]', // ˊ ()
		'305'   => self::$pictograms['d007'], // 
		'306'   => self::$pictograms['d023'], // St
		'307'   => self::$pictograms['d027'], // oXPbg{[
		'308'   => self::$pictograms['d029'], // |Pbgx
		'309'   => self::$pictograms['d062'], // A[g
		'310'   => self::$pictograms['d063'], // 
		'311'   => self::$pictograms['d064'], // Cxg (T[JX)
		'312'   => self::$pictograms['d071'], // {
		'313'   => self::$pictograms['d073'], // o[Xf[
		'314'   => self::$pictograms['d081'], // Xy[h
		'315'   => self::$pictograms['d082'], // _C
		'316'   => self::$pictograms['d083'], // Nu
		'317'   => self::$pictograms['d084'], // 
		'318'   => self::$pictograms['d085'], // 
		'319'   => self::$pictograms['d087'], //  (`L)
		'320'   => self::$pictograms['d088'], //  (p[)
		'321'   => self::$pictograms['d095'], // V
		'322'   => self::$pictograms['d096'], // ⌇
		'323'   => self::$pictograms['d097'], // 
		'324'   => self::$pictograms['d118'], // NA
		'325'   => self::$pictograms['d134'], // lp 0
		'326'   => self::$pictograms['d135'], //  (OK)
		'327'   => self::$pictograms['d144'], // ӂӂ ()
		'328'   => self::$pictograms['d148'], // 킢
		'329'   => self::$pictograms['d161'], // ǂ (Ռ)
		'330'   => self::$pictograms['d162'], //  (юU銾)
		'331'   => '[ezplus]', // C[W[vX
		'332'   => '[n]', // n
		'333'   => self::$pictograms['d265'], // [
		'334'   => self::$pictograms['d120'], // NEW
		'335'   => self::$pictograms['d203'], // am
		'336'   => self::$pictograms['d092'], // amC
		'337'   => self::$pictograms['d211'], // p\R
		'338'   => self::$pictograms['d061'], // WI
		'339'   => '[KN]', // o
		'340'   => self::$pictograms['d208'], // `y
		'341'   => self::$pictograms['d031'], // nS
		'342'   => self::$pictograms['d253'], // xmR
		'343'   => self::$pictograms['d061'], // 
		'344'   => '[Vg]', // Vg
		'345'   => '[]', // g
		'346'   => '[F]', // 
		'347'   => '[l]', // ˂
		'348'   => self::$pictograms['d230'], // EBN ()
		'349'   => self::$pictograms['d227'], // ڂn[g ()
		'350'   => self::$pictograms['d276'], // VbLO ()
		'351'   => self::$pictograms['d221'], //  ()
		'352'   => '[]', // 
		'353'   => '[Pbg]', // Pbg
		'354'   => self::$pictograms['d215'], // 
		'355'   => self::$pictograms['d149'], // `[ (LXĂ)
		'356'   => '[n}[]', // n}[
		'357'   => '[ԉ]', // łグԉ
		'358'   => self::$pictograms['d260'], // ͂t
		'359'   => self::$pictograms['d069'], // d΂
		'360'   => '[]', // 
		'361'   => '[Lv]', // Lv
		'362'   => '[]', // 
		'363'   => '[VS]', // VS (o[TX)
		'364'   => '[gtB[]', // gtB[
		'365'   => '[T]', // J
		'366'   => '[XyC]', // XyC
		'367'   => '[VA]', // VA
		'368'   => '[H]', // H
		'369'   => self::$pictograms['d147'], // C
		'370'   => '[j]', // j}[N
		'371'   => '[[]', // [X
		'372'   => '[]', // 
		'373'   => '[]', // 
		'374'   => '[x@]', // |X
		'375'   => self::$pictograms['d040'], // X֋
		'376'   => self::$pictograms['d041'], // a@
		'377'   => self::$pictograms['d251'], // wZ
		'378'   => self::$pictograms['d044'], // ze
		'379'   => self::$pictograms['d036'], // D
		'380'   => self::$pictograms['d245'], // 18
		'381'   => '[.i|]', // 
		'382'   => '[COOL!]', // COOL!
		'383'   => '[]', // }[N
		'384'   => '[T]', // UE}[N
		'385'   => self::$pictograms['d115'], // ID}[N
		'386'   => self::$pictograms['d248'], // }[N
		'387'   => self::$pictograms['d246'], // }[N
		'388'   => '[w]', // w}[N
		'389'   => '[c]', // cƒ}[N
		'390'   => '', // w
		'391'   => '', // w
		'392'   => '[肢]', // 肢 ()
		'393'   => self::$pictograms['d075'], // }i[[h
		'394'   => self::$pictograms['d075'], // dOFF
		'395'   => self::$pictograms['d076'], // 
		'396'   => '[lN^C]', // lN^C
		'397'   => self::$pictograms['d148'], // nCrXJX
		'398'   => self::$pictograms['d148'], // ԑ
		'399'   => '[T{e]', // T{e
		'400'   => self::$pictograms['d264'], // q & t
		'401'   => self::$pictograms['d053'], // t (r[)
		'402'   => '[j]', // j}[N
		'403'   => '[]', // ז (JvZ)
		'404'   => '[D]', // D
		'405'   => '[NbJ[]', // NbJ[
		'406'   => '[eznavi]', // eznavigation
		'407'   => '[Xq]', // Xq
		'408'   => self::$pictograms['d092'], // Ou[c
		'409'   => self::$pictograms['d205'], // lC
		'410'   => self::$pictograms['d056'], // e@
		'411'   => '[X]', // 
		'412'   => '[]', // 
		'413'   => self::$pictograms['d021'], // rLj
		'414'   => self::$pictograms['d080'], // n[g (gv)
		'415'   => self::$pictograms['d136'], // n[g
		'416'   => self::$pictograms['d136'], // n[g
		'417'   => self::$pictograms['d136'], // ΃n[g
		'418'   => self::$pictograms['d136'], // n[g
		'419'   => self::$pictograms['d136'], // n[g
		'420'   => self::$pictograms['d150'], // 炫
		'421'   => self::$pictograms['d026'], // XL[
		'422'   => '', // 
		'423'   => self::$pictograms['d219'], // {
		'424'   => self::$pictograms['d266'], // Hp
		'425'   => '[\tgN[]', // \tgN[
		'426'   => '[|eg]', // |eg
		'427'   => '[cq]', // 
		'428'   => '[]', // ׂ
		'429'   => '[]', // ͂
		'430'   => '[XpQeB]', // XpQeB
		'431'   => '[J[]', // J[
		'432'   => '[ł]', // ł
		'433'   => '[i]', // i
		'434'   => self::$pictograms['d258'], // 
		'435'   => '[]', // ݂
		'436'   => '[g}g]', // g}g
		'437'   => '[֎q]', // Ȃ
		'438'   => '[ٓ]', // ٓ
		'439'   => '[]', // 
		'440'   => self::$pictograms['d222'], // ӂ ()
		'441'   => self::$pictograms['d142'], // ڂ ()
		'442'   => self::$pictograms['d231'], // ւ ()
		'443'   => self::$pictograms['d143'], // s ()
		'444'   => self::$pictograms['d221'], // 킩
		'445'   => self::$pictograms['d157'], // 
		'446'   => self::$pictograms['d223'], // ĂĂ ()
		'447'   => self::$pictograms['d224'], //  ()
		'448'   => self::$pictograms['d232'], // ׂЂ
		'449'   => self::$pictograms['d225'], // M ()
		'450'   => self::$pictograms['d226'], //  ()
		'451'   => self::$pictograms['d276'], // т ()
		'452'   => self::$pictograms['d224'], //  ()
		'453'   => self::$pictograms['d155'], // y
		'454'   => self::$pictograms['d231'], // ɂɂ ()
		'455'   => self::$pictograms['d227'], // `[ 2 ()
		'456'   => self::$pictograms['d227'], // `b ()
		'457'   => '[@]', // @
		'458'   => self::$pictograms['d149'], // 
		'459'   => '[S]', // S^肢
		'460'   => self::$pictograms['d088'] . self::$pictograms['d088'], // 
		'461'   => self::$pictograms['d135'], // OK! (wŊۃTC)
		'462'   => self::$pictograms['d156'], // u[CO (w)
		'463'   => self::$pictograms['d088'], // oCoC
		'464'   => self::$pictograms['d236'], // NG (lR)
		'465'   => self::$pictograms['d135'], // OK! 2 (lR)
		'466'   => '[S]', // ӂ (lR)
		'467'   => '[Jbv]', // Jbv
		'468'   => '[oj[]', // oj[
		'469'   => '[gybg]', // gybg
		'470'   => '[r[h]', // r[h
		'471'   => '[j]', // j
		'472'   => self::$pictograms['d033'], // h
		'473'   => self::$pictograms['d033'], // ~}
		'474'   => self::$pictograms['d033'], // pgJ[
		'475'   => self::$pictograms['d032'], // WFbgR[X^[
		'476'   => '[叼]', // 叼
		'477'   => '[Ղ]', // Ղ
		'478'   => '[Ǝ]', // Ǝ
		'479'   => '[w]', // w
		'480'   => self::$pictograms['d270'], // ̂ڂ
		'481'   => self::$pictograms['d008'], // P
		'482'   => self::$pictograms['d170'], // ԉ
		'483'   => '[X]', // X
		'484'   => '[ԉ]', // ԉ
		'485'   => '[L]', // L
		'486'   => '[]', // 
		'487'   => '[nEB]', // nEB
		'488'   => self::$pictograms['d172'], // 
		'489'   => '[T^]', // T^
		'490'   => self::$pictograms['d172'], // ^ꐯ
		'491'   => '[]', // 
		'492'   => self::$pictograms['d044'], // ze 2
		'493'   => self::$pictograms['d001'], // ̏o
		'494'   => self::$pictograms['d063'], // VNnbg
		'495'   => self::$pictograms['d039'], // fp[g
		'496'   => self::$pictograms['d039'], //  ({)
		'497'   => self::$pictograms['d039'], //  ([bp)
		'498'   => self::$pictograms['d039'], // H 2
		'499'   => '[tX]', // tX
		'500'   => '[I[vEF[u]',// I[vEF[u
		'501'   => self::$pictograms['d116'], // bNmF
		'502'   => '[ABC]', // 啶
		'503'   => '[abc]', // 
		'504'   => '[012]', // 
		'505'   => '[,@#]', // L
		'506'   => '[]', // ANZvg
		'507'   => '', // `FbN{bNX
		'508'   => self::$pictograms['d169'], // GfBbg
		'509'   => '', // WI{^
		'510'   => self::$pictograms['d119'], //  (ዾ)
		'511'   => self::$pictograms['d117'], // ߂
		'512'   => self::$pictograms['d076'], // Cɓ
		'513'   => self::$pictograms['d175'], // I
		'514'   => self::$pictograms['d038'], // z[
		'515'   => self::$pictograms['d106'], // M 1
		'516'   => '', // }[N
		'517'   => self::$pictograms['d116'], // l ()
		'518'   => self::$pictograms['d242'], // ēǂݍ
		'700'   => '[hCc]', // hCc
		'701'   => '[C^A]', // C^A
		'702'   => '[CMX]', // CMX
		'703'   => '[]', // 
		'704'   => '[؍]', // ؍
		'705'   => '[l]', // l
		'706'   => '[l]', // l
		'707'   => '[Chl]', // Chl
		'708'   => self::$pictograms['d170'], // 
		'709'   => self::$pictograms['d170'], // ΂
		'710'   => self::$pictograms['d222'], // Ԃ
		'711'   => self::$pictograms['d170'], // H̐l
		'712'   => self::$pictograms['d170'], // Pl
		'713'   => self::$pictograms['d270'], // CJ
		'714'   => '[_X]', // _X
		'715'   => self::$pictograms['d270'], // Mы
		'716'   => '[ђ]', // 
		'717'   => '[]', // 
		'718'   => '[RA]', // RA
		'719'   => '[]', // zX^C
		'720'   => '[]', // wr
		'721'   => self::$pictograms['d268'], // {
		'722'   => '[]', // ڂ
		'723'   => '[N_]', // ӂԂ炭
		'724'   => '[A^]', // A^
		'725'   => '[B^]', // B^
		'726'   => '[O^]', // O^
		'727'   => '[AB^]', // AB^
		'728'   => self::$pictograms['d091'], // 
		'729'   => self::$pictograms['d092'], // Xj[J[
		'730'   => self::$pictograms['d121'], // 
		'731'   => self::$pictograms['d145'], // J[u
		'732'   => self::$pictograms['d156'], // J[u
		'733'   => self::$pictograms['d159'], // u!?v
		'734'   => self::$pictograms['d160'], // u!!v
		'735'   => self::$pictograms['d166'], // 
		'736'   => '[]', // 
		'737'   => '[pCibv]', // pCibv
		'738'   => '[]', // Ԃǂ
		'739'   => self::$pictograms['d257'], // oii
		'740'   => '[Ƃ낱]', // Ƃ낱
		'741'   => '[̂]', // ̂
		'742'   => '[I]', // I
		'743'   => '[]', // 
		'744'   => '[Ĉ]', // ₫
		'745'   => '[sU]', // sU
		'746'   => '[^[L[]', // ^[L[
		'747'   => '[[]', // [
		'748'   => self::$pictograms['d275'], // gsJhN
		'749'   => '[C]', // C
		'750'   => '[sAm]', // sAm
		'751'   => self::$pictograms['d252'], // T[tB
		'752'   => self::$pictograms['d270'], // ނ
		'753'   => '[{EO]', // {EO
		'754'   => '[Ȃ܂͂]', // Ȃ܂͂
		'755'   => self::$pictograms['d225'], // V
		'756'   => '[p_]', // p_
		'757'   => self::$pictograms['d229'], // ׁ[
		'758'   => self::$pictograms['d274'], // Ԃ̕@
		'759'   => self::$pictograms['d148'], // 
		'760'   => '[ACXN[]', // ACXN[
		'761'   => '', // h[ic
		'762'   => '[NbL[]', // NbL[
		'763'   => '[`R]', // `R
		'764'   => '[LfB]', // LfB ()
		'765'   => '[؂؂LfB]',// LfB (؂؂)
		'766'   => '(/__)', //  ()
		'767'   => '(ExE)', // 킴 ()
		'768'   => '|(E_E)|', //  ()
		'769'   => self::$pictograms['d253'], // ΎR
		'770'   => self::$pictograms['d136'] . self::$pictograms['d071'], // {̃n[g
		'771'   => '[ABC]', // puABCv
		'772'   => '[v]', // v
		'773'   => '[I]', // ~co`
		'774'   => '[ĂƂ]', // egEV
		'775'   => '[I|bg]', // I|bg
		'776'   => self::$pictograms['d258'], // 
		'777'   => self::$pictograms['d113'], // Ĥ͂D
		'778'   => self::$pictograms['d006'], // ڂ܂鎞̋L
		'779'   => self::$pictograms['d225'], // Ձ[ (킢{)
		'780'   => self::$pictograms['d225'], // Ձ[ (킢{) (lR)
		'781'   => self::$pictograms['d172'], // V̐
		'782'   => self::$pictograms['d227'], // `[ (lR)
		'783'   => self::$pictograms['d231'], // ɂ (lR)
		'784'   => self::$pictograms['d106'], // [
		'785'   => self::$pictograms['d231'], // ΂ (lR)
		'786'   => self::$pictograms['d231'], // ΂ ()
		'787'   => self::$pictograms['d227'], // ڂn[g (lR)
		'788'   => self::$pictograms['d234'], // ق[ (lR)
		'789'   => self::$pictograms['d234'], // ق[ ()
		'790'   => self::$pictograms['d235'], // ܂ۂ (lR)
		'791'   => self::$pictograms['d235'], // ܂ۂ ()
		'792'   => self::$pictograms['d226'], //  (lR)
		'793'   => '[hX]', // hX
		'794'   => '[C]', // C
		'795'   => '[w]', // w
		'796'   => '[ԎD]', // ԎD
		'797'   => '[W[J[]', // W[J[
		'798'   => '[CVtC]', // GrtC
		'799'   => self::$pictograms['d110'], // e[ACR
		'800'   => self::$pictograms['d240'], // l
		'801'   => '[pgJ[]', // pgJ[̃v
		'802'   => self::$pictograms['d058'], // ezmovie
		'803'   => self::$pictograms['d137'], // hLhLĂn[g
		'804'   => self::$pictograms['d268'], // ʌ̂Ђ悱
		'805'   => self::$pictograms['d206'], // W[Y
		'806'   => self::$pictograms['d212'], // n[g[
		'807'   => self::$pictograms['d242'], // z
		'808'   => self::$pictograms['d249'], // E
		'809'   => self::$pictograms['d250'], // ㉺
		'810'   => self::$pictograms['d252'], // rg
		'811'   => self::$pictograms['d259'], // ot
		'812'   => self::$pictograms['d267'], // ނ
		'813'   => self::$pictograms['d272'], //  (lR)
		'814'   => self::$pictograms['d272'], //  ()
		'815'   => self::$pictograms['d110'], // C[ACR
		'816'   => self::$pictograms['d259'], // n[u
		'817'   => self::$pictograms['d086'], //  (O[)
		'818'   => self::$pictograms['d123'], // u#v
		'819'   => self::$pictograms['d140'], //  (LN^[)
		'820'   => self::$pictograms['d231'], //  (LN^[)
		'821'   => self::$pictograms['d142'], // ڂ (LN^[)
		'822'   => self::$pictograms['d225'], // 킢{ (LN^[)
		'se001' => self::$pictograms['d140'], // j̎q
		'se002' => self::$pictograms['d140'], // ̎q
		'se003' => self::$pictograms['d149'], // e (LX}[N)
		'se004' => self::$pictograms['d140'], // 
		'se005' => self::$pictograms['d140'], // ꂳ
		'se006' => self::$pictograms['d203'], // m
		'se007' => self::$pictograms['d092'], // u[c
		'se008' => self::$pictograms['d068'], // J
		'se009' => self::$pictograms['d074'], // db
		'se00a' => self::$pictograms['d075'], // gѓdb
		'se00b' => self::$pictograms['d107'], // FAX
		'se00c' => self::$pictograms['d211'], // p\R
		'se00d' => self::$pictograms['d153'], // p`
		'se00e' => self::$pictograms['d228'], // GOOD!
		'se00f' => '[No.1!]', // No.1!
		'se010' => self::$pictograms['d086'], // O[
		'se011' => self::$pictograms['d087'], // `L
		'se012' => self::$pictograms['d088'], // p[
		'se013' => self::$pictograms['d026'], // XL[
		'se014' => self::$pictograms['d023'], // St
		'se015' => self::$pictograms['d024'], // ejX
		'se016' => self::$pictograms['d022'], // 싅
		'se017' => self::$pictograms['d207'], // T[tB
		'se018' => self::$pictograms['d025'], // TbJ[
		'se019' => self::$pictograms['d270'], // 
		'se01a' => self::$pictograms['d273'], // 
		'se01b' => self::$pictograms['d033'], // 
		'se01c' => self::$pictograms['d102'], // bg
		'se01d' => self::$pictograms['d037'], // s@
		'se01e' => self::$pictograms['d030'], // d
		'se01f' => self::$pictograms['d032'], // V
		'se020' => '?', // nei
		'se021' => self::$pictograms['d158'], // rbN
		'se022' => self::$pictograms['d136'], // n[g}[N
		'se023' => self::$pictograms['d138'], // n[guCN
		'se024' => self::$pictograms['d176'], // 1
		'se025' => self::$pictograms['d176'], // 2
		'se026' => self::$pictograms['d176'], // 3
		'se027' => self::$pictograms['d176'], // 4
		'se028' => self::$pictograms['d176'], // 5
		'se029' => self::$pictograms['d176'], // 6
		'se02a' => self::$pictograms['d176'], // 7
		'se02b' => self::$pictograms['d176'], // 8
		'se02c' => self::$pictograms['d176'], // 9
		'se02d' => self::$pictograms['d176'], // 10
		'se02e' => self::$pictograms['d176'], // 11
		'se02f' => self::$pictograms['d176'], // 12
		'se030' => self::$pictograms['d176'], // Ԍ
		'se031' => self::$pictograms['d215'], // Gu
		'se032' => self::$pictograms['d261'], // o
		'se033' => self::$pictograms['d103'], // NX}X
		'se034' => self::$pictograms['d216'], // w
		'se035' => self::$pictograms['d216'], // 
		'se036' => self::$pictograms['d038'], // 
		'se037' => '[]', // 
		'se038' => self::$pictograms['d039'], // r
		'se039' => '[w]', // w
		'se03a' => self::$pictograms['d046'], // K\X^h
		'se03b' => self::$pictograms['d253'], // R
		'se03c' => self::$pictograms['d057'], // }CN
		'se03d' => self::$pictograms['d058'], // f
		'se03e' => self::$pictograms['d146'], // y
		'se03f' => self::$pictograms['d116'], // JM
		'se040' => '[TbNX]', // TbNX
		'se041' => '[M^[]', // M^[
		'se042' => '[gybg]', // gybg
		'se043' => self::$pictograms['d050'], // Xg
		'se044' => self::$pictograms['d052'], // JNe
		'se045' => self::$pictograms['d051'], // R[q[
		'se046' => self::$pictograms['d263'], // P[L
		'se047' => self::$pictograms['d053'], // r[
		'se048' => self::$pictograms['d004'], // 
		'se049' => self::$pictograms['d002'], // ܂
		'se04a' => self::$pictograms['d001'], //  ()
		'se04b' => self::$pictograms['d003'], // J
		'se04c' => self::$pictograms['d098'], //  ()
		'se04d' => self::$pictograms['d001'], // 
		'se04e' => '[Vg]', // Vg
		'se04f' => self::$pictograms['d101'], // ˂
		'se050' => '[]', // Ƃ
		'se051' => '[F]', // 
		'se052' => self::$pictograms['d100'], // 
		'se053' => '[l]', // ˂
		'se054' => '[~]', // NW
		'se055' => self::$pictograms['d269'], // yM
		'se056' => self::$pictograms['d140'], // y ()
		'se057' => self::$pictograms['d231'], //  ()
		'se058' => self::$pictograms['d142'], //  ()
		'se059' => self::$pictograms['d141'], // { ()
		'se05a' => '[E`]', // E`
		'se101' => self::$pictograms['d106'], // [M
		'se102' => self::$pictograms['d110'] . '', // [M
		'se103' => self::$pictograms['d106'], // [
		'se104' => self::$pictograms['d105'], // dbA
		'se105' => self::$pictograms['d229'], // AJx[ ()
		'se106' => self::$pictograms['d227'], // uu ()
		'se107' => self::$pictograms['d276'], // Kr[ ()
		'se108' => self::$pictograms['d224'], // ^[ ()
		'se109' => '[]', // 
		'se10a' => '[]', // ^R
		'se10b' => self::$pictograms['d274'], // Ԃ
		'se10c' => self::$pictograms['d170'], // Fl
		'se10d' => '[Pbg]', // Pbg
		'se10e' => self::$pictograms['d215'], // 
		'se10f' => self::$pictograms['d151'], // d
		'se110' => self::$pictograms['d254'], // 
		'se111' => self::$pictograms['d149'], // LX
		'se112' => self::$pictograms['d072'], // o[Xf[ (v[g)
		'se113' => '[sXg]', // sXg
		'se114' => self::$pictograms['d119'], // ዾ
		'se115' => self::$pictograms['d240'], // 
		'se116' => '[I[NV]', // I[NV
		'se117' => self::$pictograms['d150'], // ԉ
		'se118' => self::$pictograms['d260'], // ݂
		'se119' => self::$pictograms['d260'], // t
		'se11a' => '[]', // 
		'se11b' => '[]', // ΂
		'se11c' => '[hN]', // hN
		'se11d' => '[]', // t@C[
		'se11e' => self::$pictograms['d069'], // ΂
		'se11f' => self::$pictograms['d171'], // 
		'se120' => self::$pictograms['d054'], // no[K[
		'se121' => '[]', // 
		'se122' => '[Lv]', // Lv
		'se123' => self::$pictograms['d147'], // 
		'se124' => self::$pictograms['d060'], // Vn
		'se125' => self::$pictograms['d065'], // `Pbg
		'se126' => self::$pictograms['d079'], // CD
		'se127' => self::$pictograms['d079'], // DVD
		'se128' => self::$pictograms['d061'], // WI
		'se129' => '[rfI]', // rfI
		'se12a' => self::$pictograms['d077'], // er
		'se12b' => self::$pictograms['d078'], // Q[
		'se12c' => self::$pictograms['d146'], // ̂o
		'se12d' => '[]', // }[W
		'se12e' => '[VS]', // Ό
		'se12f' => self::$pictograms['d210'], // ܋ (h)
		'se130' => '[]', // 
		'se131' => '[gtB[]', // gtB[
		'se132' => self::$pictograms['d028'], // S[ (`FbJ[tbO)
		'se133' => '[777]', // Xbg (777)
		'se134' => self::$pictograms['d273'], // n
		'se135' => self::$pictograms['d102'], // 
		'se136' => self::$pictograms['d218'], // 
		'se137' => '[H]', // H
		'se138' => '', // j
		'se139' => '', // 
		'se13a' => '[Ԃ]', // c
		'se13b' => '[]', // ˊ
		'se13c' => self::$pictograms['d157'], //  (Zzz)
		'se13d' => self::$pictograms['d005'], // 
		'se13e' => self::$pictograms['d055'], // nCq[
		'se13f' => self::$pictograms['d147'], // 
		'se140' => self::$pictograms['d049'], // gC
		'se141' => '[]', // 
		'se142' => '[Kz]', // m点 (Kz)
		'se143' => '[j]', // j
		'se144' => self::$pictograms['d116'], // bNON
		'se145' => self::$pictograms['d116'], // bNOFF
		'se146' => '[X]', // X
		'se147' => '[]', //  ()
		'se148' => self::$pictograms['d070'], // {
		'se149' => '[$\\]', // ב֑
		'se14a' => '[]', // 
		'se14b' => '[p{]', // j[X (p{Aei)
		'se14c' => '[͂]', // C (͂)
		'se14d' => self::$pictograms['d042'], // s
		'se14e' => self::$pictograms['d048'], // M
		'se14f' => self::$pictograms['d047'], // ԏ
		'se150' => self::$pictograms['d035'], // oX
		'se151' => self::$pictograms['d049'], // OgC
		'se152' => '[]', // 
		'se153' => self::$pictograms['d040'], // X֋
		'se154' => self::$pictograms['d043'], // ATM
		'se155' => self::$pictograms['d041'], // a@
		'se156' => self::$pictograms['d045'], // Rrj
		'se157' => self::$pictograms['d251'], // wZ
		'se158' => self::$pictograms['d044'], // ze
		'se159' => self::$pictograms['d035'], // oX
		'se15a' => self::$pictograms['d033'], // ^NV[
		'se201' => self::$pictograms['d240'], // k
		'se202' => self::$pictograms['d036'], // D
		'se203' => '[RR]', // ړIn (RR)
		'se204' => self::$pictograms['d148'], // r1
		'se205' => self::$pictograms['d148'], // r2
		'se206' => self::$pictograms['d148'], // r3
		'se207' => self::$pictograms['d245'], // 18
		'se208' => self::$pictograms['d067'], // ։
		'se209' => '[S]', // S
		'se20a' => self::$pictograms['d094'], // oAt[ (Ԉ֎q}[N)
		'se20b' => '[.i|]', // Aei}[N
		'se20c' => self::$pictograms['d080'], // n[g (gv)
		'se20d' => self::$pictograms['d082'], // _C (gv)
		'se20e' => self::$pictograms['d081'], // Xy[h (gv)
		'se20f' => self::$pictograms['d083'], // Nu (gv)
		'se210' => self::$pictograms['d123'], // V[v_C
		'se211' => self::$pictograms['d122'], // t[_C
		'se212' => self::$pictograms['d120'], // V
		'se213' => self::$pictograms['d150'], // XV
		'se214' => self::$pictograms['d093'], //  (COOL)
		'se215' => self::$pictograms['d113'], // L
		'se216' => self::$pictograms['d114'], // 
		'se217' => '[]', // z
		'se218' => '[\]', // \
		'se219' => '', // o{^1 (IW)
		'se21a' => '', // o{^2 ()
		'se21b' => '', // o{^4 ()
		'se21c' => self::$pictograms['d125'], // 1 (one)
		'se21d' => self::$pictograms['d126'], // 2 (two)
		'se21e' => self::$pictograms['d127'], // 3 (three)
		'se21f' => self::$pictograms['d128'], // 4 (four)
		'se220' => self::$pictograms['d129'], // 5 (five)
		'se221' => self::$pictograms['d130'], // 6 (six)
		'se222' => self::$pictograms['d131'], // 7 (seven)
		'se223' => self::$pictograms['d132'], // 8 (eight)
		'se224' => self::$pictograms['d133'], // 9 (nine)
		'se225' => self::$pictograms['d134'], // 0 (zero)
		'se226' => '[]', // 
		'se227' => '[]', // 
		'se228' => '[T]', // T[rX
		'se229' => self::$pictograms['d115'], // ID
		'se22a' => self::$pictograms['d248'], // 
		'se22b' => self::$pictograms['d246'], // 
		'se22c' => '[w]', // w
		'se22d' => '[c]', // cƎ
		'se22e' => '', //  (w)
		'se22f' => '', //  (w)
		'se230' => '', //  (w)
		'se231' => '', // E (w)
		'se232' => '', // 
		'se233' => '', // 
		'se234' => '', // E
		'se235' => '', // 
		'se236' => self::$pictograms['d059'], // E
		'se237' => self::$pictograms['d090'], // 
		'se238' => self::$pictograms['d089'], // E
		'se239' => self::$pictograms['d104'], // 
		'se23a' => '', // 
		'se23b' => '', // O
		'se23c' => '', //  
		'se23d' => '', // ߂
		'se23e' => '[]', // 
		'se23f' => self::$pictograms['d009'], // Ђ
		'se240' => self::$pictograms['d010'], // 
		'se241' => self::$pictograms['d011'], // ӂ
		'se242' => self::$pictograms['d012'], // ɍ
		'se243' => self::$pictograms['d013'], // 
		'se244' => self::$pictograms['d014'], // Ƃߍ
		'se245' => self::$pictograms['d015'], // Ă҂
		'se246' => self::$pictograms['d016'], // 
		'se247' => self::$pictograms['d017'], // č
		'se248' => self::$pictograms['d018'], // €
		'se249' => self::$pictograms['d019'], // ݂ߍ
		'se24a' => self::$pictograms['d020'], // 
		'se24b' => '[֌]', // ւт
		'se24c' => '[TOP]', // TOPy[W
		'se24d' => self::$pictograms['d135'], // OK{^
		'se24e' => self::$pictograms['d238'], // 쌠 (C)
		'se24f' => self::$pictograms['d243'], // o^W (R)
		'se250' => self::$pictograms['d075'], // }i[[h
		'se251' => self::$pictograms['d075'], // d
		'se252' => self::$pictograms['d244'], //  (!)
		'se253' => self::$pictograms['d170'], // ē
		'se254' => self::$pictograms['d039'], // J-PHONEVbv
		'se255' => self::$pictograms['d012'], // XJCEFu
		'se256' => self::$pictograms['d110'], // XJCEH[J[
		'se257' => self::$pictograms['d146'] . self::$pictograms['d106'] , // XJCfB
		'se258' => 'J-', // J-PHONE 1
		'se259' => 'Pho', // J-PHONE 2
		'se25a' => 'ne', // J-PHONE 3
		'se301' => self::$pictograms['d076'], // 
		'se302' => '[lN^C]', // lN^C
		'se303' => self::$pictograms['d148'], // nCrXJX
		'se304' => self::$pictograms['d256'], // `[bv
		'se305' => self::$pictograms['d148'], // Ђ܂
		'se306' => self::$pictograms['d150'], // ԑ
		'se307' => '[q̖]', // ₵̖
		'se308' => '[T{e]', // T{e
		'se309' => self::$pictograms['d049'], // gC
		'se30a' => self::$pictograms['d061'], // wbhz
		'se30b' => self::$pictograms['d264'], // ӎ (Ƃ)
		'se30c' => self::$pictograms['d053'], // t (r[)
		'se30d' => '(j)', // j
		'se30e' => self::$pictograms['d066'], // i
		'se30f' => '[]', // JvZ
		'se310' => '[D]', // D
		'se311' => self::$pictograms['d154'], // e
		'se312' => '[NbJ[]', // NbJ[
		'se313' => self::$pictograms['d056'], // nT~
		'se314' => self::$pictograms['d071'], // {
		'se315' => self::$pictograms['d241'], // }
		'se316' => '[MD]', // MD
		'se317' => '[Kz]', // KtH
		'se318' => self::$pictograms['d063'], // Xq
		'se319' => '[hX]', // s[X
		'se31a' => self::$pictograms['d055'], // ~[
		'se31b' => '[u[c]', // Ou[c
		'se31c' => self::$pictograms['d205'], // g
		'se31d' => '[}jLA]', // }jLA
		'se31e' => '[GXe]', // GXe
		'se31f' => self::$pictograms['d056'], // e@
		'se320' => self::$pictograms['d056'], // X
		'se321' => '[]', // 
		'se322' => self::$pictograms['d021'], // rLj
		'se323' => self::$pictograms['d069'], // uhobO
		'se324' => self::$pictograms['d167'], // J`R
		'se325' => self::$pictograms['d208'], // 
		'se326' => self::$pictograms['d155'], // x鉹
		'se327' => self::$pictograms['d137'], // ҂҂n[g
		'se328' => self::$pictograms['d137'], // hLhLn[g
		'se329' => '' . self::$pictograms['d136'], // n[g˂Ƃ߂
		'se32a' => self::$pictograms['d136'], // n[g ()
		'se32b' => self::$pictograms['d136'], // n[g ()
		'se32c' => self::$pictograms['d136'], // n[g ()
		'se32d' => self::$pictograms['d136'], // n[g ()
		'se32e' => self::$pictograms['d150'], // NEW
		'se32f' => '', // 
		'se330' => self::$pictograms['d164'], // _bV
		'se331' => self::$pictograms['d162'], // юU銾
		'se332' => self::$pictograms['d099'], // 
		'se333' => '~', // ~
		'se334' => self::$pictograms['d152'], // {
		'se335' => '', //  (_)
		'se336' => '?', //  "?"
		'se337' => self::$pictograms['d158'], //  "!"
		'se338' => self::$pictograms['d219'], // 
		'se339' => self::$pictograms['d266'], // p
		'se33a' => '[\tgN[]', // \tgN[
		'se33b' => '[|eg]', // tCh|eg
		'se33c' => '[cq]', // cq 
		'se33d' => '[]', // ׂ
		'se33e' => self::$pictograms['d265'], // 
		'se33f' => '[XpQeB]', // XpQeB
		'se340' => self::$pictograms['d265'], // [
		'se341' => '[J[]', // J[CX
		'se342' => self::$pictograms['d262'], // ɂ
		'se343' => '[ł]', // ł
		'se344' => '[i]', // i
		'se345' => self::$pictograms['d258'], // 
		'se346' => '[]', // ݂
		'se347' => '[]', // 
		'se348' => '[Z]', // 
		'se349' => '[g}g]', // g}g
		'se34a' => '[֎q]', // Ȃ
		'se34b' => self::$pictograms['d073'], // o[Xf[P[L
		'se34c' => '[w]', // w
		'se34d' => '[]', // ix
		'se401' => self::$pictograms['d224'], //  ()
		'se402' => self::$pictograms['d233'], // قł ()
		'se403' => self::$pictograms['d221'], // Ђ炲߂Ȃ ()
		'se404' => self::$pictograms['d272'], // ւ ()
		'se405' => self::$pictograms['d230'], // EBN ()
		'se406' => self::$pictograms['d232'], // 킳т ()
		'se407' => self::$pictograms['d143'], // ڂ邮 ()
		'se408' => self::$pictograms['d157'], // @傤 ()
		'se409' => self::$pictograms['d229'], // ׁ[ ()
		'se40a' => self::$pictograms['d222'], //  ()
		'se40b' => self::$pictograms['d276'], // QQ ()
		'se40c' => '(##)', // }XN
		'se40d' => self::$pictograms['d231'], // 炪Ȃ
		'se40e' => self::$pictograms['d226'], // 炯
		'se40f' => self::$pictograms['d224'], // ⊾ ()
		'se410' => self::$pictograms['d144'], // т ()
		'se411' => self::$pictograms['d234'], //  ()
		'se412' => self::$pictograms['d234'], // ΂ ()
		'se413' => self::$pictograms['d235'], // Ăl
		'se414' => self::$pictograms['d140'], // ɂɂ ()
		'se415' => self::$pictograms['d231'], // ͂͂Ə΂ ()
		'se416' => self::$pictograms['d225'], // ߂߂{Ă ()
		'se417' => self::$pictograms['d227'], // KISS:
		'se418' => self::$pictograms['d227'], // KISS
		'se419' => self::$pictograms['d084'], // 
		'se41a' => '[@]', // @
		'se41b' => self::$pictograms['d085'], // 
		'se41c' => self::$pictograms['d149'], // 
		'se41d' => '[S]', // ߂Ȃ (킹)
		'se41e' => self::$pictograms['d088'], // oCoC (U)
		'se41f' => self::$pictograms['d088'] . self::$pictograms['d088'],// 
		'se420' => self::$pictograms['d135'], // OK (wŊۃTC)
		'se421' => self::$pictograms['d156'], // Booing (ew)
		'se422' => self::$pictograms['d088'], // ́`
		'se423' => self::$pictograms['d236'], // ~ (rNX)
		'se424' => self::$pictograms['d135'], //  (r𓪂)
		'se425' => self::$pictograms['d137'], // Ȃł
		'se426' => 'm(__)m', // y
		'se427' => '_(^o^)^', // oUC
		'se428' => self::$pictograms['d170'] . self::$pictograms['d170'], // lƐlĂ
		'se429' => '[oj[]', // C_X (oj[K[)
		'se42a' => self::$pictograms['d027'], // oXPbg{[
		'se42b' => '[Atg]', // tbg{[
		'se42c' => '[r[h]', // r[h
		'se42d' => self::$pictograms['d252'], // j
		'se42e' => self::$pictograms['d034'], // RV
		'se42f' => '[gbN]', // gbN
		'se430' => '[h]', // h
		'se431' => '[~}]', // ~}
		'se432' => '[pgJ[]', // pgJ[
		'se433' => '[[[R[X^[]',// WFbgR[X^[
		'se434' => self::$pictograms['d031'], // nS
		'se435' => self::$pictograms['d032'], // V(700n)
		'se436' => '[叼]', // 叼
		'se437' => '[`R]', // `R
		'se438' => '[l]', // l
		'se439' => '[Ǝ]', // Ǝ
		'se43a' => '[hZ]', // hZ
		'se43b' => '[̂ڂ]', // ̂ڂ
		'se43c' => self::$pictograms['d008'], // Ƃ
		'se43d' => '[]', // 
		'se43e' => self::$pictograms['d252'], // gU[
		'se43f' => '[X]', // X
		'se440' => '[ԉ]', // ԉ
		'se441' => '[L]', // L
		'se442' => '[]', // 
		'se443' => self::$pictograms['d006'], // 䕗
		'se444' => '[]', // 
		'se445' => '[nEB]', // nEB
		'se446' => self::$pictograms['d099'], // 
		'se447' => self::$pictograms['d260'], // r[
		'se448' => '[T^]', // T^N[X
		'se449' => self::$pictograms['d001'], // 
		'se44a' => self::$pictograms['d001'], // [
		'se44b' => self::$pictograms['d172'], // ꐯ
		'se44c' => '[]', // 
		'se501' => self::$pictograms['d044'] . self::$pictograms['d136'], // uze
		'se502' => self::$pictograms['d062'], // A[g
		'se503' => self::$pictograms['d063'], // 
		'se504' => self::$pictograms['d039'], // fp[g
		'se505' => '[Vt]', //  (a)
		'se506' => '[]', //  (m)
		'se507' => self::$pictograms['d058'], // f
		'se508' => self::$pictograms['d039'], // H
		'se509' => '[^[]', // ^[ 
		'se50a' => self::$pictograms['d039'], // 109 
		'se50b' => '[{]', // { 
		'se50c' => '[AJ]', // AJ 
		'se50d' => '[tX]', // tX 
		'se50e' => '[hCc]', // hCc 
		'se50f' => '[C^A]', // C^A 
		'se510' => '[CMX]', // CMX 
		'se511' => '[XyC]', // XyC 
		'se512' => '[VA]', // VA 
		'se513' => '[]', //  
		'se514' => '[؍]', // ؍ 
		'se515' => '[l]', // l 
		'se516' => '[l]', // l 
		'se517' => '[Chl]', // Chl 
		'se518' => '[]', // 
		'se519' => '[΂]', // ΂
		'se51a' => '[Ԃ]', // 
		'se51b' => '[Hl]', // S
		'se51c' => '[Pl]', // P
		'se51d' => '[Ȑ_]', // Ȑ_
		'se51e' => '[q]', // q
		'se51f' => '[tR]', // tR
		'se520' => self::$pictograms['d270'], // CJ
		'se521' => self::$pictograms['d268'], // Ƃ
		'se522' => self::$pictograms['d270'], // Mы
		'se523' => self::$pictograms['d268'], // Ђ悱
		'se524' => '[nX^[]', // nX^[
		'se525' => '[ђ]', // ނ
		'se526' => '[]', // 
		'se527' => '[RA]', // RA
		'se528' => '[`pW[]', // `pW[
		'se529' => '[r]', // Ђ
		'se52a' => self::$pictograms['d100'], // 
		'se52b' => '[]', // 
		'se52c' => '[e]', // 
		'se52d' => '[]', // ւ
		'se52e' => self::$pictograms['d268'], // ɂƂ
		'se52f' => '[]', // ̂
		'se530' => '[N_]', // 炭
		'se531' => '[^]', // 
		'se532' => '[A^]', // A^
		'se533' => '[B^]', // B^
		'se534' => '[AB^]', // AB^
		'se535' => '[O^]', // O^
		'se536' => self::$pictograms['d091'], // 
		'se537' => self::$pictograms['d239'], // TM (W)
		'se538' => 'J-', 
		'se539' => 'Sky', 
		'se53a' => 'g', 
		'se53b' => 'h', 
		'se53c' => 'V', 
		'se53d' => 'odaf', 
		'se53e' => 'one', 
		'e253'  => '[w]', // lw
		'e254'  => self::$pictograms['d049'], // Jbv
		'e255'  => '[S]', // t}[N
		'e256'  => '[M^[]', // M^[
		'e257'  => '[]', // `[g
		'e258'  => self::$pictograms['d245'], // 18Έȏ֎~
		'e259'  => '[]', // v
		'e260'  => '[R~jeB]', // R~jeB
		'e261'  => '[HIT]', // qbg
		'e262'  => self::$pictograms['d076'], // V
		'e263'  => '[T^]', // T^N[X
		'e264'  => '[Ƒ]', // Ƒ
		'e265'  => '@', // [gp]
		'e266'  => '', // RC
		'e267'  => '@', // [gp]
		'e268'  => '@', // [gp]
		'e269'  => 'EM', // EMOBILE S (n)
		'e270'  => 'EM', // EMOBILE S (Ԓn)
		'e271'  => '@', // [gp]
		'e272'  => '@', // [gp]
		'e273'  => '@', // [gp]
		'e274'  => '@', // [gp]
		'e275'  => '@', // [gp]
		'e276'  => '@', // [gp]
		'e277'  => '@', // [gp]
		'e278'  => '@', // [gp]
		'wf040' => self::$pictograms['d080'], // n[g
		'wf041' => self::$pictograms['d176'], // v
		'wf042' => self::$pictograms['d074'], // db
		'wf043' => self::$pictograms['d051'], // Jbv
		'wf044' => '*', // *
		'wf045' => self::$pictograms['d250'], // ㉺ ()
		'wf046' => self::$pictograms['d249'], // E ()
		'wf047' => '(((', // dg ()
		'wf048' => self::$pictograms['d001'], // 
		'wf049' => self::$pictograms['d003'], // J
		'wf04a' => self::$pictograms['d002'], // ܂
		'wf04b' => self::$pictograms['d163'], // 
		'wf04c' => self::$pictograms['d140'], // Ί
		'wf04d' => self::$pictograms['d149'], //  (LX}[N)
		'wf04e' => self::$pictograms['d146'], // fB (\Z)
		'wf04f' => self::$pictograms['d033'], // 
		'wf050' => self::$pictograms['d030'], // d
		'wf051' => self::$pictograms['d037'], // s@
		'wf052' => '[oCN]'         , // oCN
		'wf053' => self::$pictograms['d038'], // 
		'wf054' => self::$pictograms['d039'], // r
		'wf055' => self::$pictograms['d087'], // s[X ()
		'wf056' => self::$pictograms['d050'], // fBi[ (iCtƃtH[N)H[N)
		'wf057' => self::$pictograms['d052'], // OX
		'wf058' => self::$pictograms['d235'], //  ()
		'wf059' => self::$pictograms['d256'], // `[bv
		'wf05a' => self::$pictograms['d022'], // 싅 (obg)
		'wf05b' => self::$pictograms['d022'], // {[
		'wf05c' => self::$pictograms['d086'], // p` ()
		'wf05d' => self::$pictograms['d005'], // 
		'wf05e' => self::$pictograms['d141'], // {
		'wf05f' => self::$pictograms['d053'], // r[
		'wf060' => self::$pictograms['d076'], // m[g
		'wf061' => self::$pictograms['d214'], // y (M)
		'wf062' => '[hN]', // hN
		'wf063' => self::$pictograms['d110'], // [
		'wf064' => self::$pictograms['d067'], // ։
		'wf065' => self::$pictograms['d097'], // x
		'wf066' => self::$pictograms['d148'], // 
		'wf067' => self::$pictograms['d147'], // 
		'wf068' => self::$pictograms['d098'], //  (26)
		'wf069' => self::$pictograms['d121'], // 
		'wf06a' => '[]', // }XN ()
		'wf06b' => self::$pictograms['d061'], // R[h
		'wf06c' => '[]', // 
		'wf06d' => self::$pictograms['d100'], // 
		'wf06e' => self::$pictograms['d101'], // L
		'wf06f' => '[]', // 
		'wf070' => '[]', // 
		'wf071' => '[]', // 
		'wf072' => self::$pictograms['d265'], // k[h
		'wf073' => self::$pictograms['d057'], // }CN (JIP)
		'wf074' => self::$pictograms['d152'], // ނ ({)
		'wf075' => self::$pictograms['d268'], // Ђ悱
		'wf076' => self::$pictograms['d157'], // 
		'wf077' => self::$pictograms['d051'], // R[q[
		'wf078' => self::$pictograms['d066'], // ^oR
		'wf079' => self::$pictograms['d162'], // 
		'wf07a' => self::$pictograms['d262'], // ɂ
		'wf07b' => self::$pictograms['d069'], // Jo
		'wf07c' => '[E`]', // 
		'wf07d' => '[lN^C]', // lN^C
		'wf07e' => self::$pictograms['d203'], // Vc
		'wf080' => '[Z]', // 
		'wf081' => '[X]', // JLX
		'wf082' => '[]', // rLj
		'wf083' => self::$pictograms['d056'], // ͂
		'wf084' => '[]', // 
		'wf085' => self::$pictograms['d036'], // D (d)
		'wf086' => '[^]', // 
		'wf087' => self::$pictograms['d088'], // oCoC ()
		'wf088' => self::$pictograms['d138'], // 
		'wf089' => self::$pictograms['d082'], // _C (gv)v)
		'wf08a' => self::$pictograms['d083'], // N[o[ (gv)
		'wf08b' => self::$pictograms['d081'], // Xy[h (gv)
		'wf08c' => self::$pictograms['d237'], // Nbv
		'wf08d' => self::$pictograms['d004'], // Ⴞ
		'wf08e' => self::$pictograms['d073'], // P[L
		'wf08f' => self::$pictograms['d258'], // 
		'wf090' => self::$pictograms['d072'], // v[g
		'wf091' => self::$pictograms['d168'], //  (h)
		'wf092' => self::$pictograms['d209'], // o
		'wf093' => self::$pictograms['d209'], // 
		'wf094' => self::$pictograms['d170'], // ₶
		'wf095' => self::$pictograms['d075'], // PHS
		'wf096' => '', // 
		'wf097' => self::$pictograms['d065'], // `Pbg
		'wf098' => self::$pictograms['d139'], // n[g
		'wf099' => self::$pictograms['d151'], // Ђ߂
		'wf09a' => self::$pictograms['d091'], // 
		'wf09b' => self::$pictograms['d140'], // Ί
		'wf09c' => self::$pictograms['d024'], // ejX
		'wf09d' => self::$pictograms['d058'], // f
		'wf09e' => self::$pictograms['d026'], // XL[
		'wf09f' => self::$pictograms['d160'], // !!
		'wf0a0' => self::$pictograms['d159'], // !?
		'wf0a1' => '?', // ?
		'wf0a2' => self::$pictograms['d156'], // ~ ()
		'wf0a3' => self::$pictograms['d145'], // ㏸ ()
		'wf0a4' => self::$pictograms['d228'], // Obh (ew)
		'wf0a5' => '[͂]', // ͂
		'wf0a6' => '' . self::$pictograms['d136'], // L[sbg (n[gƖ)[g
		'wf0a7' => self::$pictograms['d155'], // ܂
		'wf0a8' => self::$pictograms['d006'], // 䕗
		'wf0a9' => self::$pictograms['d102'], // C
		'wf0aa' => self::$pictograms['d252'], // T[tB
		'wf0ab' => self::$pictograms['d253'], // R
		'wf0ac' => self::$pictograms['d253'], // xmR
		'wf0ad' => '[Lv]', // Lv
		'wf0ae' => self::$pictograms['d260'], // t
		'wf0af' => self::$pictograms['d035'], // oX
		'wf0b0' => self::$pictograms['d025'], // TbJ[
		'wf0b1' => '[S]', // S
		'wf0b2' => '', // ߂
		'wf0b3' => '', // 
		'wf0b4' => '[dv]', // dv
		'wf0b5' => self::$pictograms['d245'], // 18
		'wf0b6' => self::$pictograms['d244'], // 
		'wf0b7' => self::$pictograms['d242'], // TCN
		'wf0b8' => '.i|', // dEx
		'wf0b9' => ')))', // dg (E)
		'wf0ba' => '~', // oc
		'wf0bb' => self::$pictograms['d238'], // Rs[Cg
		'wf0bc' => self::$pictograms['d243'], // WX^[hg[h}[N
		'wf0bd' => '[777]', // X[Zu
		'wf0be' => self::$pictograms['d134'], // 0 (zero)
		'wf0bf' => self::$pictograms['d125'], // 1 (one)
		'wf0c0' => self::$pictograms['d126'], // 2 (two)
		'wf0c1' => self::$pictograms['d127'], // 3 (three)
		'wf0c2' => self::$pictograms['d128'], // 4 (four)
		'wf0c3' => self::$pictograms['d129'], // 5 (five)
		'wf0c4' => self::$pictograms['d130'], // 6 (six)
		'wf0c5' => self::$pictograms['d131'], // 7 (seven)
		'wf0c6' => self::$pictograms['d132'], // 8 (eight)
		'wf0c7' => self::$pictograms['d133'], // 9 (nine)
		'wf0c8' => self::$pictograms['d009'], // r
		'wf0c9' => self::$pictograms['d010'], // 
		'wf0ca' => self::$pictograms['d011'], // oq
		'wf0cb' => self::$pictograms['d012'], // I
		'wf0cc' => self::$pictograms['d013'], // q
		'wf0cd' => self::$pictograms['d014'], // 
		'wf0ce' => self::$pictograms['d015'], // V
		'wf0cf' => self::$pictograms['d016'], // 嶍
		'wf0d0' => '[֌]', // ւт
		'wf0d1' => self::$pictograms['d017'], // ˎ
		'wf0d2' => self::$pictograms['d018'], // Rr
		'wf0d3' => self::$pictograms['d019'], // r
		'wf0d4' => self::$pictograms['d020'], // 
		'wf0d5' => self::$pictograms['d170'], // n
		'wf0d6' => self::$pictograms['d054'], // }Nhih
		'wf0d7' => self::$pictograms['d054'], // Xo[K[
		'wf0d8' => '@', // [gp]
		'wf0d9' => self::$pictograms['d054'], // beA
		'wf0da' => '@', // [gp]
		'wf0db' => self::$pictograms['d051'], // hg[R[q[
		'wf0dc' => '@', // [gp]
		'wf0dd' => '@', // [gp]
		'wf0de' => '@', // [gp]
		'wf0df' => '@', // [gp]
		'wf0e0' => self::$pictograms['d050'], //  (o[~?)
		'wf0e1' => '@', // [gp]
		'wf0e2' => '@', // [gp]
		'wf0e3' => self::$pictograms['d050'], // тhL[
		'wf0e4' => '@', // [gp]
		'wf0e5' => '@', // [gp]
		'wf0e6' => '@', // [gp]
		'wf0e7' => self::$pictograms['d045'], // [\
		'wf0e8' => '@', // [gp]
		'wf0e9' => self::$pictograms['d045'], // am/pm
		'wf0ea' => '@', // [gp]
		'wf0eb' => '@', // [gp]
		'wf0ec' => '@', // [gp]
		'wf0ed' => '@', // [gp]
		'wf0ee' => '@', // [gp]
		'wf0ef' => '@', // [gp]
		'wf0f0' => self::$pictograms['d039'], // 
		'wf0f1' => '@', // [gp]
		'wf0f2' => '@', // [gp]
		'wf0f3' => '@', // [gp]
		'wf0f4' => '@', // [gp]
		'wf0f5' => '@', // [gp]
		'wf0f6' => '@', // [gp]
		'wf0f7' => '@', // [gp]
		'wf0f8' => '@', // [gp]
		'wf0f9' => '@', // [gp]
		'wf0fa' => '@', // [gp]
		'wf0fb' => '@', // [gp]
		'wf0fc' => self::$pictograms['d100'], // n`
		'wf140' => self::$pictograms['d170'], // C
		'wf141' => '@', // [gp]
		'wf142' => '@', // [gp]
		'wf143' => '@', // [gp]
		'wf144' => '@', // [gp]
		'wf145' => '@', // [gp]
		'wf146' => '@', // [gp]
		'wf147' => '@', // [gp]
		'wf148' => self::$pictograms['d042'], // UFJ
		'wf149' => '@', // [gp]
		'wf14a' => '@', // [gp]
		'wf14b' => '@', // [gp]
		'wf14c' => '@', // [gp]
		'wf14d' => self::$pictograms['d209'], // 
		'wf14e' => '@', // [gp]
		'wf14f' => '@', // [gp]
		'wf150' => self::$pictograms['d234'], // 
		'wf151' => '@', // [gp]
		'wf152' => '@', // [gp]
		'wf153' => '@', // [gp]
		'wf154' => '@', // [gp]
		'wf155' => '@', // [gp]
		'wf156' => '@', // [gp]
		'wf157' => '@', // [gp]
		'wf158' => '@', // [gp]
		'wf159' => '@', // [gp]
		'wf15a' => '@', // [gp]
		'wf15b' => '@', // [gp]
		'wf15c' => '@', // [gp]
		'wf15d' => '@', // [gp]
		'wf15e' => '@', // [gp]
		'wf15f' => '@', // [gp]
	);
	$translated = apply_filters('ktai_pictogram_table', $translated, __CLASS__, $this->charset);
	$translated = apply_filters('pictogram_table/ktai_style.php', $translated);
	$buffer = preg_replace(
		'!<img localsrc="([^"]+)"( alt="(' . KtaiStyle::DOUBLE_QUOTED_STRING_REGEX . ')")?[^/>]*/?>!se', // <?php /* syntax hilighting fix */
		'isset($translated["$1"]) ? $translated["$1"] : ("$3" ? "$3" : "")', 
		$buffer);
	$entities = array(
		'&spades;' => self::$pictograms['d081'],
		'&#9824;'  => self::$pictograms['d081'],
		'&#x2660;' => self::$pictograms['d081'],
		'&clubs;'  => self::$pictograms['d083'],
		'&#9827;'  => self::$pictograms['d083'],
		'&#x2663;' => self::$pictograms['d083'],
		'&hearts;' => self::$pictograms['d080'],
		'&#9829;'  => self::$pictograms['d080'],
		'&#x2665;' => self::$pictograms['d080'],
		'&#9825;'  => self::$pictograms['d136'], // WHITE HEART
		'&#x2661;' => self::$pictograms['d136'], // WHITE HEART
		'&diams;'  => self::$pictograms['d082'],
		'&#9830;'  => self::$pictograms['d082'],
		'&#x2666;' => self::$pictograms['d082'],
		'&#12336;' => self::$pictograms['d165'], // WAVY DASH
		'&#x3030;' => self::$pictograms['d165'], // WAVY DASH
	);
	$buffer = str_replace(array_keys($entities), $entities, $buffer);
	return parent::convert_pict($buffer);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_pre_split($buffer) {
	$buffer = preg_replace('!<img([^>]*?) src=([\'"])([^>]*?)\.png\\2!s', '<img$1 src=$2$3.gif$2', $buffer); //" syntax hilighting fix
	$buffer = preg_replace('!<a([^>]*?) href=([\'"])([^>]*?)\.png\\2!s', '<a$1 href=$2$3.gif$2', $buffer); //" syntax hilighting fix
	$buffer = preg_replace('!<(b|i|u|em|strong)>(.*?)</\\1>!s', '$2', $buffer);
	return parent::shrink_pre_split($buffer);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function pickup_pics($buffer) {
	$pictograms = array_flip(self::$pictograms);
	if (! $pictograms || ! function_exists('mb_regex_encoding')) {
		return $buffer;
	}
	mb_regex_encoding($this->charset);
	$replaced = mb_ereg_replace(
		"([\xf8\x40-\xf8\x5b]|[\xf8\x5d-\xf8\xfc]|[\xf9\x40-\xf9\x5b]|[\xf9\x5d-\xf9\xfc])", 
		'isset($pictograms["\1"]) ? 
		"<img localsrc=\"" . $pictograms["\1"] . "\" />" : 
		"<img localsrc=\"d\" alt=\"" . "[0x" . bin2hex("\1") . "]\" />"', 
		$buffer, 'e');
	if ($replaced) {
		$replaced = mb_ereg_replace("\xf8\x5c", '<img localsrc="d" alt="[0xf85c]" />', $replaced);
		$replaced = mb_ereg_replace("\xf9\x5c", '<img localsrc="' . $pictograms["\xf9\x5c"] . '" />', $replaced);
	}
	return $replaced ? $replaced : $buffer;
}

// ===== End of class ====================
}

/* ==================================================
 *   KtaiService_imode_mova class
   ================================================== */

class KtaiService_imode_mova extends KtaiService_imode {

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	parent::__construct($user_agent);
	$this->theme      = ks_option('ks_theme_mova');
	$this->type       = 'mova';
	$this->flat_rate  = false;
	if (preg_match('!1\.0/([-_.a-zA-Z0-9]+)(/c(\d+)(/\w+)*?(/ser(\w+))?)?!', $user_agent, $specs)) {
		$this->term_name  = $specs[1];
		$this->term_ID    = isset($specs[6]) ? $specs[6] : NULL;
		$this->cache_size = ($specs[3] > 0) ? intval($specs[3]) * 1024 : 5120;
	} else {
		$this->cache_size = 5120;
	}
	$this->textarea_size = 5000;
	$this->page_size  = 5000;
	$this->preamble   = '';
	$this->xhtml_head = '';
	return;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_post_split($buffer) {
	$buffer = str_replace('&nbsp;', ' ', $buffer);
	$buffer = preg_replace('!\s*</(li|dt|dd|option)>\s*!', '', $buffer);
	$buffer = preg_replace('! ?/>!', '>', $buffer);
/*	$buffer = preg_replace('!<([-~_= a-zA-Z0-9%.,:;\'"/#*+]+?) ?/>!', '<$1>', $buffer); */
	return parent::shrink_post_split($buffer);
}

// ===== End of class ====================
}

/* ==================================================
 *   KtaiService_imode_FOMA class
   ================================================== */

class KtaiService_imode_FOMA extends KtaiService_imode {

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	parent::__construct($user_agent);
	$this->theme      = ks_option('ks_theme_foma');
	$this->type       = 'FOMA';
	$this->flat_rate  = true;
	if (preg_match('!2\.\d ([-_.a-zA-Z0-9]+)\(c(\d+)(;\w+)*?(;ser(\w+);icc(\w+))?\)!', $user_agent, $specs)) {
		$this->term_name  = $specs[1];
		$this->term_ID    = isset($specs[5]) ? $specs[5] : NULL;
		$this->usim_ID    = isset($specs[6]) ? $specs[6] : NULL;
		$this->cache_size = ($specs[2] > 0) ? intval($specs[2]) * 1024 : 102400;
	} else {
		$this->cache_size = 102400;
	}
	$this->textarea_size = 20000;
	$this->page_size  = 20000;
	$this->preamble   = '<?xml version="1.0" encoding="__CHARSET__"?>
<!DOCTYPE html PUBLIC "-//i-mode group (ja)//DTD XHTML i-XHTML(Locale/Ver.=ja/1.0) 1.0//EN" "i-xhtml_4ja_10.dtd">';// <?php /* syntax hilighting fix */
	$this->xhtml_head = '<html xmlns="http://www.w3.org/1999/xhtml">';
	return;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_post_split($buffer) {
//	$buffer = str_replace('&nbsp;', ' ', $buffer);
	$buffer = $this->big_small_to_style($buffer);
	if ($this->mime_type == 'application/xhtml+xml') {
		$buffer = preg_replace('!<blink>(.*?)</blink>!s', '<span style="text-decoration:blink;">$1</span>', $buffer);
		$buffer = $this->input_to_style($buffer);
	}
	return parent::shrink_post_split($buffer);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
protected function big_small_to_style($buffer) {
	$buffer = str_replace(array("\375", "\376"), array('', ''), $buffer);
	$buffer = str_replace(array('<big>', '</big>'), array("\375", "\376"), $buffer, $num_replaced);
	$loop = 0;
	while (preg_match('!\\375([^\\375\\376]*?)\\376!', $buffer, $b)) {
		if ($loop++ > $num_replaced) { // infinity loop check
			break;
		}
		$html = '<span style="font-size:big;">' . $b[1] . '</span>';
		$buffer = preg_replace('!' . preg_quote($b[0], '!') . '!', $html, $buffer, 1);
	}
	$buffer = str_replace(array('<small>', '</small>'), array("\375", "\376"), $buffer, $num_replaced);
	$loop = 0;
	while (preg_match('!\\375([^\\375\\376]*?)\\376!', $buffer, $s)) {
		if ($loop++ > $num_replaced) { // infinity loop check
			break;
		}
		$html = '<span style="font-size:small;">' . $s[1] . '</span>';
		$buffer = preg_replace('!' . preg_quote($s[0], '!') . '!', $html, $buffer, 1);
	}
	return $buffer;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
protected function input_to_style($buffer) {
	if (preg_match_all('|<input ([^>]*?)/?>|', $buffer, $input, PREG_SET_ORDER)) { // <?php /* syntax hilighting fix */
		foreach ($input as $i) {
			$old_style = '';
			$style = '';
			$html = $i[0];
			$attr = $i[1];
			if (preg_match('/ style=([\'"])([^\\\\>]*?(\\\\.[^\\\\>]*?)*)\\1/s', $attr, $s)) { //"syntax highlighting fix
				$old_style = $s[2] . (substr_compare($s[2], ';', -1, 1) !== 0 ? ';' : '');
				$html = str_replace($s[0], '', $html);
			}
			if (preg_match('/ istyle=([\'"])([^\\\\>]*?(\\\\.[^\\\\>]*?)*)\\1/s', $attr, $istyle)) { //"syntax highlighting fix
				switch ($istyle[2]) {
				case 1: // Fullwidth Kana
					$style .= '-wap-input-format:&quot;*&lt;ja:h&gt;&quot;';
					break; 
				case 2: // Halfwidth Kana
					$style .= '-wap-input-format:&quot;*&lt;ja:hk&gt;&quot;';
					break; 
				case 3: // Alphabet
					$style .= '-wap-input-format:&quot;*&lt;ja:en&gt;&quot;';
					break; 
				case 4: // Numeric
					$style .= '-wap-input-format:&quot;*&lt;ja:n&gt;&quot;';
					break; 
				}
				$html = str_replace($istyle[0], '', $html);
			}
			if ($style) {
				$style = ' style="' . $old_style . $style . '"';
				$html = str_replace('<input', '<input' . $style, $html);
				$buffer = preg_replace('!' . preg_quote($i[0], '!') . '!', $html, $buffer, 1);
			}
		}
	}
	return $buffer;
}

// ===== End of class ====================
}

/* ==================================================
 *   KtaiService_imode_Browser2 class
   ================================================== */

class KtaiService_imode_Browser2 extends KtaiService_imode_FOMA {

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	parent::__construct($user_agent);
	$this->ext_css_available = true;
	$this->cookie_available = true;
	$this->available_js_version = '3.0';
	$this->preamble   = '<?xml version="1.0" encoding="__CHARSET__"?>
<!DOCTYPE html PUBLIC "-//i-mode group (ja)//DTD XHTML i-XHTML(Locale/Ver.=ja/2.3) 1.0//EN" "i-xhtml_4ja_10.dtd">';// <?php /* syntax hilighting fix */
	return;
}

// ===== End of class ====================
}
?>