<?php
/* ͕h~̂߂̓{ꕶłB
   ̃\[Xt@C Shift_JIS ŕۑĂ܂B
   Above is a Japanese strings to avoid charset mis-understanding.
   This source file is saved with Shift_JIS.

   ***** DO NOT EDIT THIS FILE WITH WORDPRESS ADMIN PANEL *****
*/

/* ==================================================
 *   KtaiService_WILLCOM class
   ================================================== */

class KtaiService_WILLCOM extends KtaiServices {
	static public $networks;
	static public $pictograms;

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	parent::__construct($user_agent);
	$this->theme = ks_option('ks_theme_willcom');
	$this->operator = 'WILLCOM';
	$this->type = 'AIR-EDGE';
	$this->image_pictograms = false;
	$this->flat_rate = true;
	$this->use_redir = false;
	$this->show_plugin_icon = false;
	$this->pcview_enabled = false;
	preg_match('!\((DDIPOCKET|WILLCOM);([^/]+)/([^/]+)/[^/]+/[\d.]+/[cC](\d+)\)!', $user_agent, $specs);
	$this->term_name = $specs[3];
	$this->sub_ID_available = false;
	$this->cookie_available = true;
	$this->ext_css_available = false;
	$this->available_js_version = false;
	if ($specs[1] == 'DDIPOCKET' && $specs[2] == 'JRC') {
		$this->screen_width  = 128;
		$this->screen_height = 160;
	} else {
		$this->screen_width  = 240;
		$this->screen_height = 320;
	}
	$this->textarea_size = 32768;
	$this->page_size = 32768;
	$this->cache_size = $specs[4] ? intval($specs[4]) * 1024 : 32768;
	$this->charset = 'SJIS-win';
	$this->mime_type = 'text/html';
	// use default preamble
	$this->xhtml_head = '';

	// http://www.willcom-inc.com/ja/service/contents_service/create/center_info/
	// Last Update: 2011-04-28
	$this->networks = array(
		'61.198.128.0/24',
		'61.198.129.0/24',
		'61.198.130.0/24',
		'61.198.131.0/24',
		'61.198.132.0/24',
		'61.198.133.0/24',
		'61.198.134.0/24',
		'61.198.135.0/24',
		'61.198.136.0/24',
		'61.198.137.0/24',
		'61.198.139.0/29',
		'61.198.139.128/27',
		'61.198.139.160/28',
		'61.198.140.0/24',
		'61.198.141.0/24',
		'61.198.142.0/24',
		'61.198.143.0/24',
		'61.198.160.0/24',
		'61.198.161.0/24',
		'61.198.162.0/24',
		'61.198.163.0/24',
		'61.198.164.0/24',
		'61.198.165.0/24',
		'61.198.166.0/24',
		'61.198.168.0/24',
		'61.198.169.0/24',
		'61.198.170.0/24',
		'61.198.171.0/24',
		'61.198.172.0/24',
		'61.198.173.0/24',
		'61.198.174.0/24',
		'61.198.175.0/24',
		'61.198.248.0/24',
		'61.198.249.0/24',
		'61.198.250.0/24',
		'61.198.251.0/24',
		'61.198.252.0/24',
		'61.198.253.0/24',
		'61.198.254.0/24',
		'61.198.255.0/24',
		'61.204.0.0/24',
		'61.204.2.0/24',
		'61.204.3.0/25',
		'61.204.3.128/25',
		'61.204.4.0/24',
		'61.204.5.0/24',
		'61.204.6.0/25',
		'61.204.6.128/25',
		'61.204.7.0/25',
		'61.204.92.0/24',
		'61.204.93.0/24',
		'61.204.94.0/24',
		'61.204.95.0/24',
		'114.20.49.0/24',
		'114.20.50.0/24',
		'114.20.51.0/24',
		'114.20.52.0/24',
		'114.20.53.0/24',
		'114.20.54.0/24',
		'114.20.55.0/24',
		'114.20.56.0/24',
		'114.20.57.0/24',
		'114.20.58.0/24',
		'114.20.59.0/24',
		'114.20.60.0/24',
		'114.20.61.0/24',
		'114.20.62.0/24',
		'114.20.63.0/24',
		'114.20.64.0/24',
		'114.20.65.0/24',
		'114.20.66.0/24',
		'114.20.67.0/24',
		'114.21.128.0/24', // added on 2010-10-06
		'114.21.129.0/24', // added on 2010-10-06
		'114.21.130.0/24', // added on 2010-10-06
		'114.21.131.0/24', // added on 2010-10-06
		'114.21.132.0/24', // added on 2010-10-06
		'114.21.133.0/24', // added on 2010-10-06
		'114.21.134.0/24', // added on 2010-10-06
		'114.21.135.0/24', // added on 2010-10-06
		'114.21.136.0/24', // added on 2010-10-06
		'114.21.137.0/24', // added on 2010-10-06
		'114.21.138.0/24', // added on 2010-10-06
		'114.21.139.0/24', // added on 2010-10-06
		'114.21.140.0/24', // added on 2010-10-06
		'114.21.141.0/24', // added on 2010-10-06
		'114.21.142.0/24', // added on 2010-10-06
		'114.21.143.0/24', // added on 2010-10-06
		'114.21.144.0/24', // added on 2010-10-06
		'114.21.145.0/24', // added on 2010-10-06
		'114.21.146.0/24', // added on 2010-10-06
		'114.21.147.0/24', // added on 2010-10-06
		'114.21.148.0/24', // added on 2010-10-06
		'114.21.149.0/24', // added on 2010-10-06
		'125.28.0.0/24',
		'125.28.1.0/24',
		'125.28.15.0/24',
		'125.28.16.0/24',
		'125.28.17.0/24',
		'125.28.2.0/24',
		'125.28.3.0/24',
		'125.28.4.0/24',
		'125.28.5.0/24',
		'125.28.8.0/24', 
		'210.168.246.0/24',
		'210.168.247.0/24',
		'210.169.92.0/24',
		'210.169.93.0/24',
		'210.169.94.0/24',
		'210.169.95.0/24',
		'210.169.96.0/24',
		'210.169.97.0/24',
		'210.169.98.0/24',
		'210.169.99.0/24',
		'210.255.190.0/24', // added on 2010-10-06
		'211.126.192.128/25',
		'211.18.232.0/24',
		'211.18.233.0/24',
		'211.18.234.0/24',
		'211.18.235.0/24',
		'211.18.236.0/24',
		'211.18.237.0/24',
		'219.108.7.0/24',
		'219.108.8.0/24',
		'219.108.9.0/24',
		'219.108.10.0/24',
		'219.108.11.0/24',
		'219.108.12.0/24',
		'219.108.13.0/24',
		'219.108.14.0/24',
		'219.108.15.0/24',
		'221.119.0.0/24',
		'221.119.1.0/24',
		'221.119.2.0/24',
		'221.119.3.0/24',
		'221.119.4.0/24',
		'221.119.6.0/24',
		'221.119.7.0/24',
		'221.119.8.0/24',
		'221.119.9.0/24',
/*		deleted on 2009-10-15
		'125.28.11.0/24', 
		'125.28.12.0/24',
		'125.28.13.0/24',
		'125.28.14.0/24',
		'125.28.6.0/24',
		'125.28.7.0/24',
		'211.18.238.0/24',
		'211.18.239.0/24',
		'219.108.2.0/24',
		'219.108.3.0/24',
		'221.119.5.0/24',
*/
/*		deleted on 2010-10-06
		'114.21.255.0/27',
*/
/*		deleted on 2011-04-28
		'61.198.138.100/32',
		'61.198.138.101/32',
		'61.198.138.102/32',
		'61.198.138.103/32',
		'114.21.254.0/27',
*/
	);
	// http://www.willcom-inc.com/ja/service/contents_service/create/emoji/
	self::$pictograms = array(
		'wf040' => "\xf0\x40", // n[g
		'wf041' => "\xf0\x41", // v
		'wf042' => "\xf0\x42", // db
		'wf043' => "\xf0\x43", // Jbv
		'wf044' => "\xf0\x44", // *
		'wf045' => "\xf0\x45", // ㉺ ()
		'wf046' => "\xf0\x46", // E ()
		'wf047' => "\xf0\x47", // dg ()
		'wf048' => "\xf0\x48", // 
		'wf049' => "\xf0\x49", // J
		'wf04a' => "\xf0\x4a", // ܂
		'wf04b' => "\xf0\x4b", // 
		'wf04c' => "\xf0\x4c", // Ί
		'wf04d' => "\xf0\x4d", //  (LX}[N)
		'wf04e' => "\xf0\x4e", // fB (\Z)
		'wf04f' => "\xf0\x4f", // 
		'wf050' => "\xf0\x50", // d
		'wf051' => "\xf0\x51", // s@
		'wf052' => "\xf0\x52", // oCN
		'wf053' => "\xf0\x53", // 
		'wf054' => "\xf0\x54", // r
		'wf055' => "\xf0\x55", // s[X ()
		'wf056' => "\xf0\x56", // fBi[ (iCtƃtH[N)
		'wf057' => "\xf0\x57", // OX
		'wf058' => "\xf0\x58", //  ()
		'wf059' => "\xf0\x59", // `[bv
		'wf05a' => "\xf0\x5a", // 싅 (obg)
		'wf05b' => "\xf0\x5b", // {[
		'wf05c' => "\xf0\x5c", // p` ()
		'wf05d' => "\xf0\x5d", // 
		'wf05e' => "\xf0\x5e", // {
		'wf05f' => "\xf0\x5f", // r[
		'wf060' => "\xf0\x60", // m[g
		'wf061' => "\xf0\x61", // y (M)
		'wf062' => "\xf0\x62", // hN
		'wf063' => "\xf0\x63", // [
		'wf064' => "\xf0\x64", // ։
		'wf065' => "\xf0\x65", // x
		'wf066' => "\xf0\x66", // 
		'wf067' => "\xf0\x67", // 
		'wf068' => "\xf0\x68", //  (26)
		'wf069' => "\xf0\x69", // 
		'wf06a' => "\xf0\x6a", // }XN ()
		'wf06b' => "\xf0\x6b", // R[h
		'wf06c' => "\xf0\x6c", // 
		'wf06d' => "\xf0\x6d", // 
		'wf06e' => "\xf0\x6e", // L
		'wf06f' => "\xf0\x6f", // 
		'wf070' => "\xf0\x70", // 
		'wf071' => "\xf0\x71", // 
		'wf072' => "\xf0\x72", // k[h
		'wf073' => "\xf0\x73", // }CN (JIP)
		'wf074' => "\xf0\x74", // ނ ({)
		'wf075' => "\xf0\x75", // Ђ悱
		'wf076' => "\xf0\x76", // 
		'wf077' => "\xf0\x77", // R[q[
		'wf078' => "\xf0\x78", // ^oR
		'wf079' => "\xf0\x79", // 
		'wf07a' => "\xf0\x7a", // ɂ
		'wf07b' => "\xf0\x7b", // Jo
		'wf07c' => "\xf0\x7c", // 
		'wf07d' => "\xf0\x7d", // lN^C
		'wf07e' => "\xf0\x7e", // Vc
		'wf080' => "\xf0\x80", // 
		'wf081' => "\xf0\x81", // JLX
		'wf082' => "\xf0\x82", // rLj
		'wf083' => "\xf0\x83", // ͂
		'wf084' => "\xf0\x84", // 
		'wf085' => "\xf0\x85", // D (d)
		'wf086' => "\xf0\x86", // 
		'wf087' => "\xf0\x87", // oCoC ()
		'wf088' => "\xf0\x88", // 
		'wf089' => "\xf0\x89", // _C (gv)
		'wf08a' => "\xf0\x8a", // N[o[ (gv)
		'wf08b' => "\xf0\x8b", // Xy[h (gv)
		'wf08c' => "\xf0\x8c", // Nbv
		'wf08d' => "\xf0\x8d", // Ⴞ
		'wf08e' => "\xf0\x8e", // P[L
		'wf08f' => "\xf0\x8f", // 
		'wf090' => "\xf0\x90", // v[g
		'wf091' => "\xf0\x91", //  (h)
		'wf092' => "\xf0\x92", // o
		'wf093' => "\xf0\x93", // 
		'wf094' => "\xf0\x94", // ₶
		'wf095' => "\xf0\x95", // PHS
		'wf096' => "\xf0\x96", // 
		'wf097' => "\xf0\x97", // `Pbg
		'wf098' => "\xf0\x98", // n[g
		'wf099' => "\xf0\x99", // Ђ߂
		'wf09a' => "\xf0\x9a", // 
		'wf09b' => "\xf0\x9b", // Ί
		'wf09c' => "\xf0\x9c", // ejX
		'wf09d' => "\xf0\x9d", // f
		'wf09e' => "\xf0\x9e", // XL[
		'wf09f' => "\xf0\x9f", // !!
		'wf0a0' => "\xf0\xa0", // !?
		'wf0a1' => "\xf0\xa1", // ?
		'wf0a2' => "\xf0\xa2", // ~ ()
		'wf0a3' => "\xf0\xa3", // ㏸ ()
		'wf0a4' => "\xf0\xa4", // Obh (ew)
		'wf0a5' => "\xf0\xa5", // ͂
		'wf0a6' => "\xf0\xa6", // L[sbg (n[gƖ)
		'wf0a7' => "\xf0\xa7", // ܂
		'wf0a8' => "\xf0\xa8", // 䕗
		'wf0a9' => "\xf0\xa9", // C
		'wf0aa' => "\xf0\xaa", // T[tB
		'wf0ab' => "\xf0\xab", // R
		'wf0ac' => "\xf0\xac", // xmR
		'wf0ad' => "\xf0\xad", // Lv
		'wf0ae' => "\xf0\xae", // t
		'wf0af' => "\xf0\xaf", // oX
		'wf0b0' => "\xf0\xb0", // TbJ[
		'wf0b1' => "\xf0\xb1", // S
		'wf0b2' => "\xf0\xb2", // ߂
		'wf0b3' => "\xf0\xb3", // 
		'wf0b4' => "\xf0\xb4", // dv
		'wf0b5' => "\xf0\xb5", // 18
		'wf0b6' => "\xf0\xb6", // 
		'wf0b7' => "\xf0\xb7", // TCN
		'wf0b8' => "\xf0\xb8", // dEx
		'wf0b9' => "\xf0\xb9", // dg (E)
		'wf0ba' => "\xf0\xba", // oc
		'wf0bb' => "\xf0\xbb", // Rs[Cg
		'wf0bc' => "\xf0\xbc", // WX^[hg[h}[N
		'wf0bd' => "\xf0\xbd", // X[Zu
		'wf0be' => "\xf0\xbe", // 0 (zero)
		'wf0bf' => "\xf0\xbf", // 1 (one)
		'wf0c0' => "\xf0\xc0", // 2 (two)
		'wf0c1' => "\xf0\xc1", // 3 (three)
		'wf0c2' => "\xf0\xc2", // 4 (four)
		'wf0c3' => "\xf0\xc3", // 5 (five)
		'wf0c4' => "\xf0\xc4", // 6 (six)
		'wf0c5' => "\xf0\xc5", // 7 (seven)
		'wf0c6' => "\xf0\xc6", // 8 (eight)
		'wf0c7' => "\xf0\xc7", // 9 (nine)
		'wf0c8' => "\xf0\xc8", // r
		'wf0c9' => "\xf0\xc9", // 
		'wf0ca' => "\xf0\xca", // oq
		'wf0cb' => "\xf0\xcb", // I
		'wf0cc' => "\xf0\xcc", // q
		'wf0cd' => "\xf0\xcd", // 
		'wf0ce' => "\xf0\xce", // V
		'wf0cf' => "\xf0\xcf", // 嶍
		'wf0d0' => "\xf0\xd0", // ւт
		'wf0d1' => "\xf0\xd1", // ˎ
		'wf0d2' => "\xf0\xd2", // Rr
		'wf0d3' => "\xf0\xd3", // r
		'wf0d4' => "\xf0\xd4", // 
		'wf0d5' => "\xf0\xd5", // n
		'wf0d6' => "\xf0\xd6", // }Nhih
		'wf0d7' => "\xf0\xd7", // Xo[K[
		'wf0d8' => "\xf0\xd8", // [gp]
		'wf0d9' => "\xf0\xd9", // beA
		'wf0da' => "\xf0\xda", // [gp]
		'wf0db' => "\xf0\xdb", // hg[R[q[
		'wf0dc' => "\xf0\xdc", // [gp]
		'wf0dd' => "\xf0\xdd", // [gp]
		'wf0de' => "\xf0\xde", // [gp]
		'wf0df' => "\xf0\xdf", // [gp]
		'wf0e0' => "\xf0\xe0", //  (o[~?)
		'wf0e1' => "\xf0\xe1", // [gp]
		'wf0e2' => "\xf0\xe2", // [gp]
		'wf0e3' => "\xf0\xe3", // тhL[
		'wf0e4' => "\xf0\xe4", // [gp]
		'wf0e5' => "\xf0\xe5", // [gp]
		'wf0e6' => "\xf0\xe6", // [gp]
		'wf0e7' => "\xf0\xe7", // [\
		'wf0e8' => "\xf0\xe8", // [gp]
		'wf0e9' => "\xf0\xe9", // am/pm
		'wf0ea' => "\xf0\xea", // [gp]
		'wf0eb' => "\xf0\xeb", // [gp]
		'wf0ec' => "\xf0\xec", // [gp]
		'wf0ed' => "\xf0\xed", // [gp]
		'wf0ee' => "\xf0\xee", // [gp]
		'wf0ef' => "\xf0\xef", // [gp]
		'wf0f0' => "\xf0\xf0", // 
		'wf0f1' => "\xf0\xf1", // [gp]
		'wf0f2' => "\xf0\xf2", // [gp]
		'wf0f3' => "\xf0\xf3", // [gp]
		'wf0f4' => "\xf0\xf4", // [gp]
		'wf0f5' => "\xf0\xf5", // [gp]
		'wf0f6' => "\xf0\xf6", // [gp]
		'wf0f7' => "\xf0\xf7", // [gp]
		'wf0f8' => "\xf0\xf8", // [gp]
		'wf0f9' => "\xf0\xf9", // [gp]
		'wf0fa' => "\xf0\xfa", // [gp]
		'wf0fb' => "\xf0\xfb", // [gp]
		'wf0fc' => "\xf0\xfc", // n`
		'wf140' => "\xf1\x40", // C
		'wf141' => "\xf1\x41", // [gp]
		'wf142' => "\xf1\x42", // [gp]
		'wf143' => "\xf1\x43", // [gp]
		'wf144' => "\xf1\x44", // [gp]
		'wf145' => "\xf1\x45", // [gp]
		'wf146' => "\xf1\x46", // [gp]
		'wf147' => "\xf1\x47", // [gp]
		'wf148' => "\xf1\x48", // UFJ
		'wf149' => "\xf1\x49", // [gp]
		'wf14a' => "\xf1\x4a", // [gp]
		'wf14b' => "\xf1\x4b", // [gp]
		'wf14c' => "\xf1\x4c", // [gp]
		'wf14d' => "\xf1\x4d", // 
		'wf14e' => "\xf1\x4e", // [gp]
		'wf14f' => "\xf1\x4f", // [gp]
		'wf150' => "\xf1\x50", // 
		'wf151' => "\xf1\x51", // [gp]
		'wf152' => "\xf1\x52", // [gp]
		'wf153' => "\xf1\x53", // [gp]
		'wf154' => "\xf1\x54", // [gp]
		'wf155' => "\xf1\x55", // [gp]
		'wf156' => "\xf1\x56", // [gp]
		'wf157' => "\xf1\x57", // [gp]
		'wf158' => "\xf1\x58", // [gp]
		'wf159' => "\xf1\x59", // [gp]
		'wf15a' => "\xf1\x5a", // [gp]
		'wf15b' => "\xf1\x5b", // [gp]
		'wf15c' => "\xf1\x5c", // [gp]
		'wf15d' => "\xf1\x5d", // [gp]
		'wf15e' => "\xf1\x5e", // [gp]
		'wf15f' => "\xf1\x5f", // [gp]
		'd001'  => "\xf8\x9f", // 
		'd002'  => "\xf8\xa0", // ܂
		'd003'  => "\xf8\xa1", // J
		'd004'  => "\xf8\xa2", //  
		'd005'  => "\xf8\xa3", // 
		'd006'  => "\xf8\xa4", // 䕗
		'd007'  => "\xf8\xa5", // 
		'd008'  => "\xf8\xa6", // J
		'd009'  => "\xf8\xa7", // r
		'd010'  => "\xf8\xa8", // 
		'd011'  => "\xf8\xa9", // oq
		'd012'  => "\xf8\xaa", // I
		'd013'  => "\xf8\xab", // q
		'd014'  => "\xf8\xac", // 
		'd015'  => "\xf8\xad", // V
		'd016'  => "\xf8\xae", // 嶍
		'd017'  => "\xf8\xaf", // ˎ
		'd018'  => "\xf8\xb0", // Rr
		'd019'  => "\xf8\xb1", // r
		'd020'  => "\xf8\xb2", // 
		'd021'  => "\xf8\xb3", // X|[c
		'd022'  => "\xf8\xb4", // 싅
		'd023'  => "\xf8\xb5", // St
		'd024'  => "\xf8\xb6", // ejX
		'd025'  => "\xf8\xb7", // TbJ[
		'd026'  => "\xf8\xb8", // XL[
		'd027'  => "\xf8\xb9", // oXPbg{[
		'd028'  => "\xf8\xba", // [^[X|[c (`FbJ[tbO)
		'd029'  => "\xf8\xbb", // |Pbgx
		'd030'  => "\xf8\xbc", // d
		'd031'  => "\xf8\xbd", // nS
		'd032'  => "\xf8\xbe", // V
		'd033'  => "\xf8\xbf", //  (Z_)
		'd034'  => "\xf8\xc0", //  (RV)
		'd035'  => "\xf8\xc1", // oX
		'd036'  => "\xf8\xc2", // D
		'd037'  => "\xf8\xc3", // s@
		'd038'  => "\xf8\xc4", // 
		'd039'  => "\xf8\xc5", // r
		'd040'  => "\xf8\xc6", // X֋
		'd041'  => "\xf8\xc7", // a@
		'd042'  => "\xf8\xc8", // s
		'd043'  => "\xf8\xc9", // ATM
		'd044'  => "\xf8\xca", // ze
		'd045'  => "\xf8\xcb", // Rrj
		'd046'  => "\xf8\xcc", // K\X^h
		'd047'  => "\xf8\xcd", // ԏ
		'd048'  => "\xf8\xce", // M
		'd049'  => "\xf8\xcf", // gC
		'd050'  => "\xf8\xd0", // Xg
		'd051'  => "\xf8\xd1", // iX
		'd052'  => "\xf8\xd2", // o[ (}eB[j)
		'd053'  => "\xf8\xd3", // r[
		'd054'  => "\xf8\xd4", // t@[Xgt[h (no[K[)
		'd055'  => "\xf8\xd5", // ueBbN
		'd056'  => "\xf8\xd6", // e@ ()
		'd057'  => "\xf8\xd7", // JIP
		'd058'  => "\xf8\xd8", // f
		'd059'  => "\xf8\xd9", // E΂ߏ
		'd060'  => "\xf8\xda", // Vn (ؔn)
		'd061'  => "\xf8\xdb", // y (wbhz)
		'd062'  => "\xf8\xdc", // A[g
		'd063'  => "\xf8\xdd", // 
		'd064'  => "\xf8\xde", // Cxg (T[JX)
		'd065'  => "\xf8\xdf", // `Pbg
		'd066'  => "\xf8\xe0", // i
		'd067'  => "\xf8\xe1", // ։
		'd068'  => "\xf8\xe2", // J
		'd069'  => "\xf8\xe3", // Jo
		'd070'  => "\xf8\xe4", // {
		'd071'  => "\xf8\xe5", // {
		'd072'  => "\xf8\xe6", // v[g
		'd073'  => "\xf8\xe7", // o[Xf[
		'd074'  => "\xf8\xe8", // db
		'd075'  => "\xf8\xe9", // gѓdb
		'd076'  => "\xf8\xea", // 
		'd077'  => "\xf8\xeb", // TV
		'd078'  => "\xf8\xec", // Q[
		'd079'  => "\xf8\xed", // CD
		'd080'  => "\xf8\xee", // n[g
		'd081'  => "\xf8\xef", // Xy[h
		'd082'  => "\xf8\xf0", // _C
		'd083'  => "\xf8\xf1", // Nu
		'd084'  => "\xf8\xf2", // 
		'd085'  => "\xf8\xf3", // 
		'd086'  => "\xf8\xf4", //  (O[)
		'd087'  => "\xf8\xf5", //  (`L)
		'd088'  => "\xf8\xf6", //  (p[)
		'd089'  => "\xf8\xf7", // E΂߉
		'd090'  => "\xf8\xf8", // ΂ߏ
		'd091'  => "\xf8\xf9", // 
		'd092'  => "\xf8\xfa", // 
		'd093'  => "\xf8\xfb", // ዾ
		'd094'  => "\xf8\xfc", // Ԉ֎q
		'd095'  => "\xf9\x40", // V
		'd096'  => "\xf9\x41", // ⌇
		'd097'  => "\xf9\x42", // 
		'd098'  => "\xf9\x43", // O
		'd099'  => "\xf9\x44", // 
		'd100'  => "\xf9\x45", // 
		'd101'  => "\xf9\x46", // L
		'd102'  => "\xf9\x47", // ][g (bg)
		'd103'  => "\xf9\x48", // NX}X
		'd104'  => "\xf9\x49", // ΂߉
		'd105'  => "\xf9\x72", // phone to
		'd106'  => "\xf9\x73", // mail to
		'd107'  => "\xf9\x74", // fax to
		'd108'  => "\xf9\x75", // i[h
		'd109'  => "\xf9\x76", // i[h (gt)
		'd110'  => "\xf9\x77", // [
		'd111'  => "\xf9\x78", // hR
		'd112'  => "\xf9\x79", // hR|Cg
		'd113'  => "\xf9\x7a", // L
		'd114'  => "\xf9\x7b", // 
		'd115'  => "\xf9\x7c", // ID
		'd116'  => "\xf9\x7d", // pX[h
		'd117'  => "\xf9\x7e", // L
		'd118'  => "\xf9\x80", // NA
		'd119'  => "\xf9\x81", // T[` (ׂ)
		'd120'  => "\xf9\x82", // NEW
		'd121'  => "\xf9\x83", // ʒu
		'd122'  => "\xf9\x84", // t[_C
		'd123'  => "\xf9\x85", // V[v_C
		'd124'  => "\xf9\x86", // oQ
		'd125'  => "\xf9\x87", // 1 (one)
		'd126'  => "\xf9\x88", // 2 (two)
		'd127'  => "\xf9\x89", // 3 (three)
		'd128'  => "\xf9\x8a", // 4 (four)
		'd129'  => "\xf9\x8b", // 5 (five)
		'd130'  => "\xf9\x8c", // 6 (six)
		'd131'  => "\xf9\x8d", // 7 (seven)
		'd132'  => "\xf9\x8e", // 8 (eight)
		'd133'  => "\xf9\x8f", // 9 (nine)
		'd134'  => "\xf9\x90", // 0 (zero)
		'd135'  => "\xf9\xb0", //  (OK)
		'd136'  => "\xf9\x91", // n[g
		'd137'  => "\xf9\x92", // hn[g
		'd138'  => "\xf9\x93", // 
		'd139'  => "\xf9\x94", // n[g (n[g)
		'd140'  => "\xf9\x95", // [ ()
		'd141'  => "\xf9\x96", //  ({)
		'd142'  => "\xf9\x97", // ` (_)
		'd143'  => "\xf9\x98", // ₾` (߂)
		'd144'  => "\xf9\x99", // ӂӂ
		'd145'  => "\xf9\x9a", // Obh ()
		'd146'  => "\xf9\x9b", //  ()
		'd147'  => "\xf9\x9c", // C ()
		'd148'  => "\xf9\x9d", // 킢
		'd149'  => "\xf9\x9e", // LX}[N
		'd150'  => "\xf9\x9f", // ҂҂ (V)
		'd151'  => "\xf9\xa0", // Ђ߂
		'd152'  => "\xf9\xa1", // ނ ({)
		'd153'  => "\xf9\xa2", // p`
		'd154'  => "\xf9\xa3", // e
		'd155'  => "\xf9\xa4", // [h
		'd156'  => "\xf9\xa5", // obh ()
		'd157'  => "\xf9\xa6", //  ()
		'd158'  => "\xf9\xa7", // exclamation
		'd159'  => "\xf9\xa8", // exclamation and question
		'd160'  => "\xf9\xa9", // double exclamation
		'd161'  => "\xf9\xaa", // ǂ (Ռ)
		'd162'  => "\xf9\xab", //  (юU銾)
		'd163'  => "\xf9\xac", // [ ()
		'd164'  => "\xf9\xad", // _bV (o)
		'd165'  => "\xf9\xae", // [ (L1)
		'd166'  => "\xf9\xaf", // [ (L2)
		'd167'  => "\xf9\x50", // J`R
		'd168'  => "\xf9\x51", // ӂ
		'd169'  => "\xf9\x52", // y
		'd170'  => "\xf9\x55", // le
		'd171'  => "\xf9\x56", // 
		'd172'  => "\xf9\x57", // 
		'd173'  => "\xf9\x5b", // soon
		'd174'  => "\xf9\x5c", // on
		'd175'  => "\xf9\x5d", // end
		'd176'  => "\xf9\x5e", // v
		'd201'  => "\xf9\xb1", // iAv
		'd202'  => "\xf9\xb2", // iAv (gt)
		'd203'  => "\xf9\xb3", // TVc ({[_[)
		'd204'  => "\xf9\xb4", // ܌z
		'd205'  => "\xf9\xb5", // 
		'd206'  => "\xf9\xb6", // W[Y
		'd207'  => "\xf9\xb7", // Xm{
		'd208'  => "\xf9\xb8", // `y
		'd209'  => "\xf9\xb9", // hA
		'd210'  => "\xf9\xba", // h
		'd211'  => "\xf9\xbb", // p\R
		'd212'  => "\xf9\xbc", // u^[
		'd213'  => "\xf9\xbd", // `
		'd214'  => "\xf9\xbe", // M
		'd215'  => "\xf9\xbf", // 
		'd216'  => "\xf9\xc0", // w
		'd217'  => "\xf9\xc1", // v
		'd218'  => "\xf9\xc2", // ]
		'd219'  => "\xf9\xc3", // ̂
		'd220'  => "\xf9\xc4", // rv
		'd221'  => "\xf9\xc5", // lĂ
		'd222'  => "\xf9\xc6", // قƂ
		'd223'  => "\xf9\xc7", // ⊾ ()
		'd224'  => "\xf9\xc8", // ⊾2 ()
		'd225'  => "\xf9\xc9", // ՂȊ
		'd226'  => "\xf9\xca", // {P[Ƃ
		'd227'  => "\xf9\xcb", // ڂn[g ()
		'd228'  => "\xf9\xcc", // wOK
		'd229'  => "\xf9\xcd", // ׁ[
		'd230'  => "\xf9\xce", // EBN
		'd231'  => "\xf9\xcf", // ꂵ
		'd232'  => "\xf9\xd0", // ܂
		'd233'  => "\xf9\xd1", // L2
		'd234'  => "\xf9\xd2", // 
		'd235'  => "\xf9\xd3", // 
		'd236'  => "\xf9\xd4", // NG
		'd237'  => "\xf9\xd5", // Nbv
		'd238'  => "\xf9\xd6", // Rs[Cg (C)
		'd239'  => "\xf9\xd7", // g[h}[N (TM)
		'd240'  => "\xf9\xd8", // l
		'd241'  => "\xf9\xd9", // }
		'd242'  => "\xf9\xda", // TCN
		'd243'  => "\xf9\xdb", // WX^[hg[h}[N (R)
		'd244'  => "\xf9\xdc", // 댯Ex (!)
		'd245'  => "\xf9\xdd", // ֎~
		'd246'  => "\xf9\xde", // 󎺁EȁE
		'd247'  => "\xf9\xdf", // i}[N
		'd248'  => "\xf9\xe0", // EȁE
		'd249'  => "\xf9\xe1", // 󍶉E
		'd250'  => "\xf9\xe2", // ㉺
		'd251'  => "\xf9\xe3", // wZ
		'd252'  => "\xf9\xe4", // g
		'd253'  => "\xf9\xe5", // xmR
		'd254'  => "\xf9\xe6", // N[o[
		'd255'  => "\xf9\xe7", // 
		'd256'  => "\xf9\xe8", // `[bv
		'd257'  => "\xf9\xe9", // oii
		'd258'  => "\xf9\xea", // 
		'd259'  => "\xf9\xeb", // 
		'd260'  => "\xf9\xec", // ݂
		'd261'  => "\xf9\xed", // 
		'd262'  => "\xf9\xee", // ɂ
		'd263'  => "\xf9\xef", // V[gP[L
		'd264'  => "\xf9\xf0", // Ƃ (傱t)
		'd265'  => "\xf9\xf1", // ǂԂ
		'd266'  => "\xf9\xf2", // p
		'd267'  => "\xf9\xf3", // ނ
		'd268'  => "\xf9\xf4", // Ђ悱
		'd269'  => "\xf9\xf5", // yM
		'd270'  => "\xf9\xf6", // 
		'd271'  => "\xf9\xf7", // ܂! ()
		'd272'  => "\xf9\xf8", // EbVbV ()
		'd273'  => "\xf9\xf9", // E}
		'd274'  => "\xf9\xfa", // u^
		'd275'  => "\xf9\xfb", // COX
		'd276'  => "\xf9\xfc", //  ()
	);
	return;
}

/* ==================================================
 * @param	boolean $allow_search_engine
 * @return	boolean $in_network
 */
public function in_network($allow_search_engine = false) {
	return parent::in_network(self::$networks, $allow_search_engine);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function replace_smiley($buffer) {
	$smiles = array(
		'icon_smile.gif'     => self::$pictograms['d140'],
		'icon_biggrin.gif'   => self::$pictograms['d231'],
		'icon_sad.gif'       => self::$pictograms['d143'],
		'icon_surprised.gif' => self::$pictograms['d276'],
		'icon_eek.gif'       => self::$pictograms['d276'],
		'icon_confused.gif'  => self::$pictograms['d221'],
		'icon_cool.gif'      => self::$pictograms['d271'],
		'icon_mad.gif'       => self::$pictograms['d141'],
		'icon_razz.gif'      => self::$pictograms['d229'],
		'icon_neutral.gif'   => self::$pictograms['d226'],
		'icon_wink.gif'      => self::$pictograms['d230'],
		'icon_lol.gif'       => self::$pictograms['d229'],
		'icon_redface.gif'   => self::$pictograms['d227'],
		'icon_cry.gif'       => self::$pictograms['d234'],
		'icon_evil.gif'      => self::$pictograms['d225'],
		'icon_twisted.gif'   => self::$pictograms['d225'],
		'icon_rolleyes.gif'  => self::$pictograms['d221'],
		'icon_exclaim.gif'   => self::$pictograms['wf0b6'],
		'icon_question.gif'  => self::$pictograms['wf0a1'],
		'icon_idea.gif'      => self::$pictograms['wf099'],
		'icon_arrow.gif'     => self::$pictograms['d173'],
		'icon_mrgreen.gif'   => self::$pictograms['wf086'],
	);
	$smiles = apply_filters('ktai_smiley_table', $smiles, __CLASS__);
	$smiles = apply_filters('smiley_table/ktai_style.php', $smiles);
	return parent::replace_smiley($buffer, $smiles);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function convert_pict($buffer) {
	// http://www.au.kddi.com/email/emoji/
	// http://mb.softbank.jp/mb/service/3G/mail/pictogram/
	// http://www.nttdocomo.co.jp/service/mail/imode_mail/emoji_convert/
	// http://www.willcom-inc.com/ja/service/e_mail/pdf/conversiontable.pdf
	$translated = self::$pictograms + array(
		'1'     => self::$pictograms['wf0b6'], // u!v
		'2'     => self::$pictograms['wf09f'], // u!v
		'3'     => self::$pictograms['wf0a1'], // u?v
		'4'     => self::$pictograms['d124'], // uQv
		'5'     => '', // Op1
		'6'     => '', // EOp1
		'7'     => self::$pictograms['wf0b2'], // Op2
		'8'     => self::$pictograms['wf0b3'], // EOp2
		'9'     => '', // lp 1
		'10'    => '', // lp 2
		'11'    => '[i]', // CtH[VV{
		'12'    => self::$pictograms['d275'], // COX
		'13'    => '[Xs[J[]', // Xs[J[
		'14'    => self::$pictograms['wf091'], // h}[N
		'15'    => self::$pictograms['wf068'], //  1
		'16'    => self::$pictograms['wf05d'], // Ȃ
		'17'    => '', // lp 1
		'18'    => '', // lp 2
		'19'    => '', // H` 1
		'20'    => '', // H` 2
		'21'    => '', // lp 1
		'22'    => '', // lp 2
		'23'    => '', // H` 1
		'24'    => '', // H` 2
		'25'    => self::$pictograms['d220'], // rv
		'26'    => '+', // vX
		'27'    => '-', // }CiX
		'28'    => '', //  1
		'29'    => '', //  1
		'30'    => '', //  1
		'31'    => self::$pictograms['d245'], // ۂɎ΂ߐ
		'32'    => '', // Op 1
		'33'    => '', // Op 1
		'34'    => '', // Op 2
		'35'    => '', // Op 2
		'36'    => '', // H` 1
		'37'    => '', // H` 2
		'38'    => '', // lp 1
		'39'    => '', // lp 2
		'40'    => '', //  1
		'41'    => '', //  2
		'42'    => self::$pictograms['d090'], //  2 ()
		'43'    => self::$pictograms['d089'], //  2 (E)
		'44'    => self::$pictograms['wf048'], // z
		'45'    => self::$pictograms['wf05b'], // 싅{[
		'46'    => self::$pictograms['wf041'], // v
		'47'    => self::$pictograms['wf068'], //  2 ()
		'48'    => self::$pictograms['wf065'], // x
		'49'    => '[e]', // vbVs (e)
		'50'    => self::$pictograms['wf04c'], // 
		'51'    => self::$pictograms['wf040'], // n[g
		'52'    => self::$pictograms['wf057'], // }eB[j (JNeOX)
		'53'    => self::$pictograms['d254'], // lt
		'54'    => self::$pictograms['d239'], // g[h}[N (TM)
		'55'    => self::$pictograms['wf0ba'], // 
		'56'    => self::$pictograms['d076'], //  1
		'57'    => self::$pictograms['d217'], // v 1
		'58'    => self::$pictograms['d217'], // v 2
		'59'    => '[tbs[]', // tbs[fBXN 1
		'60'    => '*', // ̌
		'61'    => self::$pictograms['wf0ba'], // oc 1
		'62'    => self::$pictograms['wf0ba'], // oc 2
		'63'    => '', // E 1
		'64'    => '', //  1
		'65'    => self::$pictograms['wf05f'], // }OJbv
		'66'    => '', // 
		'67'    => '[J_[]', // J_[
		'68'    => self::$pictograms['wf04c'], // X}CtFCX
		'69'    => self::$pictograms['wf096'], //  2
		'70'    => self::$pictograms['d059'], // E 2 (E)
		'71'    => self::$pictograms['d104'], //  2 ()
		'72'    => self::$pictograms['d216'], // WG[
		'73'    => '', // `FbN}[N 1
		'74'    => self::$pictograms['wf06d'], //  (v[h)
		'75'    => self::$pictograms['wf096'], //  3
		'76'    => self::$pictograms['d150'], // Xp[N
		'77'    => self::$pictograms['wf099'], // d
		'78'    => self::$pictograms['wf075'], // 
		'79'    => '[tH_]', // tH_ 1 ()
		'80'    => self::$pictograms['wf04c'], //  1
		'81'    => self::$pictograms['wf0bb'], // Rs[Cg}[N (C)
		'82'    => self::$pictograms['wf0bc'], // WX^[h}[N (R)
		'83'    => self::$pictograms['d069'], // u[tP[X (nhobN)
		'84'    => '[JtH_]', // tH_ 2 (J)
		'85'    => self::$pictograms['d074'], // db 1 (vbVz)
		'86'    => self::$pictograms['d076'], // oRg
		'87'    => '[NWbgJ[h]', // NWbgJ[h
		'88'    => '', // Op 3
		'89'    => '', // Op 3
		'90'    => '[USA]', // USA ()
		'91'    => self::$pictograms['d076'], // m[g 3
		'92'    => self::$pictograms['d076'], // Nbv{[h
		'93'    => self::$pictograms['wf077'], // Jbv
		'94'    => self::$pictograms['d068'], // J
		'95'    => self::$pictograms['wf049'], // J
		'96'    => '[tbg{[]', // tbg{[
		'97'    => self::$pictograms['wf060'], // { 1
		'98'    => self::$pictograms['d245'], // ֎~
		'99'    => self::$pictograms['d048'], // M
		'100'   => self::$pictograms['wf060'], // { 2
		'101'   => self::$pictograms['wf060'], // { 3
		'102'   => self::$pictograms['wf060'], // { 4
		'103'   => self::$pictograms['wf060'], //  2
		'104'   => self::$pictograms['wf083'], // ͂
		'105'   => '[J_[]', // Ђ߂J_[
		'106'   => self::$pictograms['wf097'], // `PbgELbv
		'107'   => self::$pictograms['wf04a'], // 
		'108'   => self::$pictograms['wf063'], // 
		'109'   => self::$pictograms['d113'], // ؎ (CHECK)
		'110'   => self::$pictograms['wf09d'], // rfIJ
		'111'   => self::$pictograms['wf09d'], // nfBJ
		'112'   => self::$pictograms['wf053'], // 
		'113'   => self::$pictograms['wf059'], //  (`[bv)
		'114'   => '[iCt]', // iCt
		'115'   => '[rfIe[v]', // rfIe[v
		'116'   => self::$pictograms['d093'], // ߂
		'117'   => '', //  1
		'118'   => self::$pictograms['d117'], //  2
		'119'   => self::$pictograms['d119'], // ނ߂
		'120'   => self::$pictograms['d116'], // 
		'121'   => self::$pictograms['d076'], // m[g 1
		'122'   => self::$pictograms['d076'], // m[g 2 (J)
		'123'   => '[{gƃibg]', // {g & ibg
		'124'   => self::$pictograms['d055'], //  (nCq[)
		'125'   => self::$pictograms['d033'], // 
		'126'   => '[tbs[]', // tbs[ 2
		'127'   => '[_Ot]', // `[g (_Ot)
		'128'   => '[܂Ot]', // Ot 1 (܂Ot)
		'129'   => self::$pictograms['wf063'], // [{bNX
		'130'   => '[d]', // d
		'131'   => '[Roldex]', // Roldex
		'132'   => '', // `FbN}[N 2
		'134'   => self::$pictograms['wf06d'], // 
		'135'   => '[dr]', // dr
		'136'   => '[XN[]', // XN[
		'137'   => '[e]', // т傤
		'138'   => self::$pictograms['d116'], // O
		'139'   => self::$pictograms['wf097'], // hD
		'140'   => '', // wmF
		'141'   => '', // wmFE
		'142'   => self::$pictograms['d070'], // 䒠
		'143'   => self::$pictograms['wf08c'], // Nbv
		'144'   => self::$pictograms['wf090'], // v[g
		'145'   => '[D]', // D
		'146'   => self::$pictograms['wf056'], // Sn 1 (iCtƃtH[N)
		'147'   => self::$pictograms['d070'], // {
		'148'   => '[gbN]', // gbN
		'149'   => self::$pictograms['wf061'], // Gsc
		'150'   => '[IDO]', // S (PDC)
		'151'   => self::$pictograms['wf063'], //  2
		'152'   => self::$pictograms['d213'], // `
		'153'   => self::$pictograms['wf063'] . "", // M BOX
		'154'   => self::$pictograms['d106'], // M BOX
		'155'   => self::$pictograms['wf042'], // db 2 (b)
		'156'   => self::$pictograms['wf054'], // HE
		'157'   => '', // K 1 ()
		'158'   => '', // K 2 (Op)
		'159'   => '[܂Ot]', // Ot 2
		'160'   => self::$pictograms['wf06c'], // H 2 (}K)
		'161'   => self::$pictograms['wf095'], // db 3 (g)
		'162'   => '[RZg]', // RZg
		'163'   => self::$pictograms['wf053'], // Ƒ
		'164'   => self::$pictograms['d071'], // N
		'165'   => self::$pictograms['d072'], // pbP[W
		'166'   => self::$pictograms['d107'], // FAX
		'167'   => self::$pictograms['d001'] . self::$pictograms['d002'], // Ƃǂ܂
		'168'   => self::$pictograms['wf051'], // s@
		'169'   => self::$pictograms['d102'], // {[g (D)
		'170'   => '[TCR]', // TCR
		'171'   => self::$pictograms['d076'], // V
		'172'   => self::$pictograms['wf050'], // d
		'173'   => '@', // SuN
		'174'   => ' ', // uN
		'175'   => ' ', // 41uN
		'176'   => self::$pictograms['wf078'], // i
		'177'   => self::$pictograms['wf064'], // ։
		'178'   => self::$pictograms['d094'], // Ԉ֎q
		'179'   => self::$pictograms['wf0b1'], // t}[N
		'180'   => self::$pictograms['wf0bf'], // lp 1
		'181'   => self::$pictograms['wf0c0'], // lp 2
		'182'   => self::$pictograms['wf0c1'], // lp 3
		'183'   => self::$pictograms['wf0c2'], // lp 4
		'184'   => self::$pictograms['wf0c3'], // lp 5
		'185'   => self::$pictograms['wf0c4'], // lp 6
		'186'   => self::$pictograms['wf0c5'], // lp 7
		'187'   => self::$pictograms['wf0c6'], // lp 8
		'188'   => self::$pictograms['wf0c7'], // lp 9
		'189'   => self::$pictograms['wf0be'], // lp 10
		'190'   => self::$pictograms['wf0a8'], // 䕗
		'191'   => self::$pictograms['wf08d'], // 䂫
		'192'   => self::$pictograms['wf0c8'], //  (Ђ)
		'193'   => self::$pictograms['wf0c9'], //  ()
		'194'   => self::$pictograms['wf0ca'], //  (oq)
		'195'   => self::$pictograms['wf0cb'], //  (ɍ)
		'196'   => self::$pictograms['wf0cc'], //  ()
		'197'   => self::$pictograms['wf0cd'], //  (Ƃߍ)
		'198'   => self::$pictograms['wf0ce'], //  (V)
		'199'   => self::$pictograms['wf0cf'], //  ()
		'200'   => self::$pictograms['wf0d1'], //  (č)
		'201'   => self::$pictograms['wf0d2'], //  (€)
		'202'   => self::$pictograms['wf0d3'], //  (r)
		'203'   => self::$pictograms['wf0d4'], //  ()
		'204'   => self::$pictograms['wf0d0'], //  (ւт)
		'205'   => self::$pictograms['d043'], // ATM
		'206'   => self::$pictograms['d045'], // 24 HOURS (Rrj)
		'207'   => self::$pictograms['d049'], // gC
		'208'   => self::$pictograms['d047'], // p[LO
		'209'   => self::$pictograms['d035'], // oX
		'210'   => self::$pictograms['d121'], // Aei (ʒu}[N)
		'211'   => self::$pictograms['wf085'], // ` (}[N)
		'212'   => self::$pictograms['d042'], // s
		'213'   => self::$pictograms['d046'], // KXX^h
		'214'   => '[n}]', // n}
		'215'   => self::$pictograms['d218'], // ]
		'216'   => self::$pictograms['wf0af'], // oX
		'217'   => self::$pictograms['d032'], // V
		'218'   => self::$pictograms['d240'], // }\
		'219'   => self::$pictograms['wf0b0'], // TbJ[
		'220'   => self::$pictograms['wf09c'], // ejX
		'221'   => self::$pictograms['d207'], // Xm[{[h
		'222'   => self::$pictograms['d028'], // `FbJ[tbO ([^[X|[c)
		'223'   => self::$pictograms['d060'], // Vn
		'224'   => self::$pictograms['wf067'], // 
		'225'   => self::$pictograms['d264'], //  (Ԃ傤)
		'226'   => self::$pictograms['d167'], // f ()
		'227'   => self::$pictograms['d172'], // ̋
		'228'   => '[^[]', // ^[
		'229'   => self::$pictograms['wf0bd'], // Xbg (777)
		'230'   => '[]', //  (A^̂)
		'231'   => '', // I|
		'232'   => self::$pictograms['d078'], // Q[̃Rg[
		'233'   => self::$pictograms['wf091'], // ܋
		'234'   => self::$pictograms['d103'], // NX}Xc[
		'235'   => self::$pictograms['d261'], // Ԍ ()
		'236'   => '[]', // 
		'237'   => self::$pictograms['wf069'], //  (jE̊)
		'238'   => self::$pictograms['wf080'], // XCJ
		'239'   => self::$pictograms['d263'], // P[L
		'240'   => '[tCp]', // tCp (ڋʏĂ)
		'241'   => self::$pictograms['d255'], // 
		'242'   => '[͓]', // ӂ
		'243'   => '[]', // C`S
		'244'   => self::$pictograms['wf07a'], // ɂ
		'245'   => self::$pictograms['d054'], // no[K[ (t@[Xgt[h)
		'246'   => '[~]', // 
		'247'   => '[e]', // 
		'248'   => self::$pictograms['d273'], // 
		'249'   => self::$pictograms['wf06f'], // 
		'250'   => self::$pictograms['wf086'], // 
		'251'   => self::$pictograms['wf06e'], // L
		'252'   => self::$pictograms['d269'], // yM
		'253'   => '[a]', // 
		'254'   => self::$pictograms['d274'], // Ԃ
		'255'   => '[q̖]', // ₵̂
		'256'   => '[]', // Ђ܂
		'257'   => self::$pictograms['wf04c'], //  1 (ꂵJI)
		'258'   => self::$pictograms['wf05e'], //  2 (JI)
		'259'   => self::$pictograms['wf058'], //  3 (ȂJI)
		'260'   => self::$pictograms['wf076'], //  4 (ꂽJI)
		'261'   => self::$pictograms['d157'], //  (ZZZ...)
		'262'   => self::$pictograms['wf074'], // { (Jb)
		'263'   => self::$pictograms['wf04b'], //  (܁E)
		'264'   => self::$pictograms['d229'], // 炩 (ׂ)
		'265'   => self::$pictograms['wf088'], // n[g 2 (Ă)
		'266'   => self::$pictograms['wf098'], // n[g 3 (傫 & )
		'267'   => self::$pictograms['d150'], // Xp[N 2 (L}[N)
		'268'   => self::$pictograms['d154'], // e
		'269'   => '[]', // 
		'270'   => '[SOS]', // { (SOS)
		'271'   => self::$pictograms['wf0a5'], // ͂
		'272'   => self::$pictograms['wf0a6'], // n[g 5 (Ă)
		'273'   => self::$pictograms['wf04d'], // LX}[N
		'274'   => self::$pictograms['d170'], // Fl
		'275'   => self::$pictograms['d006'], // Ȃ
		'276'   => self::$pictograms['wf09a'], //  ()
		'277'   => '' . self::$pictograms['d225'] . '', // 
		'278'   => self::$pictograms['wf0a7'], // Ԋ
		'279'   => self::$pictograms['d241'], // ۔
		'280'   => '[100_]', // 100__
		'281'   => self::$pictograms['d153'], // p`
		'282'   => self::$pictograms['d164'], // _bV
		'283'   => self::$pictograms['wf07c'], // E`}[N
		'284'   => '', // lwTC
		'285'   => '()', // }
		'286'   => self::$pictograms['wf062'], // ǂ
		'287'   => self::$pictograms['wf0a4'], // уTC (w)
		'288'   => self::$pictograms['d077'], // er
		'289'   => self::$pictograms['wf073'], // }CN
		'290'   => self::$pictograms['d204'], // z
		'291'   => self::$pictograms['wf04e'], // fB
		'292'   => '[M^[]', // M^[ (GL)
		'293'   => '[oCI]', // oCI (NVbN)
		'294'   => self::$pictograms['d061'], // wbhtH
		'295'   => self::$pictograms['d205'], // g
		'296'   => '[sXg]', // ANV (sXg)
		'297'   => '[GXe]', // GXe
		'298'   => '[EZ]', // EZ }[N
		'299'   => self::$pictograms['d114'], //  (FREE)
		'300'   => self::$pictograms['d079'], // CD/DVD
		'301'   => self::$pictograms['d203'], // wl
		'302'   => '[UFO]', // UFO
		'303'   => self::$pictograms['d150'], // XV (UP!)
		'304'   => self::$pictograms['wf084'], // ˊ ()
		'305'   => self::$pictograms['d007'], // 
		'306'   => self::$pictograms['d023'], // St
		'307'   => self::$pictograms['d027'], // oXPbg{[
		'308'   => self::$pictograms['d029'], // |Pbgx
		'309'   => self::$pictograms['d062'], // A[g
		'310'   => self::$pictograms['d063'], // 
		'311'   => self::$pictograms['d064'], // Cxg (T[JX)
		'312'   => self::$pictograms['d071'], // {
		'313'   => self::$pictograms['wf08e'], // o[Xf[
		'314'   => self::$pictograms['wf08b'], // Xy[h
		'315'   => self::$pictograms['wf089'], // _C
		'316'   => self::$pictograms['wf08a'], // Nu
		'317'   => self::$pictograms['d084'], // 
		'318'   => self::$pictograms['d085'], // 
		'319'   => self::$pictograms['wf055'], //  (`L)
		'320'   => self::$pictograms['wf087'], //  (p[)
		'321'   => self::$pictograms['d095'], // V
		'322'   => self::$pictograms['d096'], // ⌇
		'323'   => self::$pictograms['d097'], // 
		'324'   => self::$pictograms['d118'], // NA
		'325'   => self::$pictograms['wf0be'], // lp 0
		'326'   => self::$pictograms['d135'], //  (OK)
		'327'   => self::$pictograms['wf076'], // ӂӂ ()
		'328'   => self::$pictograms['d148'], // 킢
		'329'   => self::$pictograms['d161'], // ǂ (Ռ)
		'330'   => self::$pictograms['wf079'], //  (юU銾)
		'331'   => '[ezplus]', // C[W[vX
		'332'   => '[n]', // n
		'333'   => self::$pictograms['wf072'], // [
		'334'   => self::$pictograms['d120'], // NEW
		'335'   => self::$pictograms['wf07e'], // am
		'336'   => self::$pictograms['d092'], // amC
		'337'   => self::$pictograms['d211'], // p\R
		'338'   => self::$pictograms['d061'], // WI
		'339'   => self::$pictograms['d261'], // o
		'340'   => self::$pictograms['d208'], // `y
		'341'   => self::$pictograms['d031'], // nS
		'342'   => self::$pictograms['wf0ac'], // xmR
		'343'   => self::$pictograms['d146'], // 
		'344'   => '[Vg]', // Vg
		'345'   => '[]', // g
		'346'   => '[F]', // 
		'347'   => '[l]', // ˂
		'348'   => self::$pictograms['d230'], // EBN ()
		'349'   => self::$pictograms['d227'], // ڂn[g ()
		'350'   => self::$pictograms['d276'], // VbLO ()
		'351'   => self::$pictograms['d221'], //  ()
		'352'   => self::$pictograms['wf071'], // 
		'353'   => '[Pbg]', // Pbg
		'354'   => self::$pictograms['d215'], // 
		'355'   => self::$pictograms['d149'], // `[ (LXĂ)
		'356'   => '[n}[]', // n}[
		'357'   => '[ԉ]', // łグԉ
		'358'   => self::$pictograms['wf0ae'], // ͂t
		'359'   => self::$pictograms['d069'], // d΂
		'360'   => '[]', // 
		'361'   => self::$pictograms['wf0ad'], // Lv
		'362'   => '[]', // 
		'363'   => '[VS]', // VS (o[TX)
		'364'   => '[gtB[]', // gtB[
		'365'   => '[T]', // J
		'366'   => '[XyC]', // XyC
		'367'   => '[VA]', // VA
		'368'   => '[H]', // H
		'369'   => self::$pictograms['d147'], // C
		'370'   => '[j]', // j}[N
		'371'   => '[[]', // [X
		'372'   => '[]', // 
		'373'   => '[]', // 
		'374'   => '[x@]', // |X
		'375'   => self::$pictograms['d040'], // X֋
		'376'   => self::$pictograms['d041'], // a@
		'377'   => self::$pictograms['d251'], // wZ
		'378'   => self::$pictograms['d044'], // ze
		'379'   => self::$pictograms['d036'], // D
		'380'   => self::$pictograms['wf0b5'], // 18
		'381'   => self::$pictograms['wf0b8'], // 
		'382'   => '[COOL!]', // COOL!
		'383'   => '[]', // }[N
		'384'   => '[T]', // UE}[N
		'385'   => self::$pictograms['d115'], // ID}[N
		'386'   => self::$pictograms['d248'], // }[N
		'387'   => self::$pictograms['d246'], // }[N
		'388'   => '[w]', // w}[N
		'389'   => '[c]', // cƒ}[N
		'390'   => '', // w
		'391'   => '', // w
		'392'   => '[肢]', // 肢 ()
		'393'   => self::$pictograms['wf095'], // }i[[h
		'394'   => self::$pictograms['wf095'], // dOFF
		'395'   => self::$pictograms['d076'], // 
		'396'   => self::$pictograms['wf07d'], // lN^C
		'397'   => self::$pictograms['d148'], // nCrXJX
		'398'   => self::$pictograms['wf066'], // ԑ
		'399'   => '[T{e]', // T{e
		'400'   => self::$pictograms['d264'], // q & t
		'401'   => self::$pictograms['wf05f'], // t (r[)
		'402'   => '[j]', // j}[N
		'403'   => '[]', // ז (JvZ)
		'404'   => '[D]', // D
		'405'   => '[NbJ[]', // NbJ[
		'406'   => '[eznavi]', // eznavigation
		'407'   => '[Xq]', // Xq
		'408'   => self::$pictograms['d092'], // Ou[c
		'409'   => self::$pictograms['d205'], // lC
		'410'   => self::$pictograms['wf083'], // e@
		'411'   => '[X]', // 
		'412'   => '[]', // 
		'413'   => self::$pictograms['wf082'], // rLj
		'414'   => self::$pictograms['wf040'], // n[g (gv)
		'415'   => self::$pictograms['d136'], // n[g
		'416'   => self::$pictograms['wf040'], // n[g
		'417'   => self::$pictograms['wf040'], // ΃n[g
		'418'   => self::$pictograms['wf040'], // n[g
		'419'   => self::$pictograms['wf040'], // n[g
		'420'   => self::$pictograms['wf040'], // 炫
		'421'   => self::$pictograms['wf09e'], // XL[
		'422'   => '', // 
		'423'   => self::$pictograms['d219'], // {
		'424'   => self::$pictograms['d266'], // Hp
		'425'   => '[\tgN[]', // \tgN[
		'426'   => '[|eg]', // |eg
		'427'   => '[cq]', // 
		'428'   => '[]', // ׂ
		'429'   => '[]', // ͂
		'430'   => '[XpQeB]', // XpQeB
		'431'   => '[J[]', // J[
		'432'   => '[ł]', // ł
		'433'   => '[i]', // i
		'434'   => self::$pictograms['wf08f'], // 
		'435'   => '[]', // ݂
		'436'   => '[g}g]', // g}g
		'437'   => '[֎q]', // Ȃ
		'438'   => '[ٓ]', // ٓ
		'439'   => '[]', // 
		'440'   => self::$pictograms['d222'], // ӂ ()
		'441'   => self::$pictograms['d142'], // ڂ ()
		'442'   => self::$pictograms['d231'], // ւ ()
		'443'   => self::$pictograms['d143'], // s ()
		'444'   => self::$pictograms['d221'], // 킩
		'445'   => self::$pictograms['d157'], // 
		'446'   => self::$pictograms['d223'], // ĂĂ ()
		'447'   => self::$pictograms['d224'], //  ()
		'448'   => self::$pictograms['wf06a'], // ׂЂ
		'449'   => self::$pictograms['wf06a'], // M ()
		'450'   => self::$pictograms['d226'], //  ()
		'451'   => self::$pictograms['d276'], // т ()
		'452'   => self::$pictograms['d224'], //  ()
		'453'   => self::$pictograms['d155'], // y
		'454'   => self::$pictograms['d231'], // ɂɂ ()
		'455'   => self::$pictograms['d227'], // `[ 2 ()
		'456'   => self::$pictograms['d227'], // `b ()
		'457'   => '[@]', // @
		'458'   => self::$pictograms['d149'], // 
		'459'   => '[S]', // S^肢
		'460'   => self::$pictograms['d088'] . self::$pictograms['d088'], // 
		'461'   => self::$pictograms['d135'], // OK! (wŊۃTC)
		'462'   => self::$pictograms['d156'], // u[CO (w)
		'463'   => self::$pictograms['d088'], // oCoC
		'464'   => self::$pictograms['d236'], // NG (lR)
		'465'   => self::$pictograms['d135'], // OK! 2 (lR)
		'466'   => '[S]', // ӂ (lR)
		'467'   => '[Jbv]', // Jbv
		'468'   => '[oj[]', // oj[
		'469'   => '[gybg]', // gybg
		'470'   => '[r[h]', // r[h
		'471'   => '[j]', // j
		'472'   => self::$pictograms['wf04f'], // h
		'473'   => self::$pictograms['wf04f'], // ~}
		'474'   => self::$pictograms['wf04f'], // pgJ[
		'475'   => self::$pictograms['d032'], // WFbgR[X^[
		'476'   => '[叼]', // 叼
		'477'   => '[Ղ]', // Ղ
		'478'   => '[Ǝ]', // Ǝ
		'479'   => '[w]', // w
		'480'   => self::$pictograms['d270'], // ̂ڂ
		'481'   => self::$pictograms['d008'], // P
		'482'   => self::$pictograms['d170'], // ԉ
		'483'   => self::$pictograms['wf081'], // X
		'484'   => '[ԉ]', // ԉ
		'485'   => '[L]', // L
		'486'   => '[]', // 
		'487'   => '[nEB]', // nEB
		'488'   => self::$pictograms['d172'], // 
		'489'   => '[T^]', // T^
		'490'   => self::$pictograms['d172'], // ^ꐯ
		'491'   => '[]', // 
		'492'   => self::$pictograms['d044'], // ze 2
		'493'   => self::$pictograms['d001'], // ̏o
		'494'   => self::$pictograms['d063'], // VNnbg
		'495'   => self::$pictograms['d039'], // fp[g
		'496'   => self::$pictograms['d039'], //  ({)
		'497'   => self::$pictograms['d039'], //  ([bp)
		'498'   => self::$pictograms['d039'], // H 2
		'499'   => '[tX]', // tX
		'500'   => '[I[vEF[u]', // I[vEF[u
		'501'   => self::$pictograms['d116'], // bNmF
		'502'   => '[ABC]', // 啶
		'503'   => '[abc]', // 
		'504'   => '[012]', // 
		'505'   => '[,@#]', // L
		'506'   => '[]', // ANZvg
		'507'   => '', // `FbN{bNX
		'508'   => self::$pictograms['d169'], // GfBbg
		'509'   => '', // WI{^
		'510'   => self::$pictograms['d119'], //  (ዾ)
		'511'   => self::$pictograms['d117'], // ߂
		'512'   => self::$pictograms['d076'], // Cɓ
		'513'   => self::$pictograms['d175'], // I
		'514'   => self::$pictograms['d038'], // z[
		'515'   => self::$pictograms['d106'], // M 1
		'516'   => '', // }[N
		'517'   => self::$pictograms['d116'], // l ()
		'518'   => self::$pictograms['d242'], // ēǂݍ
		'700'   => '[hCc]', // hCc
		'701'   => '[C^A]', // C^A
		'702'   => '[CMX]', // CMX
		'703'   => '[]', // 
		'704'   => '[؍]', // ؍
		'705'   => '[l]', // l
		'706'   => '[l]', // l
		'707'   => '[Chl]', // Chl
		'708'   => self::$pictograms['d170'], // 
		'709'   => self::$pictograms['d170'], // ΂
		'710'   => self::$pictograms['d222'], // Ԃ
		'711'   => self::$pictograms['d170'], // H̐l
		'712'   => self::$pictograms['d170'], // Pl
		'713'   => self::$pictograms['d270'], // CJ
		'714'   => '[_X]', // _X
		'715'   => self::$pictograms['d270'], // Mы
		'716'   => '[ђ]', // 
		'717'   => self::$pictograms['wf070'], // 
		'718'   => '[RA]', // RA
		'719'   => '[]', // zX^C
		'720'   => '[]', // wr
		'721'   => self::$pictograms['d268'], // {
		'722'   => '[ZV]', // ڂ
		'723'   => '[ӂԃN_]', // ӂԂ炭
		'724'   => '[A^]', // A^
		'725'   => '[B^]', // B^
		'726'   => '[O^]', // O^
		'727'   => '[AB^]', // AB^
		'728'   => self::$pictograms['wf09a'], // 
		'729'   => self::$pictograms['d092'], // Xj[J[
		'730'   => self::$pictograms['d121'], // 
		'731'   => self::$pictograms['d145'], // J[u
		'732'   => self::$pictograms['d156'], // J[u
		'733'   => self::$pictograms['d159'], // u!?v
		'734'   => self::$pictograms['d160'], // u!!v
		'735'   => self::$pictograms['d166'], // 
		'736'   => '[]', // 
		'737'   => '[pCibv]', // pCibv
		'738'   => '[]', // Ԃǂ
		'739'   => self::$pictograms['d257'], // oii
		'740'   => '[Ƃ낱]', // Ƃ낱
		'741'   => '[̂]', // ̂
		'742'   => '[I]', // I
		'743'   => self::$pictograms['wf0e0'], // 
		'744'   => '[Ĉ]', // ₫
		'745'   => '[sU]', // sU
		'746'   => '[^[L[]', // ^[L[
		'747'   => '[[]', // [
		'748'   => self::$pictograms['d275'], // gsJhN
		'749'   => '[C]', // C
		'750'   => '[sAm]', // sAm
		'751'   => self::$pictograms['wf0aa'], // T[tB
		'752'   => self::$pictograms['d270'], // ނ
		'753'   => '[{EO]', // {EO
		'754'   => '[Ȃ܂͂]', // Ȃ܂͂
		'755'   => self::$pictograms['d225'], // V
		'756'   => '[p_]', // p_
		'757'   => self::$pictograms['d229'], // ׁ[
		'758'   => self::$pictograms['d274'], // Ԃ̕@
		'759'   => self::$pictograms['wf066'], // 
		'760'   => '[ACXN[]', // ACXN[
		'761'   => '', // h[ic
		'762'   => '[NbL[]', // NbL[
		'763'   => '[`R]', // `R
		'764'   => '[LfB]', // LfB ()
		'765'   => '[؂؂LfB]',// LfB (؂؂)
		'766'   => self::$pictograms['wf06f'], //  ()
		'767'   => self::$pictograms['wf06f'], // 킴 ()
		'768'   => self::$pictograms['wf06f'], //  ()
		'769'   => self::$pictograms['wf0ab'], // ΎR
		'770'   => self::$pictograms['d136'] . self::$pictograms['d071'], // {̃n[g
		'771'   => '[ABC]', // puABCv
		'772'   => '[v]', // v
		'773'   => '[I]', // ~co`
		'774'   => '[ĂƂ]', // egEV
		'775'   => '[I|bg]', // I|bg
		'776'   => self::$pictograms['wf08f'], // 
		'777'   => self::$pictograms['d113'], // Ĥ͂D
		'778'   => self::$pictograms['wf0a8'], // ڂ܂鎞̋L
		'779'   => self::$pictograms['d225'], // Ձ[ (킢{)
		'780'   => self::$pictograms['d225'], // Ձ[ (킢{) (lR)
		'781'   => self::$pictograms['d172'], // V̐
		'782'   => self::$pictograms['d227'], // `[ (lR)
		'783'   => self::$pictograms['d231'], // ɂ (lR)
		'784'   => self::$pictograms['wf063'], // [
		'785'   => self::$pictograms['wf058'], // ΂ (lR)
		'786'   => self::$pictograms['wf058'], // ΂ ()
		'787'   => self::$pictograms['d227'], // ڂn[g (lR)
		'788'   => self::$pictograms['d234'], // ق[ (lR)
		'789'   => self::$pictograms['d234'], // ق[ ()
		'790'   => self::$pictograms['wf04b'], // ܂ۂ (lR)
		'791'   => self::$pictograms['wf04b'], // ܂ۂ ()
		'792'   => self::$pictograms['d226'], //  (lR)
		'793'   => '[hX]', // hX
		'794'   => self::$pictograms['wf140'], // C
		'795'   => '[w]', // w
		'796'   => '[ԎD]', // ԎD
		'797'   => '[W[J[]', // W[J[
		'798'   => '[CVtC]', // GrtC
		'799'   => self::$pictograms['wf063'], // e[ACR
		'800'   => self::$pictograms['d240'], // l
		'801'   => '[pgJ[]', // pgJ[̃v
		'802'   => self::$pictograms['wf09d'], // ezmovie
		'803'   => self::$pictograms['d137'], // hLhLĂn[g
		'804'   => self::$pictograms['wf075'], // ʌ̂Ђ悱
		'805'   => self::$pictograms['d206'], // W[Y
		'806'   => self::$pictograms['d212'], // n[g[
		'807'   => self::$pictograms['wf0b7'], // z
		'808'   => self::$pictograms['wf046'], // E
		'809'   => self::$pictograms['wf045'], // ㉺
		'810'   => self::$pictograms['d252'], // rg
		'811'   => self::$pictograms['d259'], // ot
		'812'   => self::$pictograms['d267'], // ނ
		'813'   => self::$pictograms['d272'], //  (lR)
		'814'   => self::$pictograms['d272'], //  ()
		'815'   => self::$pictograms['wf063'], // C[ACR
		'816'   => self::$pictograms['d259'], // n[u
		'817'   => self::$pictograms['wf05c'], //  (O[)
		'818'   => self::$pictograms['d123'], // u#v
		'819'   => self::$pictograms['d140'], //  (LN^[)
		'820'   => self::$pictograms['d231'], //  (LN^[)
		'821'   => self::$pictograms['d142'], // ڂ (LN^[)
		'822'   => self::$pictograms['d225'], // 킢{ (LN^[)
		'se001' => self::$pictograms['wf04c'], // j̎q
		'se002' => self::$pictograms['wf04c'], // ̎q
		'se003' => self::$pictograms['wf04d'], // e (LX}[N)
		'se004' => self::$pictograms['wf04c'], // 
		'se005' => self::$pictograms['wf04c'], // ꂳ
		'se006' => self::$pictograms['d203'], // m
		'se007' => self::$pictograms['d092'], // u[c
		'se008' => self::$pictograms['d068'], // J
		'se009' => self::$pictograms['wf042'], // db
		'se00a' => self::$pictograms['wf095'], // gѓdb
		'se00b' => self::$pictograms['d107'], // FAX
		'se00c' => self::$pictograms['d211'], // p\R
		'se00d' => self::$pictograms['d153'], // p`
		'se00e' => self::$pictograms['wf0a4'], // GOOD!
		'se00f' => '[No.1!]', // No.1!
		'se010' => self::$pictograms['wf05c'], // O[
		'se011' => self::$pictograms['wf055'], // `L
		'se012' => self::$pictograms['wf087'], // p[
		'se013' => self::$pictograms['wf09e'], // XL[
		'se014' => self::$pictograms['d023'], // St
		'se015' => self::$pictograms['wf09c'], // ejX
		'se016' => self::$pictograms['wf05b'], // 싅
		'se017' => self::$pictograms['wf0aa'], // T[tB
		'se018' => self::$pictograms['wf0b0'], // TbJ[
		'se019' => self::$pictograms['d270'], // 
		'se01a' => self::$pictograms['d273'], // 
		'se01b' => self::$pictograms['wf04f'], // 
		'se01c' => self::$pictograms['d102'], // bg
		'se01d' => self::$pictograms['wf051'], // s@
		'se01e' => self::$pictograms['wf050'], // d
		'se01f' => self::$pictograms['d032'], // V
		'se020' => self::$pictograms['wf0a1'], // nei
		'se021' => self::$pictograms['d158'], // rbN
		'se022' => self::$pictograms['wf040'], // n[g}[N
		'se023' => self::$pictograms['wf088'], // n[guCN
		'se024' => self::$pictograms['wf041'], // 1
		'se025' => self::$pictograms['wf041'], // 2
		'se026' => self::$pictograms['wf041'], // 3
		'se027' => self::$pictograms['wf041'], // 4
		'se028' => self::$pictograms['wf041'], // 5
		'se029' => self::$pictograms['wf041'], // 6
		'se02a' => self::$pictograms['wf041'], // 7
		'se02b' => self::$pictograms['wf041'], // 8
		'se02c' => self::$pictograms['wf041'], // 9
		'se02d' => self::$pictograms['wf041'], // 10
		'se02e' => self::$pictograms['wf041'], // 11
		'se02f' => self::$pictograms['wf041'], // 12
		'se030' => self::$pictograms['wf041'], // Ԍ
		'se031' => self::$pictograms['d215'], // Gu
		'se032' => self::$pictograms['d261'], // o
		'se033' => self::$pictograms['d103'], // NX}X
		'se034' => self::$pictograms['d216'], // w
		'se035' => self::$pictograms['d216'], // 
		'se036' => self::$pictograms['wf053'], // 
		'se037' => '[]', // 
		'se038' => self::$pictograms['wf054'], // r
		'se039' => '[w]', // w
		'se03a' => self::$pictograms['d046'], // K\X^h
		'se03b' => self::$pictograms['wf0ab'], // R
		'se03c' => self::$pictograms['wf073'], // }CN
		'se03d' => self::$pictograms['wf09d'], // f
		'se03e' => self::$pictograms['wf06b'], // y
		'se03f' => self::$pictograms['d116'], // JM
		'se040' => '[TbNX]', // TbNX
		'se041' => '[M^[]', // M^[
		'se042' => '[gybg]', // gybg
		'se043' => self::$pictograms['wf056'], // Xg
		'se044' => self::$pictograms['wf057'], // JNe
		'se045' => self::$pictograms['wf077'], // R[q[
		'se046' => self::$pictograms['d263'], // P[L
		'se047' => self::$pictograms['d053'], // r[
		'se048' => self::$pictograms['wf08d'], // 
		'se049' => self::$pictograms['wf04a'], // ܂
		'se04a' => self::$pictograms['wf048'], //  ()
		'se04b' => self::$pictograms['wf049'], // J
		'se04c' => self::$pictograms['wf068'], //  ()
		'se04d' => self::$pictograms['wf048'], // 
		'se04e' => '[Vg]', // Vg
		'se04f' => self::$pictograms['wf06e'], // ˂
		'se050' => '[]', // Ƃ
		'se051' => '[F]', // 
		'se052' => self::$pictograms['wf06d'], // 
		'se053' => '[l]', // ˂
		'se054' => '[~]', // NW
		'se055' => self::$pictograms['d269'], // yM
		'se056' => self::$pictograms['wf04c'], // y ()
		'se057' => self::$pictograms['wf09b'], //  ()
		'se058' => self::$pictograms['wf058'], //  ()
		'se059' => self::$pictograms['wf05e'], // { ()
		'se05a' => self::$pictograms['wf07c'], // E`
		'se101' => self::$pictograms['wf063'], // [M
		'se102' => self::$pictograms['wf063'] . '', // [M
		'se103' => self::$pictograms['wf063'], // [
		'se104' => self::$pictograms['d105'], // dbA
		'se105' => self::$pictograms['d229'], // AJx[ ()
		'se106' => self::$pictograms['d227'], // uu ()
		'se107' => self::$pictograms['d276'], // Kr[ ()
		'se108' => self::$pictograms['d224'], // ^[ ()
		'se109' => self::$pictograms['wf06f'], // 
		'se10a' => self::$pictograms['wf071'], // ^R
		'se10b' => self::$pictograms['d274'], // Ԃ
		'se10c' => '[Fl]', // Fl
		'se10d' => '[Pbg]', // Pbg
		'se10e' => self::$pictograms['d215'], // 
		'se10f' => self::$pictograms['wf099'], // d
		'se110' => self::$pictograms['d254'], // 
		'se111' => self::$pictograms['wf04d'], // LX
		'se112' => self::$pictograms['wf090'], // o[Xf[ (v[g)
		'se113' => '[sXg]', // sXg
		'se114' => self::$pictograms['d119'], // ዾ
		'se115' => self::$pictograms['d240'], // 
		'se116' => '[I[NV]', // I[NV
		'se117' => self::$pictograms['d150'], // ԉ
		'se118' => self::$pictograms['d260'], // ݂
		'se119' => self::$pictograms['wf0ae'], // t
		'se11a' => '[]', // 
		'se11b' => '[]', // ΂
		'se11c' => self::$pictograms['wf062'], // hN
		'se11d' => '[]', // t@C[
		'se11e' => self::$pictograms['d069'], // ΂
		'se11f' => self::$pictograms['d171'], // 
		'se120' => self::$pictograms['d054'], // no[K[
		'se121' => '[]', // 
		'se122' => self::$pictograms['wf0ad'], // Lv
		'se123' => self::$pictograms['wf067'], // 
		'se124' => self::$pictograms['d060'], // Vn
		'se125' => self::$pictograms['wf097'], // `Pbg
		'se126' => self::$pictograms['d079'], // CD
		'se127' => self::$pictograms['d079'], // DVD
		'se128' => self::$pictograms['d061'], // WI
		'se129' => '[rfI]', // rfI
		'se12a' => self::$pictograms['d077'], // er
		'se12b' => self::$pictograms['d078'], // Q[
		'se12c' => self::$pictograms['d146'], // ̂o
		'se12d' => '[]', // }[W
		'se12e' => '[VS]', // Ό
		'se12f' => self::$pictograms['wf091'], // ܋ (h)
		'se130' => '[]', // 
		'se131' => '[gtB[]', // gtB[
		'se132' => self::$pictograms['d028'], // S[ (`FbJ[tbO)
		'se133' => self::$pictograms['wf0bd'], // Xbg (777)
		'se134' => self::$pictograms['d273'], // n
		'se135' => self::$pictograms['d102'], // 
		'se136' => self::$pictograms['d218'], // 
		'se137' => '[H]', // H
		'se138' => '', // j
		'se139' => '', // 
		'se13a' => '[Ԃ]', // c
		'se13b' => self::$pictograms['wf084'], // ˊ
		'se13c' => self::$pictograms['d157'], //  (Zzz)
		'se13d' => self::$pictograms['wf05d'], // 
		'se13e' => self::$pictograms['d055'], // nCq[
		'se13f' => self::$pictograms['d147'], // 
		'se140' => self::$pictograms['d049'], // gC
		'se141' => '[]', // 
		'se142' => '[Kz]', // m点 (Kz)
		'se143' => '[j]', // j
		'se144' => self::$pictograms['d116'], // bNON
		'se145' => self::$pictograms['d116'], // bNOFF
		'se146' => '[X]', // X
		'se147' => '[]', //  ()
		'se148' => self::$pictograms['d070'], // {
		'se149' => '[$\\]', // ב֑
		'se14a' => '[]', // 
		'se14b' => '[p{]', // j[X (p{Aei)
		'se14c' => self::$pictograms['wf0a5'], // C (͂)
		'se14d' => self::$pictograms['d042'], // s
		'se14e' => self::$pictograms['d048'], // M
		'se14f' => self::$pictograms['d047'], // ԏ
		'se150' => self::$pictograms['d035'], // oX
		'se151' => self::$pictograms['d049'], // OgC
		'se152' => '[]', // 
		'se153' => self::$pictograms['d040'], // X֋
		'se154' => self::$pictograms['d043'], // ATM
		'se155' => self::$pictograms['d041'], // a@
		'se156' => self::$pictograms['d045'], // Rrj
		'se157' => self::$pictograms['d251'], // wZ
		'se158' => self::$pictograms['d044'], // ze
		'se159' => self::$pictograms['d035'], // oX
		'se15a' => self::$pictograms['d033'], // ^NV[
		'se201' => self::$pictograms['d240'], // k
		'se202' => self::$pictograms['d036'], // D
		'se203' => '[RR]', // ړIn (RR)
		'se204' => self::$pictograms['d148'], // r1
		'se205' => self::$pictograms['d148'], // r2
		'se206' => self::$pictograms['d148'], // r3
		'se207' => self::$pictograms['wf0b5'], // 18
		'se208' => self::$pictograms['wf064'], // ։
		'se209' => self::$pictograms['wf0b1'], // S
		'se20a' => self::$pictograms['d094'], // oAt[ (Ԉ֎q}[N)
		'se20b' => self::$pictograms['wf0b8'], // Aei}[N
		'se20c' => self::$pictograms['wf040'], // n[g (gv)
		'se20d' => self::$pictograms['wf089'], // _C (gv)
		'se20e' => self::$pictograms['wf08b'], // Xy[h (gv)
		'se20f' => self::$pictograms['wf08a'], // Nu (gv)
		'se210' => self::$pictograms['d123'], // V[v_C
		'se211' => self::$pictograms['d122'], // t[_C
		'se212' => self::$pictograms['d120'], // V
		'se213' => self::$pictograms['d150'], // XV
		'se214' => self::$pictograms['d093'], //  (COOL)
		'se215' => self::$pictograms['d113'], // L
		'se216' => self::$pictograms['d114'], // 
		'se217' => '[]', // z
		'se218' => '[\]', // \
		'se219' => '', // o{^1 (IW)
		'se21a' => '', // o{^2 ()
		'se21b' => '', // o{^4 ()
		'se21c' => self::$pictograms['wf0bf'], // 1 (one)
		'se21d' => self::$pictograms['wf0c0'], // 2 (two)
		'se21e' => self::$pictograms['wf0c1'], // 3 (three)
		'se21f' => self::$pictograms['wf0c2'], // 4 (four)
		'se220' => self::$pictograms['wf0c3'], // 5 (five)
		'se221' => self::$pictograms['wf0c4'], // 6 (six)
		'se222' => self::$pictograms['wf0c5'], // 7 (seven)
		'se223' => self::$pictograms['wf0c6'], // 8 (eight)
		'se224' => self::$pictograms['wf0c7'], // 9 (nine)
		'se225' => self::$pictograms['wf0be'], // 0 (zero)
		'se226' => '[]', // 
		'se227' => '[]', // 
		'se228' => '[T]', // T[rX
		'se229' => self::$pictograms['d115'], // ID
		'se22a' => self::$pictograms['d248'], // 
		'se22b' => self::$pictograms['d246'], // 
		'se22c' => '[w]', // w
		'se22d' => '[c]', // cƎ
		'se22e' => '', //  (w)
		'se22f' => '', //  (w)
		'se230' => '', //  (w)
		'se231' => '', // E (w)
		'se232' => '', // 
		'se233' => '', // 
		'se234' => '', // E
		'se235' => '', // 
		'se236' => self::$pictograms['d059'], // E
		'se237' => self::$pictograms['d090'], // 
		'se238' => self::$pictograms['d089'], // E
		'se239' => self::$pictograms['d104'], // 
		'se23a' => '', // 
		'se23b' => '', // O
		'se23c' => self::$pictograms['wf0b3'], //  
		'se23d' => self::$pictograms['wf0b2'], // ߂
		'se23e' => '[]', // 
		'se23f' => self::$pictograms['wf0c8'], // Ђ
		'se240' => self::$pictograms['wf0c9'], // 
		'se241' => self::$pictograms['wf0ca'], // ӂ
		'se242' => self::$pictograms['wf0cb'], // ɍ
		'se243' => self::$pictograms['wf0cc'], // 
		'se244' => self::$pictograms['wf0cd'], // Ƃߍ
		'se245' => self::$pictograms['wf0ce'], // Ă҂
		'se246' => self::$pictograms['wf0cf'], // 
		'se247' => self::$pictograms['wf0d1'], // č
		'se248' => self::$pictograms['wf0d2'], // €
		'se249' => self::$pictograms['wf0d3'], // ݂ߍ
		'se24a' => self::$pictograms['wf0d4'], // 
		'se24b' => self::$pictograms['wf0d0'], // ւт
		'se24c' =>  '[TOP]', // TOPy[W
		'se24d' => self::$pictograms['d135'], // OK{^
		'se24e' => self::$pictograms['wf0bb'], // 쌠 (C)
		'se24f' => self::$pictograms['wf0bc'], // o^W (R)
		'se250' => self::$pictograms['wf095'], // }i[[h
		'se251' => self::$pictograms['wf095'], // d
		'se252' => self::$pictograms['wf0b6'], //  (!)
		'se253' => self::$pictograms['d170'], // ē
		'se254' => self::$pictograms['d039'], // J-PHONEVbv
		'se255' => self::$pictograms['d012'], // XJCEFu
		'se256' => self::$pictograms['d110'], // XJCEH[J[
		'se257' => self::$pictograms['d146'] . self::$pictograms['d106'] , // XJCfB
		'se258' => 'J-', // J-PHONE 1
		'se259' => 'Pho', // J-PHONE 2
		'se25a' => 'ne', // J-PHONE 3
		'se301' => self::$pictograms['d076'], // 
		'se302' => self::$pictograms['wf07d'], // lN^C
		'se303' => self::$pictograms['d148'], // nCrXJX
		'se304' => self::$pictograms['wf059'], // `[bv
		'se305' => self::$pictograms['d148'], // Ђ܂
		'se306' => self::$pictograms['d150'], // ԑ
		'se307' => '[q̖]', // ₵̖
		'se308' => '[T{e]', // T{e
		'se309' => self::$pictograms['d049'], // gC
		'se30a' => self::$pictograms['d061'], // wbhz
		'se30b' => self::$pictograms['d264'], // ӎ (Ƃ)
		'se30c' => self::$pictograms['d053'], // t (r[)
		'se30d' => '(j)', // j
		'se30e' => self::$pictograms['wf078'], // i
		'se30f' => '[]', // JvZ
		'se310' => '[D]', // D
		'se311' => self::$pictograms['d154'], // e
		'se312' => '[NbJ[]', // NbJ[
		'se313' => self::$pictograms['wf083'], // nT~
		'se314' => self::$pictograms['d071'], // {
		'se315' => self::$pictograms['d241'], // }
		'se316' => '[MD]', // MD
		'se317' => '[Kz]', // KtH
		'se318' => self::$pictograms['d063'], // Xq
		'se319' => '[hX]', // s[X
		'se31a' => self::$pictograms['d055'], // ~[
		'se31b' => '[u[c]', // Ou[c
		'se31c' => self::$pictograms['d205'], // g
		'se31d' => '[}jLA]', // }jLA
		'se31e' => '[GXe]', // GXe
		'se31f' => self::$pictograms['d056'], // e@
		'se320' => self::$pictograms['d056'], // X
		'se321' => '[]', // 
		'se322' => self::$pictograms['wf082'], // rLj
		'se323' => self::$pictograms['wf07b'], // uhobO
		'se324' => self::$pictograms['d167'], // J`R
		'se325' => self::$pictograms['d208'], // 
		'se326' => self::$pictograms['d155'], // x鉹
		'se327' => self::$pictograms['d137'], // ҂҂n[g
		'se328' => self::$pictograms['d137'], // hLhLn[g
		'se329' => self::$pictograms['wf0a6'], // n[g˂Ƃ߂
		'se32a' => self::$pictograms['wf040'], // n[g ()
		'se32b' => self::$pictograms['wf040'], // n[g ()
		'se32c' => self::$pictograms['wf040'], // n[g ()
		'se32d' => self::$pictograms['wf040'], // n[g ()
		'se32e' => self::$pictograms['d150'], // NEW (҂҂)
		'se32f' => self::$pictograms['wf096'], // 
		'se330' => self::$pictograms['d164'], // _bV
		'se331' => self::$pictograms['d162'], // юU銾
		'se332' => self::$pictograms['d099'], // 
		'se333' => self::$pictograms['wf0ba'], // ~
		'se334' => self::$pictograms['wf074'], // {
		'se335' => self::$pictograms['wf096'], //  (_)
		'se336' => self::$pictograms['wf0a1'], //  "?"
		'se337' => self::$pictograms['d158'], //  "!"
		'se338' => self::$pictograms['d219'], // 
		'se339' => self::$pictograms['d266'], // p
		'se33a' => '[\tgN[]', // \tgN[
		'se33b' => '[|eg]', // tCh|eg
		'se33c' => '[cq]', // cq 
		'se33d' => '[]', // ׂ
		'se33e' => self::$pictograms['d265'], // 
		'se33f' => '[XpQeB]', // XpQeB
		'se340' => self::$pictograms['wf072'], // [
		'se341' => '[J[]', // J[CX
		'se342' => self::$pictograms['wf07a'], // ɂ
		'se343' => '[ł]', // ł
		'se344' => '[i]', // i
		'se345' => self::$pictograms['wf08f'], // 
		'se346' => '[]', // ݂
		'se347' => '[]', // 
		'se348' => self::$pictograms['wf080'], // 
		'se349' => '[g}g]', // g}g
		'se34a' => '[֎q]', // Ȃ
		'se34b' => self::$pictograms['wf08e'], // o[Xf[P[L
		'se34c' => '[w]', // w
		'se34d' => '[]', // ix
		'se401' => self::$pictograms['d224'], //  ()
		'se402' => self::$pictograms['d233'], // قł ()
		'se403' => self::$pictograms['d221'], // Ђ炲߂Ȃ ()
		'se404' => self::$pictograms['d272'], // ւ ()
		'se405' => self::$pictograms['d230'], // EBN ()
		'se406' => self::$pictograms['d232'], // 킳т ()
		'se407' => self::$pictograms['d143'], // ڂ邮 ()
		'se408' => self::$pictograms['d157'], // @傤 ()
		'se409' => self::$pictograms['d229'], // ׁ[ ()
		'se40a' => self::$pictograms['d222'], //  ()
		'se40b' => self::$pictograms['d276'], // QQ ()
		'se40c' => self::$pictograms['wf06a'], // }XN
		'se40d' => self::$pictograms['d231'], // 炪Ȃ
		'se40e' => self::$pictograms['d226'], // 炯
		'se40f' => self::$pictograms['d224'], // ⊾ ()
		'se410' => self::$pictograms['d144'], // т ()
		'se411' => self::$pictograms['d234'], //  ()
		'se412' => self::$pictograms['d234'], // ΂ ()
		'se413' => self::$pictograms['d235'], // Ăl
		'se414' => self::$pictograms['d140'], // ɂɂ ()
		'se415' => self::$pictograms['d231'], // ͂͂Ə΂ ()
		'se416' => self::$pictograms['d225'], // ߂߂{Ă ()
		'se417' => self::$pictograms['d227'], // KISS:
		'se418' => self::$pictograms['d227'], // KISS
		'se419' => self::$pictograms['d084'], // 
		'se41a' => '[@]', // @
		'se41b' => self::$pictograms['d085'], // 
		'se41c' => self::$pictograms['d149'], // 
		'se41d' => '[S]', // ߂Ȃ (킹)
		'se41e' => self::$pictograms['wf087'], // oCoC (U)
		'se41f' => self::$pictograms['wf087'] . self::$pictograms['wf087'],// 
		'se420' => self::$pictograms['d135'], // OK (wŊۃTC)
		'se421' => self::$pictograms['d156'], // Booing (ew)
		'se422' => self::$pictograms['wf087'], // ́`
		'se423' => self::$pictograms['d236'], // ~ (rNX)
		'se424' => self::$pictograms['d135'], //  (r𓪂)
		'se425' => self::$pictograms['d137'], // Ȃł
		'se426' => 'm(__)m', // y
		'se427' => '_(^o^)^', // oUC
		'se428' => self::$pictograms['d170'] . self::$pictograms['d170'], // lƐlĂ
		'se429' => '[oj[]', // C_X (oj[K[)
		'se42a' => self::$pictograms['d027'], // oXPbg{[
		'se42b' => '[Atg]', // tbg{[
		'se42c' => '[r[h]', // r[h
		'se42d' => self::$pictograms['d252'], // j
		'se42e' => self::$pictograms['d034'], // RV
		'se42f' => '[gbN]', // gbN
		'se430' => '[h]', // h
		'se431' => '[~}]', // ~}
		'se432' => '[pgJ[]', // pgJ[
		'se433' => '[[[R[X^[]',// WFbgR[X^[
		'se434' => self::$pictograms['d031'], // nS
		'se435' => self::$pictograms['d032'], // V(700n)
		'se436' => '[叼]', // 叼
		'se437' => '[`R]', // `R
		'se438' => '[l]', // l
		'se439' => '[Ǝ]', // Ǝ
		'se43a' => '[hZ]', // hZ
		'se43b' => '[̂ڂ]', // ̂ڂ
		'se43c' => self::$pictograms['d008'], // Ƃ
		'se43d' => '[]', // 
		'se43e' => self::$pictograms['d252'], // gU[
		'se43f' => self::$pictograms['wf081'], // X
		'se440' => '[ԉ]', // ԉ
		'se441' => '[L]', // L
		'se442' => '[]', // 
		'se443' => self::$pictograms['wf0a8'], // 䕗
		'se444' => '[]', // 
		'se445' => '[nEB]', // nEB
		'se446' => self::$pictograms['d099'], // 
		'se447' => self::$pictograms['d260'], // r[
		'se448' => '[T^]', // T^N[X
		'se449' => self::$pictograms['wf048'], // 
		'se44a' => self::$pictograms['wf048'], // [
		'se44b' => self::$pictograms['d172'], // ꐯ
		'se44c' => '[]', // 
		'se501' => self::$pictograms['d044'] . self::$pictograms['d136'], // uze
		'se502' => self::$pictograms['d062'], // A[g
		'se503' => self::$pictograms['d063'], // 
		'se504' => self::$pictograms['d039'], // fp[g
		'se505' => '[Vt]', //  (a)
		'se506' => '[]', //  (m)
		'se507' => self::$pictograms['wf09d'], // f
		'se508' => self::$pictograms['d039'], // H
		'se509' => '[^[]', // ^[ 
		'se50a' => self::$pictograms['d039'], // 109 
		'se50b' => '[{]', // { 
		'se50c' => '[AJ]', // AJ 
		'se50d' => '[tX]', // tX 
		'se50e' => '[hCc]', // hCc 
		'se50f' => '[C^A]', // C^A 
		'se510' => '[CMX]', // CMX 
		'se511' => '[XyC]', // XyC 
		'se512' => '[VA]', // VA 
		'se513' => '[]', //  
		'se514' => '[؍]', // ؍ 
		'se515' => '[l]', // l 
		'se516' => '[l]', // l 
		'se517' => '[Chl]', // Chl 
		'se518' => '[]', // 
		'se519' => '[΂]', // ΂
		'se51a' => '[Ԃ]', // 
		'se51b' => '[Hl]', // S
		'se51c' => '[Pl]', // P
		'se51d' => '[Ȑ_]', // Ȑ_
		'se51e' => '[q]', // q
		'se51f' => '[tR]', // tR
		'se520' => self::$pictograms['d270'], // CJ
		'se521' => self::$pictograms['d268'], // Ƃ
		'se522' => self::$pictograms['d270'], // Mы
		'se523' => self::$pictograms['d268'], // Ђ悱
		'se524' => '[nX^[]', // nX^[
		'se525' => '[ђ]', // ނ
		'se526' => self::$pictograms['wf070'], // 
		'se527' => '[RA]', // RA
		'se528' => self::$pictograms['wf06f'], // `pW[
		'se529' => '[r]', // Ђ
		'se52a' => self::$pictograms['wf06d'], // 
		'se52b' => '[]', // 
		'se52c' => '[e]', // 
		'se52d' => '[]', // ւ
		'se52e' => self::$pictograms['d268'], // ɂƂ
		'se52f' => '[]', // ̂
		'se530' => '[N_]', // 炭
		'se531' => self::$pictograms['wf086'], // 
		'se532' => '[A^]', // A^
		'se533' => '[B^]', // B^
		'se534' => '[AB^]', // AB^
		'se535' => '[O^]', // O^
		'se536' => self::$pictograms['wf09a'], // 
		'se537' => self::$pictograms['d239'], // TM (W)
		'se538' => 'J-', 
		'se539' => 'Sky', 
		'se53a' => 'g', 
		'se53b' => 'h', 
		'se53c' => 'V', 
		'se53d' => 'odaf', 
		'se53e' => 'one', 
		'e253'  => '[w]', // lw
		'e254'  => self::$pictograms['d049'], // Jbv
		'e255'  => self::$pictograms['wf0b1'], // t}[N
		'e256'  => '[M^[]', // M^[
		'e257'  => '[]', // `[g
		'e258'  => self::$pictograms['wf0b5'], // 18Έȏ֎~
		'e259'  => '[]', // v
		'e260'  => '[R~jeB]', // R~jeB
		'e261'  => '[HIT]', // qbg
		'e262'  => self::$pictograms['d076'], // V
		'e263'  => '[T^]', // T^N[X
		'e264'  => '[Ƒ]', // Ƒ
		'e265'  => '@', // [gp]
		'e266'  => '', // RC
		'e267'  => '@', // [gp]
		'e268'  => '@', // [gp]
		'e269'  => 'EM', // EMOBILE S (n)
		'e270'  => 'EM', // EMOBILE S (Ԓn)
		'e271'  => '@', // [gp]
		'e272'  => '@', // [gp]
		'e273'  => '@', // [gp]
		'e274'  => '@', // [gp]
		'e275'  => '@', // [gp]
		'e276'  => '@', // [gp]
		'e277'  => '@', // [gp]
		'e278'  => '@', // [gp]
	);
	$translated = apply_filters('ktai_pictogram_table', $translated, __CLASS__, $this->charset);
	$translated = apply_filters('pictogram_table/ktai_style.php', $translated);
	$buffer = preg_replace(
		'!<img localsrc="([^"]+)"( alt="(' . KtaiStyle::DOUBLE_QUOTED_STRING_REGEX . ')")?[^/>]*/?>!se', // <?php /* syntax hilighting fix */
		'isset($translated["$1"]) ? $translated["$1"] : ("$3" ? "$3" : "")', 
		$buffer);
	$entities = array(
		'&spades;' => self::$pictograms['wf08b'],
		'&#9824;'  => self::$pictograms['wf08b'],
		'&#x2660;' => self::$pictograms['wf08b'],
		'&clubs;'  => self::$pictograms['wf08a'],
		'&#9827;'  => self::$pictograms['wf08a'],
		'&#x2663;' => self::$pictograms['wf08a'],
		'&hearts;' => self::$pictograms['wf040'],
		'&#9829;'  => self::$pictograms['wf040'],
		'&#x2665;' => self::$pictograms['wf040'],
		'&#9825;'  => self::$pictograms['wf040'], // WHITE HEART
		'&#x2661;' => self::$pictograms['wf040'], // WHITE HEART
		'&diams;'  => self::$pictograms['wf089'],
		'&#9830;'  => self::$pictograms['wf089'],
		'&#x2666;' => self::$pictograms['wf089'],
		'&#12336;' => self::$pictograms['d165'], // WAVY DASH
		'&#x3030;' => self::$pictograms['d165'], // WAVY DASH
	);
	$buffer = str_replace(array_keys($entities), $entities, $buffer);
	return parent::convert_pict($buffer);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function pickup_pics($buffer) {
	$pictograms = array_flip(self::$pictograms);
	if (! $pictograms || ! function_exists('mb_regex_encoding')) {
		return $buffer;
	}
	mb_regex_encoding($this->charset);
	$replaced = mb_ereg_replace(
		"([\xf0\x40-\xf0\x5b]|[\xf0\x5d-\xf0\xfc]|[\xf1\x40-\xf1\x5b]|[\xf1\x5d-\xf1\xfc]|[\xf8\x40-\xf8\x5b]|[\xf8\x5d-\xf8\xfc]|[\xf9\x40-\xf9\x5b]|[\xf9\x5d-\xf9\xfc])", 
		'isset($pictograms["\1"]) ? 
		"<img localsrc=\"" . $pictograms["\1"] . "\" />" : 
		"<img localsrc=\"w\" alt=\"" . "[0x" . bin2hex("\1") . "]\" />"', 
		$buffer, 'e');
	if ($replaced) {
		$replaced = mb_ereg_replace("\xf0\x5c", '<img localsrc="' . $pictograms["\xf0\x5c"] . '" />', $replaced);
		$replaced = mb_ereg_replace("\xf1\x5c", '<img localsrc="' . $pictograms["\xf1\x5c"] . '" />', $replaced);
		$replaced = mb_ereg_replace("\xf8\x5c", '<img localsrc="d" alt="[0xf85c]" />', $replaced);
		$replaced = mb_ereg_replace("\xf9\x5c", '<img localsrc="' . $pictograms["\xf9\x5c"] . '" />', $replaced);
	}
	return $replaced ? $replaced : $buffer;
}

// ===== End of class ====================
}
?>