<?php
	header( "HTTP/1.1 301 Moved Permanently" ); 
	header( "Location: http://kokousa.jp/hayfes2013/" ); 
?>
<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="main">
 *
 * @package WordPress
 * @subpackage Twenty_Ten
 * @since Twenty Ten 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<title><?php
	/*
	 * Print the <title> tag based on what is being viewed.
	 */
	global $page, $paged;

	wp_title( '|', true, 'right' );

	// Add the blog name.
	bloginfo( 'name' );

	// Add the blog description for the home/front page.
	$site_description = get_bloginfo( 'description', 'display' );
	if ( $site_description && ( is_home() || is_front_page() ) )
		echo " | $site_description";

	// Add a page number if necessary:
	if ( $paged >= 2 || $page >= 2 )
		echo ' | ' . sprintf( __( 'Page %s', 'twentyten' ), max( $paged, $page ) );

	?></title>
<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="stylesheet" type="text/css" media="all" href="<?php bloginfo( 'stylesheet_url' ); ?>" />
<link rel="stylesheet" href="<?php bloginfo('template_url'); ?>/hayhay.css" />
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
<?php
	/* We add some JavaScript to pages with the comment form
	 * to support sites with threaded comments (when in use).
	 */
	if ( is_singular() && get_option( 'thread_comments' ) )
		wp_enqueue_script( 'comment-reply' );

	/* Always have wp_head() just before the closing </head>
	 * tag of your theme, or you will break many plugins, which
	 * generally use this hook to add elements to <head> such
	 * as styles, scripts, and meta tags.
	 */
	wp_head();
?>
</head>

<body <?php body_class(); ?>>
<div id="header">
	<div id="masthead">
		<div id="branding" role="banner">
			<?php $heading_tag = ( is_home() || is_front_page() ) ? 'h1' : 'div'; ?>
			<<?php echo $heading_tag; ?> id="site-title">
				<span>
					<a href="<?php echo home_url( '/' ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a>
				</span>
			</<?php echo $heading_tag; ?>>
			<div id="site-description"><?php bloginfo( 'description' ); ?></div>
		</div><!-- #branding -->

		<div id="access" role="navigation">
			<div class="skip-link screen-reader-text"><a href="#content" title="<?php esc_attr_e( 'Skip to content', 'twentyten' ); ?>"><?php _e( 'Skip to content', 'twentyten' ); ?></a></div>
			<div class="nvInner">


			<div class="menu">
			<ul>
				<li class="current_page_item"><a title="ホーム" href="<?php echo home_url( '/' ); ?>">ホーム</a></li>
				<li class="page_item"><a href="http://kokousa.jp/hayhay/2012/?page_id=73">ヘイフェスとは</a></li>
				<li class="page_item"><a href="http://kokousa.jp/hayhay/2012/?page_id=21">チケット情報</a></li>
				<!--<li class="page_item"><a href="http://kokousa.jp/hayhay/2012/?page_id=23">タイムテーブル</a></li>-->
				<li class="page_item"><a href="http://kokousa.jp/hayhay/2012/?page_id=2">アクセス</a></li>
				<li class="page_item page-item-23"><a href="http://kokousa.jp/hayhay/2012/?page_id=14">注意事項</a></li>
				<!--<li class="page_item page-item-21"><a href="http://kokousa.jp/hayhay/2012/?page_id=19">Q＆A</a></li>-->
				<li class="page_item page-item-59"><a href="http://kokousa.jp/hayhay/2012/?page_id=40">お問い合わせ</a></li>
			</ul>
			</div>


			</div>
		</div><!-- #access -->
	</div><!-- #masthead -->
</div><!-- #header -->

<div id="wrapper" class="hfeed">
	<div id="main">
