<?php
/**
 * The Sidebar containing the primary and secondary widget areas.
 *
 * @package WordPress
 * @subpackage Twenty_Ten
 * @since Twenty Ten 1.0
 */
?>

		<div id="primary" class="widget-area" role="complementary">


<?php
	/* When we call the dynamic_sidebar() function, it'll spit out
	 * the widgets for that widget area. If it instead returns false,
	 * then the sidebar simply doesn't exist, so we'll hard-code in
	 * some default sidebar stuff just in case.
	 */
	if ( ! dynamic_sidebar( 'primary-widget-area' ) ) : ?>
		<ul>
			<li id="search" class="widget-container widget_search">
				<?php get_search_form(); ?>
			</li>
		</ul>
		<ul>
			<li id="archives" class="widget-container">
				<h3 class="widget-title"><?php _e( 'Archives', 'twentyten' ); ?></h3>
				<ul>
					<?php wp_get_archives( 'type=monthly' ); ?>
				</ul>
			</li>
		</ul>
		<ul>
			<li id="meta" class="widget-container">
				<h3 class="widget-title"><?php _e( 'Meta', 'twentyten' ); ?></h3>
				<ul>
					<?php wp_register(); ?>
					<li><?php wp_loginout(); ?></li>
					<?php wp_meta(); ?>
				</ul>
			</li>
		</ul>
		<?php endif; // end primary widget area ?>
		
		
		<h3 id="hayfesGo">ヘイフェスへ行こう</h3>
		<ul class="secondaryList">
			<li><a href="http://kokousa.jp/hayhay/2012/?page_id=21">チケット情報</a></li>
			<!--<li><a href="http://kokousa.jp/hayhay/2012/?page_id=23">タイムテーブル</a></li>-->
			<li><a href="http://kokousa.jp/hayhay/2012/?page_id=86">会場図</a></li>
			<li><a href="http://kokousa.jp/hayhay/2012/?page_id=2">会場へのアクセス</a></li>
			<li><a href="http://kokousa.jp/hayhay/2012/?page_id=59">周辺観光地情報</a></li>
		</ul>
		
		<h3 id="info">インフォメーション</h3>
		<ul class="secondaryList">
			<li><a href="http://kokousa.jp/hayhay/2012/?page_id=14">注意事項</a></li>
			<li><a href="http://kokousa.jp/hayhay/2012/?page_id=61">お荷物発送受付</a></li>
			<!--<li><a href="http://kokousa.jp/hayhay/2012/?page_id=19">Q&A</a></li>-->
			<li><a href="http://kokousa.jp/hayhay/2012/?page_id=40">お問い合わせ</a></li>
		</ul>
		
		
		<div class="subBox">
			<h3 id="accessTitle">ACCESS</h3>
			<div align="center"><img src="<?php bloginfo('template_url')?>/images/accessMap.gif" alt="イベント会場アクセスマップ" /></div>
			<p class="adressArea">
			〒650-0041<br />
			兵庫県神戸市中央区新港町4−5<br />
			TEL:078-391-7638
			</p>
			<p class="more"><a href="http://kokousa.jp/hayhay/2012/?page_id=2"><img src="<?php bloginfo('template_url')?>/images/toDetile.gif" alt="詳細を見る" /></a></p>
		</div><!--.subBox-->
		
		
		<div class="subBox">
			<h3 id="linkTitle">LINK</h3>
			<div align="center"><a href="http://kokousa.jp/hayhay/2012/?page_id=97"><img src="<?php bloginfo('template_url')?>/images/link.jpg" alt="リンクを貼ってヘイフェスを応援しよう！" /></a></div>
			<p class="adressArea">
			ブログやホームページにリンクを<br />貼ってヘイフェスを応援しよう！
			</p>
			<p class="more"><a href="http://kokousa.jp/hayhay/2012/?page_id=97"><img src="<?php bloginfo('template_url')?>/images/toDetile.gif" alt="詳細を見る" /></a></p>
		</div><!--.subBox-->
		
		
		<h3 id="sponsoredByTitle">主催</h3>
		<div><a href="http://www.kokousa.com/" target="_blank"><img src="<?php bloginfo('template_url')?>/images/kokorobr.jpg" alt="ココロのおうち" /></a></div>
		<div><a href="http://www.usaboku.com/" target="_blank"><img src="<?php bloginfo('template_url')?>/images/usabokubr.jpg" alt="うさぎの牧草.com" /></a></div>

		</div><!-- #primary .widget-area -->

<?php
	// A second sidebar for widgets, just because.
	if ( is_active_sidebar( 'secondary-widget-area' ) ) : ?>

		<div id="secondary" class="widget-area" role="complementary">
			<ul class="xoxo">
				<?php dynamic_sidebar( 'secondary-widget-area' ); ?>
			</ul>
		</div><!-- #secondary .widget-area -->

<?php endif; ?>
