<?php
/* ͕h~̂߂̓{ꕶłB
   ̃\[Xt@C Shift_JIS ŕۑĂ܂B
   Above is a Japanese strings to avoid charset mis-understanding.
   This source file is saved with Shift_JIS.

   ***** DO NOT EDIT THIS FILE WITH WORDPRESS ADMIN PANEL *****
*/

/* ==================================================
 *   KtaiService_Softbank class
   ================================================== */

class KtaiService_Softbank extends KtaiServices {
	static public $networks;
	static public $pict_sjis;
	static public $pictograms;

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	parent::__construct($user_agent);
	$this->operator = 'SoftBank';
	$this->image_pictograms = false;
	$this->use_redir = true;
	$this->show_plugin_icon = false;
	$this->pcview_enabled = false;
	$this->charset = 'SJIS-win';
	$this->mime_type = 'text/html';
	// http://creation.mb.softbank.jp/web/web_pic_about.html
	$this->num_chars = array('G' => 90, 'E' => 90, 'F' => 90, 'O' => 77, 'P' => 76, 'Q' => 62);

	// https://creation.mb.softbank.jp/web/web_ip.html
	// Last Update: 2011-02-10
	$this->networks = array(
		'123.108.237.0/27', 
		'202.253.96.224/27', 
		'210.146.7.192/26', 
/*
		'123.108.236.0/24', // Deleted
		'202.179.204.0/24', // Deleted
		'210.151.9.128/26', // Deleted
		'210.169.130.112/28', // Deleted
		'210.228.189.0/24', // Deleted
		'211.8.159.128/25', // Deleted
		'210.146.60.192/26', // Deleted
		'210.175.1.128/25', // Deleted
 */
 	);
	self::$pictograms = array(); // unset
	// http://creation.mb.softbank.jp/download.php?docid=103 (members only)
	self::$pict_sjis = array(
		'se001' => "\xf9\x41", // j̎q
		'se002' => "\xf9\x42", // ̎q
		'se003' => "\xf9\x43", // e (LX}[N)
		'se004' => "\xf9\x44", // 
		'se005' => "\xf9\x45", // ꂳ
		'se006' => "\xf9\x46", // m
		'se007' => "\xf9\x47", // u[c
		'se008' => "\xf9\x48", // J
		'se009' => "\xf9\x49", // db
		'se00a' => "\xf9\x4a", // gѓdb
		'se00b' => "\xf9\x4b", // FAX
		'se00c' => "\xf9\x4c", // p\R
		'se00d' => "\xf9\x4d", // p`
		'se00e' => "\xf9\x4e", // GOOD!
		'se00f' => "\xf9\x4f", // No.1!
		'se010' => "\xf9\x50", // O[
		'se011' => "\xf9\x51", // `L
		'se012' => "\xf9\x52", // p[
		'se013' => "\xf9\x53", // XL[
		'se014' => "\xf9\x54", // St
		'se015' => "\xf9\x55", // ejX
		'se016' => "\xf9\x56", // 싅
		'se017' => "\xf9\x57", // T[tB
		'se018' => "\xf9\x58", // TbJ[
		'se019' => "\xf9\x59", // 
		'se01a' => "\xf9\x5a", // 
		'se01b' => "\xf9\x5b", // 
		'se01c' => "\xf9\x5c", // bg
		'se01d' => "\xf9\x5d", // s@
		'se01e' => "\xf9\x5e", // d
		'se01f' => "\xf9\x5f", // V
		'se020' => "\xf9\x60", // nei
		'se021' => "\xf9\x61", // rbN
		'se022' => "\xf9\x62", // n[g}[N
		'se023' => "\xf9\x63", // n[guCN
		'se024' => "\xf9\x64", // 1
		'se025' => "\xf9\x65", // 2
		'se026' => "\xf9\x66", // v
		'se027' => "\xf9\x67", // 4
		'se028' => "\xf9\x68", // 5
		'se029' => "\xf9\x69", // 6
		'se02a' => "\xf9\x6a", // 7
		'se02b' => "\xf9\x6b", // 8
		'se02c' => "\xf9\x6c", // 9
		'se02d' => "\xf9\x6d", // 10
		'se02e' => "\xf9\x6e", // 11
		'se02f' => "\xf9\x6f", // 12
		'se030' => "\xf9\x70", // Ԍ
		'se031' => "\xf9\x71", // Gu
		'se032' => "\xf9\x72", // o
		'se033' => "\xf9\x73", // NX}X
		'se034' => "\xf9\x74", // w
		'se035' => "\xf9\x75", // 
		'se036' => "\xf9\x76", // 
		'se037' => "\xf9\x77", // 
		'se038' => "\xf9\x78", // r
		'se039' => "\xf9\x79", // w
		'se03a' => "\xf9\x7a", // K\X^h
		'se03b' => "\xf9\x7b", // R
		'se03c' => "\xf9\x7c", // }CN
		'se03d' => "\xf9\x7d", // f
		'se03e' => "\xf9\x7e", // y ()
		'se03f' => "\xf9\x80", // JM
		'se040' => "\xf9\x81", // TbNX
		'se041' => "\xf9\x82", // M^[
		'se042' => "\xf9\x83", // gybg
		'se043' => "\xf9\x84", // Xg
		'se044' => "\xf9\x85", // JNe
		'se045' => "\xf9\x86", // R[q[
		'se046' => "\xf9\x87", // P[L
		'se047' => "\xf9\x88", // r[
		'se048' => "\xf9\x89", // 
		'se049' => "\xf9\x8a", // ܂
		'se04a' => "\xf9\x8b", //  ()
		'se04b' => "\xf9\x8c", // J
		'se04c' => "\xf9\x8d", //  ()
		'se04d' => "\xf9\x8e", // 
		'se04e' => "\xf9\x8f", // Vg
		'se04f' => "\xf9\x90", // ˂
		'se050' => "\xf9\x91", // Ƃ
		'se051' => "\xf9\x92", // 
		'se052' => "\xf9\x93", // 
		'se053' => "\xf9\x94", // ˂
		'se054' => "\xf9\x95", // NW
		'se055' => "\xf9\x96", // yM
		'se056' => "\xf9\x97", // y ()
		'se057' => "\xf9\x98", //  ()
		'se058' => "\xf9\x99", //  ()
		'se059' => "\xf9\x9a", // { ()
		'se05a' => "\xf9\x9b", // E`
		'se101' => "\xf7\x41", // [M
		'se102' => "\xf7\x42", // [M
		'se103' => "\xf7\x43", // [
		'se104' => "\xf7\x44", // dbA
		'se105' => "\xf7\x45", // AJx[ ()
		'se106' => "\xf7\x46", // uu ()
		'se107' => "\xf7\x47", // Kr[ ()
		'se108' => "\xf7\x48", // ^[ ()
		'se109' => "\xf7\x49", // 
		'se10a' => "\xf7\x4a", // ^R
		'se10b' => "\xf7\x4b", // Ԃ
		'se10c' => "\xf7\x4c", // Fl
		'se10d' => "\xf7\x4d", // Pbg
		'se10e' => "\xf7\x4e", // 
		'se10f' => "\xf7\x4f", // d
		'se110' => "\xf7\x50", // 
		'se111' => "\xf7\x51", // LX
		'se112' => "\xf7\x52", // o[Xf[ (v[g)
		'se113' => "\xf7\x53", // sXg
		'se114' => "\xf7\x54", // ዾ
		'se115' => "\xf7\x55", // 
		'se116' => "\xf7\x56", // I[NV
		'se117' => "\xf7\x57", // ԉ
		'se118' => "\xf7\x58", // ݂
		'se119' => "\xf7\x59", // t
		'se11a' => "\xf7\x5a", // 
		'se11b' => "\xf7\x5b", // ΂
		'se11c' => "\xf7\x5c", // hN
		'se11d' => "\xf7\x5d", // t@C[
		'se11e' => "\xf7\x5e", // ΂
		'se11f' => "\xf7\x5f", // 
		'se120' => "\xf7\x60", // no[K[
		'se121' => "\xf7\x61", // 
		'se122' => "\xf7\x62", // Lv
		'se123' => "\xf7\x63", // 
		'se124' => "\xf7\x64", // Vn
		'se125' => "\xf7\x65", // `Pbg
		'se126' => "\xf7\x66", // CD
		'se127' => "\xf7\x67", // DVD
		'se128' => "\xf7\x68", // WI
		'se129' => "\xf7\x69", // rfI
		'se12a' => "\xf7\x6a", // er
		'se12b' => "\xf7\x6b", // Q[
		'se12c' => "\xf7\x6c", // ̂o
		'se12d' => "\xf7\x6d", // }[W
		'se12e' => "\xf7\x6e", // Ό
		'se12f' => "\xf7\x6f", // ܋ (h)
		'se130' => "\xf7\x70", // 
		'se131' => "\xf7\x71", // gtB[
		'se132' => "\xf7\x72", // S[ (`FbJ[tbO)
		'se133' => "\xf7\x73", // Xbg (777)
		'se134' => "\xf7\x74", // n
		'se135' => "\xf7\x75", // 
		'se136' => "\xf7\x76", // 
		'se137' => "\xf7\x77", // H
		'se138' => "\xf7\x78", // j
		'se139' => "\xf7\x79", // 
		'se13a' => "\xf7\x7a", // c
		'se13b' => "\xf7\x7b", // ˊ
		'se13c' => "\xf7\x7c", //  (Zzz)
		'se13d' => "\xf7\x7d", // 
		'se13e' => "\xf7\x7e", // nCq[
		'se13f' => "\xf7\x80", // 
		'se140' => "\xf7\x81", // gC
		'se141' => "\xf7\x82", // 
		'se142' => "\xf7\x83", // m点 (Kz)
		'se143' => "\xf7\x84", // j
		'se144' => "\xf7\x85", // bNON
		'se145' => "\xf7\x86", // bNOFF
		'se146' => "\xf7\x87", // X
		'se147' => "\xf7\x88", //  ()
		'se148' => "\xf7\x89", // {
		'se149' => "\xf7\x8a", // ב֑
		'se14a' => "\xf7\x8b", // 
		'se14b' => "\xf7\x8c", // j[X (p{Aei)
		'se14c' => "\xf7\x8d", // C (͂)
		'se14d' => "\xf7\x8e", // s
		'se14e' => "\xf7\x8f", // M
		'se14f' => "\xf7\x90", // ԏ
		'se150' => "\xf7\x91", // oX
		'se151' => "\xf7\x92", // OgC
		'se152' => "\xf7\x93", // 
		'se153' => "\xf7\x94", // X֋
		'se154' => "\xf7\x95", // ATM
		'se155' => "\xf7\x96", // a@
		'se156' => "\xf7\x97", // Rrj
		'se157' => "\xf7\x98", // wZ
		'se158' => "\xf7\x99", // ze
		'se159' => "\xf7\x9a", // oX
		'se15a' => "\xf7\x9b", // ^NV[
		'se201' => "\xf7\xa1", // k
		'se202' => "\xf7\xa2", // D
		'se203' => "\xf7\xa3", // ړIn (RR)
		'se204' => "\xf7\xa4", // r1
		'se205' => "\xf7\xa5", // r2
		'se206' => "\xf7\xa6", // r3
		'se207' => "\xf7\xa7", // 18
		'se208' => "\xf7\xa8", // ։
		'se209' => "\xf7\xa9", // S
		'se20a' => "\xf7\xaa", // oAt[ (Ԉ֎q}[N)
		'se20b' => "\xf7\xab", // Aei}[N
		'se20c' => "\xf7\xac", // n[g (gv)
		'se20d' => "\xf7\xad", // _C (gv)
		'se20e' => "\xf7\xae", // Xy[h (gv)
		'se20f' => "\xf7\xaf", // Nu (gv)
		'se210' => "\xf7\xb0", // V[v_C
		'se211' => "\xf7\xb1", // t[_C
		'se212' => "\xf7\xb2", // V
		'se213' => "\xf7\xb3", // XV
		'se214' => "\xf7\xb4", //  (COOL)
		'se215' => "\xf7\xb5", // L
		'se216' => "\xf7\xb6", // 
		'se217' => "\xf7\xb7", // z
		'se218' => "\xf7\xb8", // \
		'se219' => "\xf7\xb9", // o{^1 (IW)
		'se21a' => "\xf7\xba", // o{^2 ()
		'se21b' => "\xf7\xbb", // o{^4 ()
		'se21c' => "\xf7\xbc", // 1 (one)
		'se21d' => "\xf7\xbd", // 2 (two)
		'se21e' => "\xf7\xbe", // 3 (three)
		'se21f' => "\xf7\xbf", // 4 (four)
		'se220' => "\xf7\xc0", // 5 (five)
		'se221' => "\xf7\xc1", // 6 (six)
		'se222' => "\xf7\xc2", // 7 (seven)
		'se223' => "\xf7\xc3", // 8 (eight)
		'se224' => "\xf7\xc4", // 9 (nine)
		'se225' => "\xf7\xc5", // 0 (zero)
		'se226' => "\xf7\xc6", // 
		'se227' => "\xf7\xc7", // 
		'se228' => "\xf7\xc8", // T[rX
		'se229' => "\xf7\xc9", // ID
		'se22a' => "\xf7\xca", // 
		'se22b' => "\xf7\xcb", // 
		'se22c' => "\xf7\xcc", // w
		'se22d' => "\xf7\xcd", // cƎ
		'se22e' => "\xf7\xce", //  (w)
		'se22f' => "\xf7\xcf", //  (w)
		'se230' => "\xf7\xd0", //  (w)
		'se231' => "\xf7\xd1", // E (w)
		'se232' => "\xf7\xd2", // 
		'se233' => "\xf7\xd3", // 
		'se234' => "\xf7\xd4", // E
		'se235' => "\xf7\xd5", // 
		'se236' => "\xf7\xd6", // E
		'se237' => "\xf7\xd7", // 
		'se238' => "\xf7\xd8", // E
		'se239' => "\xf7\xd9", // 
		'se23a' => "\xf7\xda", // 
		'se23b' => "\xf7\xdb", // O
		'se23c' => "\xf7\xdc", //  
		'se23d' => "\xf7\xdd", // ߂
		'se23e' => "\xf7\xde", // 
		'se23f' => "\xf7\xdf", // Ђ
		'se240' => "\xf7\xe0", // 
		'se241' => "\xf7\xe1", // ӂ
		'se242' => "\xf7\xe2", // ɍ
		'se243' => "\xf7\xe3", // 
		'se244' => "\xf7\xe4", // Ƃߍ
		'se245' => "\xf7\xe5", // Ă҂
		'se246' => "\xf7\xe6", // 
		'se247' => "\xf7\xe7", // č
		'se248' => "\xf7\xe8", // €
		'se249' => "\xf7\xe9", // ݂ߍ
		'se24a' => "\xf7\xea", // 
		'se24b' => "\xf7\xeb", // ւт
		'se24c' => "\xf7\xec", // TOPy[W
		'se24d' => "\xf7\xed", // OK{^
		'se24e' => "\xf7\xee", // 쌠 (C)
		'se24f' => "\xf7\xef", // o^W (R)
		'se250' => "\xf7\xf0", // }i[[h
		'se251' => "\xf7\xf1", // d
		'se252' => "\xf7\xf2", //  (!)
		'se253' => "\xf7\xf3", // ē
		'se254' => "\xf7\xf4", // J-PHONEVbv
		'se255' => "\xf7\xf5", // XJCEFu
		'se256' => "\xf7\xf6", // XJCEH[J[
		'se257' => "\xf7\xf7", // XJCfB
		'se258' => "\xf7\xf8", // J-PHONE 1
		'se259' => "\xf7\xf9", // J-PHONE 2
		'se25a' => "\xf7\xfa", // J-PHONE 3
		'se301' => "\xf9\xa1", // 
		'se302' => "\xf9\xa2", // lN^C
		'se303' => "\xf9\xa3", // nCrXJX
		'se304' => "\xf9\xa4", // `[bv
		'se305' => "\xf9\xa5", // Ђ܂
		'se306' => "\xf9\xa6", // ԑ
		'se307' => "\xf9\xa7", // ₵̖
		'se308' => "\xf9\xa8", // T{e
		'se309' => "\xf9\xa9", // gC
		'se30a' => "\xf9\xaa", // wbhz
		'se30b' => "\xf9\xab", // ӎ (Ƃ)
		'se30c' => "\xf9\xac", // t (r[)
		'se30d' => "\xf9\xad", // j
		'se30e' => "\xf9\xae", // i
		'se30f' => "\xf9\xaf", // JvZ
		'se310' => "\xf9\xb0", // D
		'se311' => "\xf9\xb1", // e
		'se312' => "\xf9\xb2", // NbJ[
		'se313' => "\xf9\xb3", // nT~
		'se314' => "\xf9\xb4", // {
		'se315' => "\xf9\xb5", // }
		'se316' => "\xf9\xb6", // MD
		'se317' => "\xf9\xb7", // KtH
		'se318' => "\xf9\xb8", // Xq
		'se319' => "\xf9\xb9", // s[X
		'se31a' => "\xf9\xba", // ~[
		'se31b' => "\xf9\xbb", // Ou[c
		'se31c' => "\xf9\xbc", // g
		'se31d' => "\xf9\xbd", // }jLA
		'se31e' => "\xf9\xbe", // GXe
		'se31f' => "\xf9\xbf", // e@
		'se320' => "\xf9\xc0", // X
		'se321' => "\xf9\xc1", // 
		'se322' => "\xf9\xc2", // rLj
		'se323' => "\xf9\xc3", // uhobO
		'se324' => "\xf9\xc4", // J`R
		'se325' => "\xf9\xc5", // 
		'se326' => "\xf9\xc6", // x鉹
		'se327' => "\xf9\xc7", // ҂҂n[g
		'se328' => "\xf9\xc8", // hLhLn[g
		'se329' => "\xf9\xc9", // n[g˂Ƃ߂
		'se32a' => "\xf9\xca", // n[g ()
		'se32b' => "\xf9\xcb", // n[g ()
		'se32c' => "\xf9\xcc", // n[g ()
		'se32d' => "\xf9\xcd", // n[g ()
		'se32e' => "\xf9\xce", // NEW (҂҂)
		'se32f' => "\xf9\xcf", // 
		'se330' => "\xf9\xd0", // _bV
		'se331' => "\xf9\xd1", // юU銾
		'se332' => "\xf9\xd2", // 
		'se333' => "\xf9\xd3", // ~
		'se334' => "\xf9\xd4", // {
		'se335' => "\xf9\xd5", //  (_)
		'se336' => "\xf9\xd6", //  "?"
		'se337' => "\xf9\xd7", //  "!"
		'se338' => "\xf9\xd8", // 
		'se339' => "\xf9\xd9", // p
		'se33a' => "\xf9\xda", // \tgN[
		'se33b' => "\xf9\xdb", // tCh|eg
		'se33c' => "\xf9\xdc", // cq 
		'se33d' => "\xf9\xdd", // ׂ
		'se33e' => "\xf9\xde", // 
		'se33f' => "\xf9\xdf", // XpQeB
		'se340' => "\xf9\xe0", // [
		'se341' => "\xf9\xe1", // J[CX
		'se342' => "\xf9\xe2", // ɂ
		'se343' => "\xf9\xe3", // ł
		'se344' => "\xf9\xe4", // i
		'se345' => "\xf9\xe5", // 
		'se346' => "\xf9\xe6", // ݂
		'se347' => "\xf9\xe7", // 
		'se348' => "\xf9\xe8", // 
		'se349' => "\xf9\xe9", // g}g
		'se34a' => "\xf9\xea", // Ȃ
		'se34b' => "\xf9\xeb", // o[Xf[P[L
		'se34c' => "\xf9\xec", // w
		'se34d' => "\xf9\xed", // ix
		'se401' => "\xfb\x41", //  ()
		'se402' => "\xfb\x42", // قł ()
		'se403' => "\xfb\x43", // Ђ炲߂Ȃ ()
		'se404' => "\xfb\x44", // ւ ()
		'se405' => "\xfb\x45", // EBN ()
		'se406' => "\xfb\x46", // 킳т ()
		'se407' => "\xfb\x47", // ڂ邮 ()
		'se408' => "\xfb\x48", // @傤 ()
		'se409' => "\xfb\x49", // ׁ[ ()
		'se40a' => "\xfb\x4a", //  ()
		'se40b' => "\xfb\x4b", // QQ ()
		'se40c' => "\xfb\x4c", // }XN
		'se40d' => "\xfb\x4d", // 炪Ȃ
		'se40e' => "\xfb\x4e", // 炯
		'se40f' => "\xfb\x4f", // ⊾ ()
		'se410' => "\xfb\x50", // т ()
		'se411' => "\xfb\x51", //  ()
		'se412' => "\xfb\x52", // ΂ ()
		'se413' => "\xfb\x53", // Ăl
		'se414' => "\xfb\x54", // ɂɂ ()
		'se415' => "\xfb\x55", // ͂͂Ə΂ ()
		'se416' => "\xfb\x56", // ߂߂{Ă ()
		'se417' => "\xfb\x57", // KISS:
		'se418' => "\xfb\x58", // KISS
		'se419' => "\xfb\x59", // 
		'se41a' => "\xfb\x5a", // @
		'se41b' => "\xfb\x5b", // 
		'se41c' => "\xfb\x5c", // 
		'se41d' => "\xfb\x5d", // ߂Ȃ (킹)
		'se41e' => "\xfb\x5e", // oCoC (U)
		'se41f' => "\xfb\x5f", // 
		'se420' => "\xfb\x60", // OK (wŊۃTC)
		'se421' => "\xfb\x61", // Booing (ew)
		'se422' => "\xfb\x62", // ́`
		'se423' => "\xfb\x63", // ~ (rNX)
		'se424' => "\xfb\x64", //  (r𓪂)
		'se425' => "\xfb\x65", // Ȃł
		'se426' => "\xfb\x66", // y
		'se427' => "\xfb\x67", // oUC
		'se428' => "\xfb\x68", // lƐlĂ
		'se429' => "\xfb\x69", // C_X (oj[K[)
		'se42a' => "\xfb\x6a", // oXPbg{[
		'se42b' => "\xfb\x6b", // tbg{[
		'se42c' => "\xfb\x6c", // r[h
		'se42d' => "\xfb\x6d", // j
		'se42e' => "\xfb\x6e", // RV
		'se42f' => "\xfb\x6f", // gbN
		'se430' => "\xfb\x70", // h
		'se431' => "\xfb\x71", // ~}
		'se432' => "\xfb\x72", // pgJ[
		'se433' => "\xfb\x73", // WFbgR[X^[
		'se434' => "\xfb\x74", // nS
		'se435' => "\xfb\x75", // V(700n)
		'se436' => "\xfb\x76", // 叼
		'se437' => "\xfb\x77", // `R
		'se438' => "\xfb\x78", // l
		'se439' => "\xfb\x79", // Ǝ
		'se43a' => "\xfb\x7a", // hZ
		'se43b' => "\xfb\x7b", // ̂ڂ
		'se43c' => "\xfb\x7c", // Ƃ
		'se43d' => "\xfb\x7d", // 
		'se43e' => "\xfb\x7e", // gU[
		'se43f' => "\xfb\x80", // X
		'se440' => "\xfb\x81", // ԉ
		'se441' => "\xfb\x82", // L
		'se442' => "\xfb\x83", // 
		'se443' => "\xfb\x84", // 䕗
		'se444' => "\xfb\x85", // 
		'se445' => "\xfb\x86", // nEB
		'se446' => "\xfb\x87", // 
		'se447' => "\xfb\x88", // r[
		'se448' => "\xfb\x89", // T^N[X
		'se449' => "\xfb\x8a", // 
		'se44a' => "\xfb\x8b", // [
		'se44b' => "\xfb\x8c", // ꐯ
		'se44c' => "\xfb\x8d", // 
		'se501' => "\xfb\xa1", // uze
		'se502' => "\xfb\xa2", // A[g
		'se503' => "\xfb\xa3", // 
		'se504' => "\xfb\xa4", // fp[g
		'se505' => "\xfb\xa5", //  (a)
		'se506' => "\xfb\xa6", //  (m)
		'se507' => "\xfb\xa7", // f
		'se508' => "\xfb\xa8", // H
		'se509' => "\xfb\xa9", // ^[
		'se50a' => "\xfb\xaa", // 109
		'se50b' => "\xfb\xab", // { ()
		'se50c' => "\xfb\xac", // AJ ()
		'se50d' => "\xfb\xad", // tX ()
		'se50e' => "\xfb\xae", // hCc ()
		'se50f' => "\xfb\xaf", // C^A ()
		'se510' => "\xfb\xb0", // CMX ()
		'se511' => "\xfb\xb1", // XyC ()
		'se512' => "\xfb\xb2", // VA ()
		'se513' => "\xfb\xb3", //  ()
		'se514' => "\xfb\xb4", // ؍ ()
		'se515' => "\xfb\xb5", // l
		'se516' => "\xfb\xb6", // l
		'se517' => "\xfb\xb7", // Chl
		'se518' => "\xfb\xb8", // 
		'se519' => "\xfb\xb9", // ΂
		'se51a' => "\xfb\xba", // 
		'se51b' => "\xfb\xbb", // S
		'se51c' => "\xfb\xbc", // P
		'se51d' => "\xfb\xbd", // Ȑ_
		'se51e' => "\xfb\xbe", // q
		'se51f' => "\xfb\xbf", // tR
		'se520' => "\xfb\xc0", // CJ
		'se521' => "\xfb\xc1", // Ƃ
		'se522' => "\xfb\xc2", // Mы
		'se523' => "\xfb\xc3", // Ђ悱
		'se524' => "\xfb\xc4", // nX^[
		'se525' => "\xfb\xc5", // ނ
		'se526' => "\xfb\xc6", // 
		'se527' => "\xfb\xc7", // RA
		'se528' => "\xfb\xc8", // `pW[
		'se529' => "\xfb\xc9", // Ђ
		'se52a' => "\xfb\xca", // 
		'se52b' => "\xfb\xcb", // 
		'se52c' => "\xfb\xcc", // 
		'se52d' => "\xfb\xcd", // ւ
		'se52e' => "\xfb\xce", // ɂƂ
		'se52f' => "\xfb\xcf", // ̂
		'se530' => "\xfb\xd0", // 炭
		'se531' => "\xfb\xd1", // 
		'se532' => "\xfb\xd2", // A^
		'se533' => "\xfb\xd3", // B^
		'se534' => "\xfb\xd4", // AB^
		'se535' => "\xfb\xd5", // O^
		'se536' => "\xfb\xd6", // 
		'se537' => "\xfb\xd7", // TM (W)
		'se538' => "\xfb\xd8", // J-Sky 1
		'se539' => "\xfb\xd9", // J-Sky 2
		'se53a' => "\xfb\xda", // Vodafone 1
		'se53b' => "\xfb\xdb", // Vodafone 2
		'se53c' => "\xfb\xdc", // Vodafone 3
		'se53d' => "\xfb\xdd", // Vodafone 4
		'se53e' => "\xfb\xde", // Vodafone 5
	);
	return;
}

/* ==================================================
 * @param	boolean $allow_search_engine
 * @return	boolean $in_network
 */
public function in_network($allow_search_engine = false) {
	return parent::in_network(self::$networks, $allow_search_engine);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function replace_smiley($buffer) {
	$smiles = array(
		'icon_smile.gif'     => self::$pictograms['se056'],
		'icon_biggrin.gif'   => self::$pictograms['se057'],
		'icon_sad.gif'       => self::$pictograms['se058'],
		'icon_surprised.gif' => self::$pictograms['se410'],
		'icon_eek.gif'       => self::$pictograms['se410'],
		'icon_confused.gif'  => self::$pictograms['se407'],
		'icon_cool.gif'      => self::$pictograms['se214'],
		'icon_mad.gif'       => self::$pictograms['se059'],
		'icon_razz.gif'      => self::$pictograms['se409'],
		'icon_neutral.gif'   => self::$pictograms['se402'],
		'icon_wink.gif'      => self::$pictograms['se405'],
		'icon_lol.gif'       => self::$pictograms['se409'],
		'icon_redface.gif'   => self::$pictograms['se40a'],
		'icon_cry.gif'       => self::$pictograms['se411'],
		'icon_evil.gif'      => self::$pictograms['se416'],
		'icon_twisted.gif'   => self::$pictograms['se416'],
		'icon_rolleyes.gif'  => self::$pictograms['se407'],
		'icon_exclaim.gif'   => self::$pictograms['se021'],
		'icon_question.gif'  => self::$pictograms['se020'],
		'icon_idea.gif'      => self::$pictograms['se10f'],
		'icon_arrow.gif'     => self::$pictograms['se234'],
		'icon_mrgreen.gif'   => self::$pictograms['se415'],
	);
	$smiles = apply_filters('ktai_smiley_table', $smiles, __CLASS__);
	$smiles = apply_filters('smiley_table/ktai_style.php', $smiles);
	return parent::replace_smiley($buffer, $smiles);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 *            http://www.au.kddi.com/ezfactory/tec/spec/3.html
 */
public function convert_pict($buffer) {
	// http://www.au.kddi.com/email/emoji/
	// http://mb.softbank.jp/mb/service/3G/mail/pictogram/
	// http://www.nttdocomo.co.jp/service/mail/imode_mail/emoji_convert/
	// http://www.willcom-inc.com/ja/service/e_mail/pdf/conversiontable.pdf
	$translated = self::$pictograms + array(
		'1'     => self::$pictograms['se252'], // u!v
		'2'     => self::$pictograms['se337'], // u!v
		'3'     => self::$pictograms['se336'], // u?v
		'4'     => 'Q', // uQv
		'5'     => self::$pictograms['se23b'], // Op1
		'6'     => self::$pictograms['se23a'], // EOp1
		'7'     => self::$pictograms['se23d'], // Op2
		'8'     => self::$pictograms['se23c'], // EOp2
		'9'     => '', // lp 1
		'10'    => '', // lp 2
		'11'    => '[i]', // CtH[VV{
		'12'    => self::$pictograms['se044'], // COX
		'13'    => self::$pictograms['se142'], // Xs[J[
		'14'    => self::$pictograms['se12f'], // h}[N
		'15'    => self::$pictograms['se04c'], //  1
		'16'    => self::$pictograms['se13d'], // Ȃ
		'17'    => '', // lp 1
		'18'    => '', // lp 2
		'19'    => '', // H` 1
		'20'    => '', // H` 2
		'21'    => '', // lp 1
		'22'    => '', // lp 2
		'23'    => '', // H` 1
		'24'    => '', // H` 2
		'25'    => self::$pictograms['se026'], // rv
		'26'    => '+', // vX
		'27'    => '-', // }CiX
		'28'    => self::$pictograms['se32f'], //  1
		'29'    => self::$pictograms['se232'], //  1
		'30'    => self::$pictograms['se233'], //  1
		'31'    => self::$pictograms['se137'], // ۂɎ΂ߐ
		'32'    => '', // Op 1
		'33'    => '', // Op 1
		'34'    => '', // Op 2
		'35'    => '', // Op 2
		'36'    => '', // H` 1
		'37'    => '', // H` 2
		'38'    => '', // lp 1
		'39'    => '', // lp 2
		'40'    => '', //  1
		'41'    => '', //  2
		'42'    => self::$pictograms['se237'], //  2 ()
		'43'    => self::$pictograms['se238'], //  2 (E)
		'44'    => self::$pictograms['se04a'], // z
		'45'    => self::$pictograms['se016'], // 싅{[
		'46'    => self::$pictograms['se026'], // v
		'47'    => self::$pictograms['se04c'], //  2 ()
		'48'    => self::$pictograms['se325'], // x
		'49'    => '[e]', // vbVs (e)
		'50'    => self::$pictograms['se002'], // 
		'51'    => self::$pictograms['se022'], // n[g
		'52'    => self::$pictograms['se044'], // }eB[j (JNeOX)
		'53'    => self::$pictograms['se110'], // lt
		'54'    => self::$pictograms['se537'], // g[h}[N (TM)
		'55'    => self::$pictograms['se333'], // 
		'56'    => self::$pictograms['se301'], //  1
		'57'    => '[v]', // v 1
		'58'    => '[v]', // v 2
		'59'    => self::$pictograms['se316'], // tbs[fBXN 1
		'60'    => '*', // ̌
		'61'    => self::$pictograms['se333'], // oc 1
		'62'    => self::$pictograms['se333'], // oc 2
		'63'    => self::$pictograms['se234'], // E 1
		'64'    => self::$pictograms['se235'], //  1
		'65'    => self::$pictograms['se047'], // }OJbv
		'66'    => '', // 
		'67'    => '[J_[]', // J_[
		'68'    => self::$pictograms['se056'], // X}CtFCX
		'69'    => self::$pictograms['se32f'], //  2
		'70'    => self::$pictograms['se236'], // E 2 (E)
		'71'    => self::$pictograms['se239'], //  2 ()
		'72'    => self::$pictograms['se034'], // WG[
		'73'    => '', // `FbN}[N 1
		'74'    => self::$pictograms['se052'], //  (v[h)
		'75'    => self::$pictograms['se335'], //  3
		'76'    => self::$pictograms['se32e'], // Xp[N
		'77'    => self::$pictograms['se10f'], // d
		'78'    => self::$pictograms['se521'], // 
		'79'    => '[tH_]', // tH_ 1 ()
		'80'    => self::$pictograms['se001'], //  1
		'81'    => self::$pictograms['se24e'], // Rs[Cg}[N (C)
		'82'    => self::$pictograms['se24f'], // WX^[h}[N (R)
		'83'    => self::$pictograms['se11e'], // u[tP[X (nhobN)
		'84'    => '[JtH_]', // tH_ 2 (J)
		'85'    => self::$pictograms['se009'], // db 1 (vbVz)
		'86'    => self::$pictograms['se301'], // oRg
		'87'    => '[NWbgJ[h]', // NWbgJ[h
		'88'    => '', // Op 3
		'89'    => '', // Op 3
		'90'    => self::$pictograms['se50c'], // USA ()
		'91'    => self::$pictograms['se301'], // m[g 3
		'92'    => self::$pictograms['se301'], // Nbv{[h
		'93'    => self::$pictograms['se045'], // Jbv
		'94'    => self::$pictograms['se008'], // J
		'95'    => self::$pictograms['se04b'], // J
		'96'    => self::$pictograms['se42b'], // tbg{[
		'97'    => self::$pictograms['se148'], // { 1
		'98'    => self::$pictograms['se137'], // ֎~
		'99'    => self::$pictograms['se14e'], // M
		'100'   => self::$pictograms['se148'], // { 2
		'101'   => self::$pictograms['se148'], // { 3
		'102'   => self::$pictograms['se148'], // { 4
		'103'   => self::$pictograms['se301'], //  2
		'104'   => self::$pictograms['se313'], // ͂
		'105'   => self::$pictograms['se301'], // Ђ߂J_[
		'106'   => self::$pictograms['se125'], // `PbgELbv
		'107'   => self::$pictograms['se049'], // 
		'108'   => self::$pictograms['se103'], // 
		'109'   => self::$pictograms['se12f'], // ؎ (CHECK)
		'110'   => self::$pictograms['se03d'], // rfIJ
		'111'   => self::$pictograms['se507'], // nfBJ
		'112'   => self::$pictograms['se036'], // 
		'113'   => self::$pictograms['se304'], //  (`[bv)
		'114'   => '[iCt]', // iCt
		'115'   => self::$pictograms['se129'], // rfIe[v
		'116'   => self::$pictograms['se214'], // ߂
		'117'   => '', //  1
		'118'   => '', //  2
		'119'   => self::$pictograms['se114'], // ނ߂
		'120'   => self::$pictograms['se03f'], // 
		'121'   => self::$pictograms['se301'], // m[g 1
		'122'   => self::$pictograms['se301'], // m[g 2 (J)
		'123'   => '[{gƃibg]', // {g & ibg
		'124'   => self::$pictograms['se13e'], //  (nCq[)
		'125'   => self::$pictograms['se15a'], // 
		'126'   => self::$pictograms['se316'], // tbs[ 2
		'127'   => '[_Ot]', // `[g (_Ot)
		'128'   => self::$pictograms['se14a'], // Ot 1 (܂Ot)
		'129'   => self::$pictograms['se101'], // [{bNX
		'130'   => '[d]', // d
		'131'   => '[Roldex]', // Roldex
		'132'   => '', // `FbN}[N 2
		'133'   => self::$pictograms['se118'], // ͂
		'134'   => self::$pictograms['se052'], // 
		'135'   => '[dr]', // dr
		'136'   => '[XN[]', // XN[
		'137'   => '[e]', // т傤
		'138'   => self::$pictograms['se144'], // O
		'139'   => self::$pictograms['se12f'], // hD
		'140'   => self::$pictograms['se230'], // wmF
		'141'   => self::$pictograms['se231'], // wmFE
		'142'   => self::$pictograms['se301'], // 䒠
		'143'   => self::$pictograms['se301'], // Nbv
		'144'   => self::$pictograms['se112'], // v[g
		'145'   => '[D]', // D
		'146'   => self::$pictograms['se043'], // Sn 1 (iCtƃtH[N)
		'147'   => self::$pictograms['se148'], // {
		'148'   => self::$pictograms['se42f'], // gbN
		'149'   => self::$pictograms['se301'], // Gsc
		'150'   => '[IDO]', // S (PDC)
		'151'   => self::$pictograms['se103'], //  2
		'152'   => self::$pictograms['se116'], // `
		'153'   => self::$pictograms['se102'], // M BOX
		'154'   => self::$pictograms['se101'], // M BOX
		'155'   => self::$pictograms['se009'], // db 2 (b)
		'156'   => self::$pictograms['se038'], // HE
		'157'   => '', // K 1 ()
		'158'   => '', // K 2 (Op)
		'159'   => self::$pictograms['se14a'], // Ot 2
		'160'   => '[}K]', // H 2 (}K)
		'161'   => self::$pictograms['se00a'], // db 3 (g)
		'162'   => '[RZg]', // RZg
		'163'   => self::$pictograms['se428'], // Ƒ
		'164'   => self::$pictograms['se21a'], // N
		'165'   => self::$pictograms['se112'], // pbP[W
		'166'   => self::$pictograms['se00b'], // FAX
		'167'   => self::$pictograms['se04a'] . self::$pictograms['se049'], // Ƃǂ܂
		'168'   => self::$pictograms['se01d'], // s@
		'169'   => self::$pictograms['se135'], // {[g (D)
		'170'   => '[TCR]', // TCR
		'171'   => '[V]', // V
		'172'   => self::$pictograms['se01e'], // d
		'173'   => '@', // SuN
		'174'   => ' ', // uN
		'175'   => ' ', // 41uN
		'176'   => self::$pictograms['se30e'], // i
		'177'   => self::$pictograms['se208'], // ։
		'178'   => self::$pictograms['se20a'], // Ԉ֎q
		'179'   => self::$pictograms['se209'], // t}[N
		'180'   => self::$pictograms['se21c'], // lp 1
		'181'   => self::$pictograms['se21d'], // lp 2
		'182'   => self::$pictograms['se21e'], // lp 3
		'183'   => self::$pictograms['se21f'], // lp 4
		'184'   => self::$pictograms['se220'], // lp 5
		'185'   => self::$pictograms['se221'], // lp 6
		'186'   => self::$pictograms['se222'], // lp 7
		'187'   => self::$pictograms['se223'], // lp 8
		'188'   => self::$pictograms['se224'], // lp 9
		'189'   => self::$pictograms['se225'], // lp 10
		'190'   => self::$pictograms['se443'], // 䕗
		'191'   => self::$pictograms['se048'], // 䂫
		'192'   => self::$pictograms['se23f'], //  (Ђ)
		'193'   => self::$pictograms['se240'], //  ()
		'194'   => self::$pictograms['se241'], //  (oq)
		'195'   => self::$pictograms['se242'], //  (ɍ)
		'196'   => self::$pictograms['se243'], //  ()
		'197'   => self::$pictograms['se244'], //  (Ƃߍ)
		'198'   => self::$pictograms['se245'], //  (V)
		'199'   => self::$pictograms['se246'], //  ()
		'200'   => self::$pictograms['se247'], //  (č)
		'201'   => self::$pictograms['se248'], //  (€)
		'202'   => self::$pictograms['se249'], //  (r)
		'203'   => self::$pictograms['se24a'], //  ()
		'204'   => self::$pictograms['se24b'], //  (ւт)
		'205'   => self::$pictograms['se154'], // ATM
		'206'   => self::$pictograms['se156'], // 24 HOURS (Rrj)
		'207'   => self::$pictograms['se151'], // gC
		'208'   => self::$pictograms['se14f'], // p[LO
		'209'   => self::$pictograms['se150'], // oX
		'210'   => self::$pictograms['se14b'], // Aei (ʒu}[N)
		'211'   => self::$pictograms['se202'], // ` (}[N)
		'212'   => self::$pictograms['se14d'], // s
		'213'   => self::$pictograms['se03a'], // KXX^h
		'214'   => '[n}]', // n}
		'215'   => self::$pictograms['se136'], // ]
		'216'   => self::$pictograms['se159'], // oX
		'217'   => self::$pictograms['se01f'], // V
		'218'   => self::$pictograms['se115'], // }\
		'219'   => self::$pictograms['se018'], // TbJ[
		'220'   => self::$pictograms['se015'], // ejX
		'221'   => self::$pictograms['se013'], // Xm[{[h
		'222'   => self::$pictograms['se132'], // `FbJ[tbO ([^[X|[c)
		'223'   => self::$pictograms['se124'], // Vn
		'224'   => self::$pictograms['se123'], // 
		'225'   => self::$pictograms['se30b'], //  (Ԃ傤)
		'226'   => self::$pictograms['se324'], // f ()
		'227'   => self::$pictograms['se44b'], // ̋
		'228'   => self::$pictograms['se509'], // ^[
		'229'   => self::$pictograms['se133'], // Xbg (777)
		'230'   => self::$pictograms['se312'], //  (A^̂)
		'231'   => self::$pictograms['se130'], // I|
		'232'   => self::$pictograms['se12b'], // Q[̃Rg[
		'233'   => self::$pictograms['se12f'], // ܋
		'234'   => self::$pictograms['se033'], // NX}Xc[
		'235'   => self::$pictograms['se030'], // Ԍ ()
		'236'   => self::$pictograms['se11b'], // 
		'237'   => self::$pictograms['se50b'], //  (jE̊)
		'238'   => self::$pictograms['se348'], // XCJ
		'239'   => self::$pictograms['se046'], // P[L
		'240'   => self::$pictograms['se147'], // tCp (ڋʏĂ)
		'241'   => '[]', // 
		'242'   => self::$pictograms['se019'], // ӂ
		'243'   => self::$pictograms['se347'], // C`S
		'244'   => self::$pictograms['se342'], // ɂ
		'245'   => self::$pictograms['se120'], // no[K[ (t@[Xgt[h)
		'246'   => self::$pictograms['se054'], // 
		'247'   => self::$pictograms['se52c'], // 
		'248'   => self::$pictograms['se01a'], // 
		'249'   => self::$pictograms['se528'], // 
		'250'   => self::$pictograms['se531'], // 
		'251'   => self::$pictograms['se04f'], // L
		'252'   => self::$pictograms['se055'], // yM
		'253'   => '[a]', // 
		'254'   => self::$pictograms['se10b'], // Ԃ
		'255'   => self::$pictograms['se307'], // ₵̂
		'256'   => self::$pictograms['se305'], // Ђ܂
		'257'   => self::$pictograms['se056'], //  1 (ꂵJI)
		'258'   => self::$pictograms['se059'], //  2 (JI)
		'259'   => self::$pictograms['se057'], //  3 (ȂJI)
		'260'   => self::$pictograms['se058'], //  4 (ꂽJI)
		'261'   => self::$pictograms['se13c'], //  (ZZZ...)
		'262'   => self::$pictograms['se334'], // { (Jb)
		'263'   => self::$pictograms['se108'], //  (܁E)
		'264'   => self::$pictograms['se105'], // 炩 (ׂ)
		'265'   => self::$pictograms['se023'], // n[g 2 (Ă)
		'266'   => self::$pictograms['se328'], // n[g 3 (傫 & )
		'267'   => self::$pictograms['se32e'], // Xp[N 2 (L}[N)
		'268'   => self::$pictograms['se311'], // e
		'269'   => self::$pictograms['se11d'], // 
		'270'   => '[SOS]', // { (SOS)
		'271'   => self::$pictograms['se14c'], // ͂
		'272'   => self::$pictograms['se329'], // n[g 5 (Ă)
		'273'   => self::$pictograms['se003'], // LX}[N
		'274'   => self::$pictograms['se10c'], // Fl
		'275'   => self::$pictograms['se443'], // Ȃ
		'276'   => self::$pictograms['se536'], //  ()
		'277'   => self::$pictograms['se11a'], // 
		'278'   => self::$pictograms['se332'], // Ԋ
		'279'   => self::$pictograms['se315'], // ۔
		'280'   => '[100_]', // 100__
		'281'   => self::$pictograms['se00d'], // p`
		'282'   => self::$pictograms['se330'], // _bV
		'283'   => self::$pictograms['se05a'], // E`}[N
		'284'   => self::$pictograms['se00f'], // lwTC
		'285'   => self::$pictograms['se226'], // }
		'286'   => self::$pictograms['se11c'], // ǂ
		'287'   => self::$pictograms['se00e'], // уTC (w)
		'288'   => self::$pictograms['se12a'], // er
		'289'   => self::$pictograms['se03c'], // }CN
		'290'   => '[z]', // z
		'291'   => self::$pictograms['se326'], // fB
		'292'   => self::$pictograms['se041'], // M^[ (GL)
		'293'   => '[oCI]', // oCI (NVbN)
		'294'   => self::$pictograms['se30a'], // wbhtH
		'295'   => self::$pictograms['se31c'], // g
		'296'   => self::$pictograms['se113'], // ANV (sXg)
		'297'   => self::$pictograms['se31e'], // GXe
		'298'   =>'[EZ]', // EZ }[N
		'299'   => self::$pictograms['se216'], //  (FREE)
		'300'   => self::$pictograms['se126'], // CD/DVD
		'301'   => self::$pictograms['se319'], // wl
		'302'   => self::$pictograms['se12b'], // UFO
		'303'   => self::$pictograms['se213'], // XV (UP!)
		'304'   => self::$pictograms['se13b'], // ˊ ()
		'305'   => '[]', // 
		'306'   => self::$pictograms['se014'], // St
		'307'   => self::$pictograms['se42a'], // oXPbg{[
		'308'   => '[y[W[]', // |Pbgx
		'309'   => self::$pictograms['se502'], // A[g
		'310'   => self::$pictograms['se503'], // 
		'311'   => self::$pictograms['se506'], // Cxg (T[JX)
		'312'   => self::$pictograms['se314'], // {
		'313'   => self::$pictograms['se34b'], // o[Xf[
		'314'   => self::$pictograms['se20e'], // Xy[h
		'315'   => self::$pictograms['se20d'], // _C
		'316'   => self::$pictograms['se20f'], // Nu
		'317'   => self::$pictograms['se419'], // 
		'318'   => self::$pictograms['se41b'], // 
		'319'   => self::$pictograms['se011'], //  (`L)
		'320'   => self::$pictograms['se012'], //  (p[)
		'321'   => '', // V
		'322'   => self::$pictograms['se04c'], // ⌇
		'323'   => self::$pictograms['se04c'], // 
		'324'   => '[CL]', // NA
		'325'   => self::$pictograms['se225'], // lp 0
		'326'   => self::$pictograms['se24d'], //  (OK)
		'327'   => self::$pictograms['se058'], // ӂӂ ()
		'328'   => self::$pictograms['se328'], // 킢
		'329'   => self::$pictograms['se330'], // ǂ (Ռ)
		'330'   => self::$pictograms['se331'], //  (юU銾)
		'331'   => '[ezplus]', // C[W[vX
		'332'   => '[n]', // n
		'333'   => self::$pictograms['se340'], // [
		'334'   => self::$pictograms['se212'], // NEW
		'335'   => self::$pictograms['se006'], // am
		'336'   => self::$pictograms['se007'], // amC
		'337'   => self::$pictograms['se00c'], // p\R
		'338'   => self::$pictograms['se128'], // WI
		'339'   => self::$pictograms['se032'], // o
		'340'   => self::$pictograms['se037'], // `y
		'341'   => self::$pictograms['se434'], // nS
		'342'   => self::$pictograms['se03b'], // xmR
		'343'   => self::$pictograms['se03e'], // 
		'344'   => self::$pictograms['se04e'], // Vg
		'345'   => self::$pictograms['se050'], // g
		'346'   => self::$pictograms['se051'], // 
		'347'   => self::$pictograms['se053'], // ˂
		'348'   => self::$pictograms['se405'], // EBN ()
		'349'   => self::$pictograms['se106'], // ڂn[g ()
		'350'   => self::$pictograms['se107'], // VbLO ()
		'351'   => self::$pictograms['se108'], //  ()
		'352'   => self::$pictograms['se10a'], // 
		'353'   => self::$pictograms['se10d'], // Pbg
		'354'   => self::$pictograms['se10e'], // 
		'355'   => self::$pictograms['se111'], // `[ (LXĂ)
		'356'   => self::$pictograms['se116'], // n}[
		'357'   => self::$pictograms['se117'], // łグԉ
		'358'   => self::$pictograms['se118'], // ͂t
		'359'   => self::$pictograms['se11e'], // d΂
		'360'   => self::$pictograms['se121'], // 
		'361'   => self::$pictograms['se122'], // Lv
		'362'   => self::$pictograms['se12d'], // 
		'363'   => self::$pictograms['se12e'], // VS (o[TX)
		'364'   => self::$pictograms['se131'], // gtB[
		'365'   => '[T]', // J
		'366'   => self::$pictograms['se511'], // XyC
		'367'   => self::$pictograms['se512'], // VA
		'368'   => self::$pictograms['se137'], // H
		'369'   => self::$pictograms['se13f'], // C
		'370'   => self::$pictograms['se143'], // j}[N
		'371'   => self::$pictograms['se44a'], // [X
		'372'   => self::$pictograms['se147'], // 
		'373'   => self::$pictograms['se14a'], // 
		'374'   => self::$pictograms['se152'], // |X
		'375'   => self::$pictograms['se153'], // X֋
		'376'   => self::$pictograms['se155'], // a@
		'377'   => self::$pictograms['se157'], // wZ
		'378'   => self::$pictograms['se158'], // ze
		'379'   => self::$pictograms['se202'], // D
		'380'   => self::$pictograms['se207'], // 18
		'381'   => self::$pictograms['se20b'], // 
		'382'   => self::$pictograms['se214'], // COOL!
		'383'   => self::$pictograms['se227'], // }[N
		'384'   => self::$pictograms['se228'], // UE}[N
		'385'   => self::$pictograms['se229'], // ID}[N
		'386'   => self::$pictograms['se22a'], // }[N
		'387'   => self::$pictograms['se22b'], // }[N
		'388'   => self::$pictograms['se22c'], // w}[N
		'389'   => self::$pictograms['se22d'], // cƒ}[N
		'390'   => self::$pictograms['se22e'], // w
		'391'   => self::$pictograms['se22f'], // w
		'392'   => '[肢]', // 肢 ()
		'393'   => self::$pictograms['se250'], // }i[[h
		'394'   => self::$pictograms['se251'], // dOFF
		'395'   => self::$pictograms['se301'], // 
		'396'   => self::$pictograms['se302'], // lN^C
		'397'   => self::$pictograms['se303'], // nCrXJX
		'398'   => self::$pictograms['se306'], // ԑ
		'399'   => self::$pictograms['se308'], // T{e
		'400'   => self::$pictograms['se30b'], // q & t
		'401'   => self::$pictograms['se047'], // t (r[)
		'402'   => self::$pictograms['se30d'], // j}[N
		'403'   => self::$pictograms['se30f'], // ז (JvZ)
		'404'   => self::$pictograms['se310'], // D
		'405'   => self::$pictograms['se312'], // NbJ[
		'406'   => '[eznavi]', // eznavigation
		'407'   => self::$pictograms['se318'], // Xq
		'408'   => self::$pictograms['se31b'], // Ou[c
		'409'   => self::$pictograms['se31d'], // lC
		'410'   => self::$pictograms['se31f'], // e@
		'411'   => self::$pictograms['se320'], // 
		'412'   => self::$pictograms['se321'], // 
		'413'   => self::$pictograms['se322'], // rLj
		'414'   => self::$pictograms['se20c'], // n[g (gv)
		'415'   => self::$pictograms['se327'], // n[g
		'416'   => self::$pictograms['se32a'], // n[g
		'417'   => self::$pictograms['se32b'], // ΃n[g
		'418'   => self::$pictograms['se32c'], // n[g
		'419'   => self::$pictograms['se32d'], // n[g
		'420'   => self::$pictograms['se32e'], // 炫
		'421'   => self::$pictograms['se013'], // XL[
		'422'   => self::$pictograms['se332'], // 
		'423'   => self::$pictograms['se338'], // {
		'424'   => self::$pictograms['se339'], // Hp
		'425'   => self::$pictograms['se33a'], // \tgN[
		'426'   => self::$pictograms['se33b'], // |eg
		'427'   => self::$pictograms['se33c'], // 
		'428'   => self::$pictograms['se33d'], // ׂ
		'429'   => self::$pictograms['se33e'], // ͂
		'430'   => self::$pictograms['se33f'], // XpQeB
		'431'   => self::$pictograms['se341'], // J[
		'432'   => self::$pictograms['se343'], // ł
		'433'   => self::$pictograms['se344'], // i
		'434'   => self::$pictograms['se345'], // 
		'435'   => self::$pictograms['se346'], // ݂
		'436'   => self::$pictograms['se349'], // g}g
		'437'   => self::$pictograms['se34a'], // Ȃ
		'438'   => self::$pictograms['se34c'], // ٓ
		'439'   => self::$pictograms['se34d'], // 
		'440'   => self::$pictograms['se402'], // ӂ ()
		'441'   => self::$pictograms['se403'], // ڂ ()
		'442'   => self::$pictograms['se415'], // ւ ()
		'443'   => self::$pictograms['se406'], // s ()
		'444'   => self::$pictograms['se407'], // 킩
		'445'   => self::$pictograms['se408'], // 
		'446'   => self::$pictograms['se40a'], // ĂĂ ()
		'447'   => self::$pictograms['se40b'], //  ()
		'448'   => self::$pictograms['se40c'], // ׂЂ
		'449'   => self::$pictograms['se40d'], // M ()
		'450'   => self::$pictograms['se40e'], //  ()
		'451'   => self::$pictograms['se410'], // т ()
		'452'   => self::$pictograms['se40f'], //  ()
		'453'   => self::$pictograms['se326'], // y
		'454'   => self::$pictograms['se414'], // ɂɂ ()
		'455'   => self::$pictograms['se417'], // `[ 2 ()
		'456'   => self::$pictograms['se418'], // `b ()
		'457'   => self::$pictograms['se41a'], // @
		'458'   => self::$pictograms['se41c'], // 
		'459'   => self::$pictograms['se41d'], // S^肢
		'460'   => self::$pictograms['se41f'], // 
		'461'   => self::$pictograms['se420'], // OK! (wŊۃTC)
		'462'   => self::$pictograms['se421'], // u[CO (w)
		'463'   => self::$pictograms['se41e'], // oCoC
		'464'   => self::$pictograms['se423'], // NG (lR)
		'465'   => self::$pictograms['se424'], // OK! 2 (lR)
		'466'   => self::$pictograms['se426'], // ӂ (lR)
		'467'   => self::$pictograms['se425'], // Jbv
		'468'   => self::$pictograms['se429'], // oj[
		'469'   => self::$pictograms['se042'], // gybg
		'470'   => self::$pictograms['se42c'], // r[h
		'471'   => self::$pictograms['se42d'], // j
		'472'   => self::$pictograms['se430'], // h
		'473'   => self::$pictograms['se431'], // ~}
		'474'   => self::$pictograms['se432'], // pgJ[
		'475'   => self::$pictograms['se433'], // WFbgR[X^[
		'476'   => self::$pictograms['se436'], // 叼
		'477'   => self::$pictograms['se438'], // Ղ
		'478'   => self::$pictograms['se439'], // Ǝ
		'479'   => self::$pictograms['se43a'], // w
		'480'   => self::$pictograms['se43b'], // ̂ڂ
		'481'   => self::$pictograms['se43c'], // P
		'482'   => self::$pictograms['se43d'], // ԉ
		'483'   => self::$pictograms['se43f'], // X
		'484'   => self::$pictograms['se440'], // ԉ
		'485'   => self::$pictograms['se441'], // L
		'486'   => self::$pictograms['se442'], // 
		'487'   => self::$pictograms['se445'], // nEB
		'488'   => self::$pictograms['se446'], // 
		'489'   => self::$pictograms['se448'], // T^
		'490'   => self::$pictograms['se44b'], // ^ꐯ
		'491'   => self::$pictograms['se44c'], // 
		'492'   => self::$pictograms['se501'], // ze 2
		'493'   => self::$pictograms['se449'], // ̏o
		'494'   => self::$pictograms['se503'], // VNnbg
		'495'   => self::$pictograms['se504'], // fp[g
		'496'   => self::$pictograms['se505'], //  ({)
		'497'   => self::$pictograms['se506'], //  ([bp)
		'498'   => self::$pictograms['se508'], // H 2
		'499'   => self::$pictograms['se50d'], // tX
		'500'   =>'[I[vEF[u]', // I[vEF[u
		'501'   => self::$pictograms['se144'], // bNmF
		'502'   => '[ABC]', // 啶
		'503'   => '[abc]', // 
		'504'   => '[012]', // 
		'505'   => '[,@#]', // L
		'506'   => '[]', // ANZvg
		'507'   => '', // `FbN{bNX
		'508'   => self::$pictograms['se301'], // GfBbg
		'509'   => '', // WI{^
		'510'   => self::$pictograms['se114'], //  (ዾ)
		'511'   => self::$pictograms['se23b'], // ߂
		'512'   => self::$pictograms['se203'], // Cɓ
		'513'   => self::$pictograms['se104'], // I
		'514'   => self::$pictograms['se036'], // z[
		'515'   => self::$pictograms['se101'], // M 1
		'516'   => self::$pictograms['se219'], // }[N
		'517'   => self::$pictograms['se144'], // l ()
		'518'   => '[ēǂݍ]', // ēǂݍ
		'700'   => self::$pictograms['se50e'], // hCc
		'701'   => self::$pictograms['se50f'], // C^A
		'702'   => self::$pictograms['se510'], // CMX
		'703'   => self::$pictograms['se513'], // 
		'704'   => self::$pictograms['se514'], // ؍
		'705'   => self::$pictograms['se515'], // l
		'706'   => self::$pictograms['se516'], // l
		'707'   => self::$pictograms['se517'], // Chl
		'708'   => self::$pictograms['se518'], // 
		'709'   => self::$pictograms['se519'], // ΂
		'710'   => self::$pictograms['se51a'], // Ԃ
		'711'   => self::$pictograms['se51b'], // H̐l
		'712'   => self::$pictograms['se51c'], // Pl
		'713'   => self::$pictograms['se520'], // CJ
		'714'   => self::$pictograms['se51f'], // _X
		'715'   => self::$pictograms['se522'], // Mы
		'716'   => self::$pictograms['se525'], // 
		'717'   => self::$pictograms['se526'], // 
		'718'   => self::$pictograms['se527'], // RA
		'719'   => self::$pictograms['se52b'], // zX^C
		'720'   => self::$pictograms['se52d'], // wr
		'721'   => self::$pictograms['se52e'], // {
		'722'   => self::$pictograms['se52f'], // ڂ
		'723'   => self::$pictograms['se530'], // ӂԂ炭
		'724'   => self::$pictograms['se532'], // A^
		'725'   => self::$pictograms['se533'], // B^
		'726'   => self::$pictograms['se534'], // O^
		'727'   => self::$pictograms['se535'], // AB^
		'728'   => self::$pictograms['se536'], // 
		'729'   => self::$pictograms['se007'], // Xj[J[
		'730'   => self::$pictograms['se50b'], // 
		'731'   => self::$pictograms['se236'], // J[u
		'732'   => self::$pictograms['se238'], // J[u
		'733'   => self::$pictograms['se337'] . self::$pictograms['se336'], // u!?v
		'734'   => self::$pictograms['se337'] . self::$pictograms['se337'], // u!!v
		'735'   => '-o-', // 
		'736'   => '[]', // 
		'737'   => '[pCibv]', // pCibv
		'738'   => '[]', // Ԃǂ
		'739'   => '[oii]', // oii
		'740'   => '[Ƃ낱]', // Ƃ낱
		'741'   => '[̂]', // ̂
		'742'   => '[I]', // I
		'743'   => '[]', // 
		'744'   => '[Ĉ]', // ₫
		'745'   => '[sU]', // sU
		'746'   => '[^[L[]', // ^[L[
		'747'   => '[[]', // [
		'748'   => self::$pictograms['se045'], // gsJhN
		'749'   => '[C]', // C
		'750'   => '[sAm]', // sAm
		'751'   => self::$pictograms['se017'], // T[tB
		'752'   => self::$pictograms['se019'], // ނ
		'753'   => '[{EO]', // {EO
		'754'   => '[Ȃ܂͂]', // Ȃ܂͂
		'755'   => '[V]', // V
		'756'   => '[p_]', // p_
		'757'   => self::$pictograms['se105'], // ׁ[
		'758'   => self::$pictograms['se10b'], // Ԃ̕@
		'759'   => self::$pictograms['se032'], // 
		'760'   => self::$pictograms['se33a'], // ACXN[
		'761'   => '', // h[ic
		'762'   => '[NbL[]', // NbL[
		'763'   => self::$pictograms['se437'], // `R
		'764'   => '[LfB]', // LfB ()
		'765'   => '[؂؂LfB]',// LfB (؂؂)
		'766'   => '(/__)', //  ()
		'767'   => '(ExE)', // 킴 ()
		'768'   => '|(E_E)|', //  ()
		'769'   => self::$pictograms['se03b'], // ΎR
		'770'   => self::$pictograms['se314'] . self::$pictograms['se022'], // {̃n[g
		'771'   => '[ABC]', // puABCv
		'772'   => '[v]', // v
		'773'   => '[I]', // ~co`
		'774'   => '[ĂƂ]', // egEV
		'775'   => '[I|bg]', // I|bg
		'776'   => self::$pictograms['se345'], // 
		'777'   => self::$pictograms['se04e'], // Ĥ͂D
		'778'   => self::$pictograms['se407'], // ڂ܂鎞̋L
		'779'   => self::$pictograms['se416'], // Ձ[ (킢{)
		'780'   => self::$pictograms['se416'], // Ձ[ (킢{) (lR)
		'781'   => self::$pictograms['se44b'], // V̐
		'782'   => self::$pictograms['se417'], // `[ (lR)
		'783'   => self::$pictograms['se414'], // ɂ (lR)
		'784'   => self::$pictograms['se103'], // [
		'785'   => self::$pictograms['se412'], // ΂ (lR)
		'786'   => self::$pictograms['se412'], // ΂ ()
		'787'   => self::$pictograms['se106'], // ڂn[g (lR)
		'788'   => self::$pictograms['se410'], // ق[ (lR)
		'789'   => self::$pictograms['se410'], // ق[ ()
		'790'   => self::$pictograms['se413'], // ܂ۂ (lR)
		'791'   => self::$pictograms['se413'], // ܂ۂ ()
		'792'   => self::$pictograms['se402'], //  (lR)
		'793'   => self::$pictograms['se319'], // hX
		'794'   => '[C]', // C
		'795'   => self::$pictograms['se039'], // w
		'796'   => '[ԎD]', // ԎD
		'797'   => self::$pictograms['se519'], // W[J[
		'798'   => '[CVtC]', // GrtC
		'799'   => self::$pictograms['se101'], // e[ACR
		'800'   => self::$pictograms['se201'], // l
		'801'   => self::$pictograms['se432'], // pgJ[̃v
		'802'   => self::$pictograms['se03d'], // ezmovie
		'803'   => self::$pictograms['se328'], // hLhLĂn[g
		'804'   => self::$pictograms['se523'], // ʌ̂Ђ悱
		'805'   => '', // W[Y
		'806'   => self::$pictograms['se329'], // n[g[
		'807'   => '[z]', // z
		'808'   => '', // E
		'809'   => '', // ㉺
		'810'   => self::$pictograms['se43e'], // rg
		'811'   => self::$pictograms['se447'], // ot
		'812'   => self::$pictograms['se441'], // ނ
		'813'   => self::$pictograms['se415'], //  (lR)
		'814'   => self::$pictograms['se415'], //  ()
		'815'   => self::$pictograms['se101'], // C[ACR
		'816'   => self::$pictograms['se447'], // n[u
		'817'   => self::$pictograms['se010'], //  (O[)
		'818'   => self::$pictograms['se210'], // u#v
		'819'   => self::$pictograms['se012'], //  (LN^[)
		'820'   => self::$pictograms['se422'], //  (LN^[)
		'821'   => self::$pictograms['se403'], // ڂ (LN^[)
		'822'   => self::$pictograms['se416'], // 킢{ (LN^[)
		'd001'  => self::$pictograms['se04a'], // 
		'd002'  => self::$pictograms['se049'], // ܂
		'd003'  => self::$pictograms['se04b'], // J
		'd004'  => self::$pictograms['se048'], //  
		'd005'  => self::$pictograms['se13d'], // 
		'd006'  => self::$pictograms['se443'], // 䕗
		'd007'  => '[]', // 
		'd008'  => self::$pictograms['se43c'], // J
		'd009'  => self::$pictograms['se23f'], // r
		'd010'  => self::$pictograms['se240'], // 
		'd011'  => self::$pictograms['se241'], // oq
		'd012'  => self::$pictograms['se242'], // I
		'd013'  => self::$pictograms['se243'], // q
		'd014'  => self::$pictograms['se244'], // 
		'd015'  => self::$pictograms['se245'], // V
		'd016'  => self::$pictograms['se246'], // 嶍
		'd017'  => self::$pictograms['se247'], // ˎ
		'd018'  => self::$pictograms['se248'], // Rr
		'd019'  => self::$pictograms['se249'], // r
		'd020'  => self::$pictograms['se24a'], // 
		'd021'  => self::$pictograms['se322'], // X|[c
		'd022'  => self::$pictograms['se016'], // 싅
		'd023'  => self::$pictograms['se014'], // St
		'd024'  => self::$pictograms['se015'], // ejX
		'd025'  => self::$pictograms['se018'], // TbJ[
		'd026'  => self::$pictograms['se013'], // XL[
		'd027'  => self::$pictograms['se42a'], // oXPbg{[
		'd028'  => self::$pictograms['se132'], // [^[X|[c (`FbJ[tbO)
		'd029'  => '[y[W[]', // |Pbgx
		'd030'  => self::$pictograms['se01e'], // d
		'd031'  => self::$pictograms['se434'], // nS
		'd032'  => self::$pictograms['se435'], // V
		'd033'  => self::$pictograms['se01b'], //  (Z_)
		'd034'  => self::$pictograms['se42e'], //  (RV)
		'd035'  => self::$pictograms['se159'], // oX
		'd036'  => self::$pictograms['se202'], // D
		'd037'  => self::$pictograms['se01d'], // s@
		'd038'  => self::$pictograms['se036'], // 
		'd039'  => self::$pictograms['se038'], // r
		'd040'  => self::$pictograms['se153'], // X֋
		'd041'  => self::$pictograms['se155'], // a@
		'd042'  => self::$pictograms['se14d'], // s
		'd043'  => self::$pictograms['se154'], // ATM
		'd044'  => self::$pictograms['se158'], // ze
		'd045'  => self::$pictograms['se156'], // Rrj
		'd046'  => self::$pictograms['se03a'], // K\X^h
		'd047'  => self::$pictograms['se14f'], // ԏ
		'd048'  => self::$pictograms['se14e'], // M
		'd049'  => self::$pictograms['se151'], // gC
		'd050'  => self::$pictograms['se043'], // Xg
		'd051'  => self::$pictograms['se045'], // iX
		'd052'  => self::$pictograms['se044'], // o[ (}eB[j)
		'd053'  => self::$pictograms['se047'], // r[
		'd054'  => self::$pictograms['se120'], // t@[Xgt[h (no[K[)
		'd055'  => self::$pictograms['se13e'], // ueBbN
		'd056'  => self::$pictograms['se313'], // e@ ()
		'd057'  => self::$pictograms['se03c'], // JIP
		'd058'  => self::$pictograms['se03d'], // f
		'd059'  => self::$pictograms['se236'], // E΂ߏ
		'd060'  => self::$pictograms['se124'], // Vn (ؔn)
		'd061'  => self::$pictograms['se30a'], // y (wbhz)
		'd062'  => self::$pictograms['se502'], // A[g
		'd063'  => self::$pictograms['se503'], // 
		'd064'  => self::$pictograms['se506'], // Cxg (T[JX)
		'd065'  => self::$pictograms['se125'], // `Pbg
		'd066'  => self::$pictograms['se30e'], // i
		'd067'  => self::$pictograms['se208'], // ։
		'd068'  => self::$pictograms['se008'], // J
		'd069'  => self::$pictograms['se323'], // Jo
		'd070'  => self::$pictograms['se148'], // {
		'd071'  => self::$pictograms['se314'], // {
		'd072'  => self::$pictograms['se112'], // v[g
		'd073'  => self::$pictograms['se34b'], // o[Xf[
		'd074'  => self::$pictograms['se009'], // db
		'd075'  => self::$pictograms['se00a'], // gѓdb
		'd076'  => self::$pictograms['se301'], // 
		'd077'  => self::$pictograms['se12a'], // TV
		'd078'  => self::$pictograms['se12b'], // Q[
		'd079'  => self::$pictograms['se126'], // CD
		'd080'  => self::$pictograms['se20c'], // n[g
		'd081'  => self::$pictograms['se20e'], // Xy[h
		'd082'  => self::$pictograms['se20d'], // _C
		'd083'  => self::$pictograms['se20f'], // Nu
		'd084'  => self::$pictograms['se419'], // 
		'd085'  => self::$pictograms['se41b'], // 
		'd086'  => self::$pictograms['se010'], //  (O[)
		'd087'  => self::$pictograms['se011'], //  (`L)
		'd088'  => self::$pictograms['se012'], //  (p[)
		'd089'  => self::$pictograms['se238'], // E΂߉
		'd090'  => self::$pictograms['se237'], // ΂ߏ
		'd091'  => self::$pictograms['se536'], // 
		'd092'  => self::$pictograms['se007'], // 
		'd093'  => self::$pictograms['se214'], // ዾ
		'd094'  => self::$pictograms['se20a'], // Ԉ֎q
		'd095'  => '', // V
		'd096'  => self::$pictograms['se04c'], // ⌇
		'd097'  => self::$pictograms['se04c'], // 
		'd098'  => self::$pictograms['se04c'], // O
		'd099'  => '', // 
		'd100'  => self::$pictograms['se052'], // 
		'd101'  => self::$pictograms['se04f'], // L
		'd102'  => self::$pictograms['se01c'], // ][g (bg)
		'd103'  => self::$pictograms['se033'], // NX}X
		'd104'  => self::$pictograms['se239'], // ΂߉
		'd105'  => self::$pictograms['se104'], // phone to
		'd106'  => self::$pictograms['se103'], // mail to
		'd107'  => self::$pictograms['se00b'], // fax to
		'd108'  => '[i]', // i[h
		'd109'  => '[i]', // i[h (gt)
		'd110'  => self::$pictograms['se103'], // [
		'd111'  => '[hR]', // hR
		'd112'  => '[D]', // hR|Cg
		'd113'  => self::$pictograms['se215'], // L
		'd114'  => self::$pictograms['se216'], // 
		'd115'  => self::$pictograms['se229'], // ID
		'd116'  => self::$pictograms['se03f'], // pX[h
		'd117'  => '', // L
		'd118'  => '[CL]', // NA
		'd119'  => self::$pictograms['se114'], // T[` (ׂ)
		'd120'  => self::$pictograms['se212'], // NEW
		'd121'  => self::$pictograms['se14b'], // ʒu
		'd122'  => self::$pictograms['se211'], // t[_C
		'd123'  => self::$pictograms['se210'], // V[v_C
		'd124'  => 'Q', // oQ
		'd125'  => self::$pictograms['se21c'], // 1 (one)
		'd126'  => self::$pictograms['se21d'], // 2 (two)
		'd127'  => self::$pictograms['se21e'], // 3 (three)
		'd128'  => self::$pictograms['se21f'], // 4 (four)
		'd129'  => self::$pictograms['se220'], // 5 (five)
		'd130'  => self::$pictograms['se221'], // 6 (six)
		'd131'  => self::$pictograms['se222'], // 7 (seven)
		'd132'  => self::$pictograms['se223'], // 8 (eight)
		'd133'  => self::$pictograms['se224'], // 9 (nine)
		'd134'  => self::$pictograms['se225'], // 0 (zero)
		'd135'  => self::$pictograms['se24d'], //  (OK)
		'd136'  => self::$pictograms['se022'], // n[g
		'd137'  => self::$pictograms['se328'], // hn[g
		'd138'  => self::$pictograms['se023'], // 
		'd139'  => self::$pictograms['se328'], // n[g (n[g)
		'd140'  => self::$pictograms['se056'], // [ ()
		'd141'  => self::$pictograms['se059'], //  ({)
		'd142'  => self::$pictograms['se057'], // ` (_)
		'd143'  => self::$pictograms['se407'], // ₾` (߂)
		'd144'  => self::$pictograms['se406'], // ӂӂ
		'd145'  => self::$pictograms['se236'], // Obh ()
		'd146'  => self::$pictograms['se03e'], //  ()
		'd147'  => self::$pictograms['se123'], // C ()
		'd148'  => self::$pictograms['se204'], // 킢
		'd149'  => self::$pictograms['se003'], // LX}[N
		'd150'  => self::$pictograms['se32e'], // ҂҂ (V)
		'd151'  => self::$pictograms['se10f'], // Ђ߂
		'd152'  => self::$pictograms['se334'], // ނ ({)
		'd153'  => self::$pictograms['se00d'], // p`
		'd154'  => self::$pictograms['se311'], // e
		'd155'  => self::$pictograms['se326'], // [h
		'd156'  => self::$pictograms['se238'], // obh ()
		'd157'  => self::$pictograms['se13c'], //  ()
		'd158'  => self::$pictograms['se021'], // exclamation
		'd159'  => self::$pictograms['se021'] . self::$pictograms['se020'], // exclamation and question
		'd160'  => self::$pictograms['se021'], // double exclamation
		'd161'  => self::$pictograms['se330'], // ǂ (Ռ)
		'd162'  => self::$pictograms['se331'], //  (юU銾)
		'd163'  => self::$pictograms['se108'], // [ ()
		'd164'  => self::$pictograms['se330'], // _bV (o)
		'd165'  => '``', // [ (L1)
		'd166'  => '-o-', // [ (L2)
		'd167'  => self::$pictograms['se324'], // J`R
		'd168'  => self::$pictograms['se12f'], // ӂ
		'd169'  => self::$pictograms['se301'], // y
		'd170'  => self::$pictograms['se056'], // le
		'd171'  => self::$pictograms['se11f'], // 
		'd172'  => self::$pictograms['se44b'], // 
		'd173'  => 'SOON', // soon
		'd174'  => 'ON', // on
		'd175'  => 'END', // end
		'd176'  => self::$pictograms['se026'], // v
		'd201'  => '', // iAv
		'd202'  => '[]', // iAv (gt)
		'd203'  => self::$pictograms['se006'], // TVc ({[_[)
		'd204'  => '[z]', // ܌z
		'd205'  => self::$pictograms['se31c'], // 
		'd206'  => '', // W[Y
		'd207'  => self::$pictograms['se013'], // Xm{
		'd208'  => self::$pictograms['se325'], // `y
		'd209'  => '[hA]', // hA
		'd210'  => self::$pictograms['se12f'], // h
		'd211'  => self::$pictograms['se00c'], // p\R
		'd212'  => self::$pictograms['se101'] . self::$pictograms['se022'], // u^[
		'd213'  => self::$pictograms['se116'], // `
		'd214'  => self::$pictograms['se301'], // M
		'd215'  => self::$pictograms['se10e'], // 
		'd216'  => self::$pictograms['se034'], // w
		'd217'  => '[v]', // v
		'd218'  => self::$pictograms['se136'], // ]
		'd219'  => self::$pictograms['se338'], // ̂
		'd220'  => self::$pictograms['se026'], // rv
		'd221'  => self::$pictograms['se403'], // lĂ
		'd222'  => self::$pictograms['se40a'], // قƂ
		'd223'  => self::$pictograms['se415'] . self::$pictograms['se331'], // ⊾ ()
		'd224'  => self::$pictograms['se108'], // ⊾2 ()
		'd225'  => self::$pictograms['se416'], // ՂȊ
		'd226'  => self::$pictograms['se40e'], // {P[Ƃ
		'd227'  => self::$pictograms['se106'], // ڂn[g ()
		'd228'  => self::$pictograms['se00e'], // wOK
		'd229'  => self::$pictograms['se105'], // ׁ[
		'd230'  => self::$pictograms['se405'], // EBN
		'd231'  => self::$pictograms['se40a'], // ꂵ
		'd232'  => self::$pictograms['se406'], // ܂
		'd233'  => self::$pictograms['se402'], // L2
		'd234'  => self::$pictograms['se411'], // 
		'd235'  => self::$pictograms['se413'], // 
		'd236'  => self::$pictograms['se423'], // NG
		'd237'  => self::$pictograms['se301'], // Nbv
		'd238'  => self::$pictograms['se24e'], // Rs[Cg (C)
		'd239'  => self::$pictograms['se537'], // g[h}[N (TM)
		'd240'  => self::$pictograms['se115'], // l
		'd241'  => self::$pictograms['se315'], // }
		'd242'  => '[TCN]', // TCN
		'd243'  => self::$pictograms['se24f'], // WX^[hg[h}[N (R)
		'd244'  => self::$pictograms['se252'], // 댯Ex (!)
		'd245'  => '[]', // ֎~
		'd246'  => self::$pictograms['se22b'], // 󎺁EȁE
		'd247'  => '[i]', // i}[N
		'd248'  => self::$pictograms['se22a'], // EȁE
		'd249'  => '', // 󍶉E
		'd250'  => '', // ㉺
		'd251'  => self::$pictograms['se157'], // wZ
		'd252'  => self::$pictograms['se43e'], // g
		'd253'  => self::$pictograms['se03b'], // xmR
		'd254'  => self::$pictograms['se110'], // N[o[
		'd255'  => '[]', // 
		'd256'  => self::$pictograms['se304'], // `[bv
		'd257'  => '[oii]', // oii
		'd258'  => self::$pictograms['se345'], // 
		'd259'  => self::$pictograms['se110'], // 
		'd260'  => self::$pictograms['se118'], // ݂
		'd261'  => self::$pictograms['se030'], // 
		'd262'  => self::$pictograms['se342'], // ɂ
		'd263'  => self::$pictograms['se046'], // V[gP[L
		'd264'  => self::$pictograms['se30b'], // Ƃ (傱t)
		'd265'  => self::$pictograms['se340'], // ǂԂ
		'd266'  => self::$pictograms['se339'], // p
		'd267'  => self::$pictograms['se441'], // ނ
		'd268'  => self::$pictograms['se523'], // Ђ悱
		'd269'  => self::$pictograms['se055'], // yM
		'd270'  => self::$pictograms['se019'], // 
		'd271'  => self::$pictograms['se056'], // ܂! ()
		'd272'  => self::$pictograms['se415'], // EbVbV ()
		'd273'  => self::$pictograms['se01a'], // E}
		'd274'  => self::$pictograms['se10b'], // u^
		'd275'  => self::$pictograms['se044'], // COX
		'd276'  => self::$pictograms['se107'], //  ()
		'e253'  => self::$pictograms['se00f'], // lw
		'e254'  => self::$pictograms['se425'], // Jbv
		'e255'  => self::$pictograms['se209'], // t}[N
		'e256'  => self::$pictograms['se041'], // M^[
		'e257'  => self::$pictograms['se14a'], // `[g
		'e258'  => self::$pictograms['se207'], // 18Έȏ֎~
		'e259'  => self::$pictograms['se12d'], // v
		'e260'  => self::$pictograms['se428'], // R~jeB
		'e261'  => '[HIT]', // qbg
		'e262'  => '[V]', // V
		'e263'  => self::$pictograms['se448'], // T^N[X
		'e264'  => self::$pictograms['se428'], // Ƒ
		'e265'  => '@', // [gp]
		'e266'  => '', // RC
		'e267'  => '@', // [gp]
		'e268'  => '@', // [gp]
		'e269'  => 'EM', // EMOBILE S (n)
		'e270'  => 'EM', // EMOBILE S (Ԓn)
		'e271'  => '@', // [gp]
		'e272'  => '@', // [gp]
		'e273'  => '@', // [gp]
		'e274'  => '@', // [gp]
		'e275'  => '@', // [gp]
		'e276'  => '@', // [gp]
		'e277'  => '@', // [gp]
		'e278'  => '@', // [gp]
		'wf040' => self::$pictograms['se022'], // n[g
		'wf041' => self::$pictograms['se026'], // v
		'wf042' => self::$pictograms['se009'], // db
		'wf043' => self::$pictograms['se045'], // Jbv
		'wf044' => '*', // *
		'wf045' => '', // ㉺ ()
		'wf046' => '', // E ()
		'wf047' => '(((', // dg ()
		'wf048' => self::$pictograms['se04a'], // 
		'wf049' => self::$pictograms['se04b'], // J
		'wf04a' => self::$pictograms['se049'], // ܂
		'wf04b' => self::$pictograms['se108'], // 
		'wf04c' => self::$pictograms['se056'], // Ί
		'wf04d' => self::$pictograms['se003'], //  (LX}[N)
		'wf04e' => self::$pictograms['se03e'], // fB (\Z)
		'wf04f' => self::$pictograms['se01b'], // 
		'wf050' => self::$pictograms['se01e'], // d
		'wf051' => self::$pictograms['se01d'], // s@
		'wf052' => '[oCN]'          , // oCN
		'wf053' => self::$pictograms['se036'], // 
		'wf054' => self::$pictograms['se038'], // r
		'wf055' => self::$pictograms['se011'], // s[X ()
		'wf056' => self::$pictograms['se043'], // fBi[ (iCtƃtH[N)Xg)
		'wf057' => self::$pictograms['se044'], // OX)
		'wf058' => self::$pictograms['se413'], //  ()
		'wf059' => self::$pictograms['se304'], // `[bv
		'wf05a' => self::$pictograms['se016'], // 싅 (obg)
		'wf05b' => self::$pictograms['se016'], // {[
		'wf05c' => self::$pictograms['se010'], // p` ()
		'wf05d' => self::$pictograms['se13d'], // 
		'wf05e' => self::$pictograms['se059'], // {
		'wf05f' => self::$pictograms['se047'], // r[
		'wf060' => self::$pictograms['se301'], // m[g
		'wf061' => self::$pictograms['se301'], // y (M)
		'wf062' => self::$pictograms['se11c'], // hN
		'wf063' => self::$pictograms['se101'], // [
		'wf064' => self::$pictograms['se208'], // ։
		'wf065' => self::$pictograms['se325'], // x
		'wf066' => self::$pictograms['se030'], // 
		'wf067' => self::$pictograms['se123'], // 
		'wf068' => self::$pictograms['se04c'], //  (26)
		'wf069' => self::$pictograms['se50b'], // 
		'wf06a' => self::$pictograms['se40c'], // }XN ()
		'wf06b' => self::$pictograms['se30a'], // R[h
		'wf06c' => '[]', // 
		'wf06d' => self::$pictograms['se052'], // 
		'wf06e' => self::$pictograms['se04f'], // L
		'wf06f' => self::$pictograms['se109'], // 
		'wf070' => self::$pictograms['se526'], // 
		'wf071' => self::$pictograms['se10a'], // 
		'wf072' => self::$pictograms['se340'], // k[h
		'wf073' => self::$pictograms['se03c'], // }CN (JIP)
		'wf074' => self::$pictograms['se334'], // ނ ({)
		'wf075' => self::$pictograms['se523'], // Ђ悱
		'wf076' => self::$pictograms['se408'], // 
		'wf077' => self::$pictograms['se045'], // R[q[
		'wf078' => self::$pictograms['se30e'], // ^oR
		'wf079' => self::$pictograms['se331'], // 
		'wf07a' => self::$pictograms['se342'], // ɂ
		'wf07b' => self::$pictograms['se323'], // Jo
		'wf07c' => self::$pictograms['se05a'], // 
		'wf07d' => self::$pictograms['se302'], // lN^C
		'wf07e' => self::$pictograms['se006'], // Vc
		'wf080' => self::$pictograms['se348'], // 
		'wf081' => self::$pictograms['se43f'], // JLX
		'wf082' => self::$pictograms['se322'], // rLj
		'wf083' => self::$pictograms['se313'], // ͂
		'wf084' => self::$pictograms['se13b'], // 
		'wf085' => self::$pictograms['se202'], // D (d)
		'wf086' => self::$pictograms['se531'], // 
		'wf087' => self::$pictograms['se012'], // oCoC ()
		'wf088' => self::$pictograms['se023'], // 
		'wf089' => self::$pictograms['se20d'], // _C (gv)v)
		'wf08a' => self::$pictograms['se20f'], // N[o[ (gv)
		'wf08b' => self::$pictograms['se20e'], // Xy[h (gv))
		'wf08c' => self::$pictograms['se301'], // Nbv
		'wf08d' => self::$pictograms['se048'], // Ⴞ
		'wf08e' => self::$pictograms['se34b'], // P[L
		'wf08f' => self::$pictograms['se345'], // 
		'wf090' => self::$pictograms['se112'], // v[g
		'wf091' => self::$pictograms['se12f'], //  (h)
		'wf092' => '[EXIT]', // o
		'wf093' => '[hA]', // 
		'wf094' => self::$pictograms['se518'], // ₶
		'wf095' => self::$pictograms['se00a'], // PHS
		'wf096' => self::$pictograms['se32f'], // 
		'wf097' => self::$pictograms['se125'], // `Pbg
		'wf098' => self::$pictograms['se328'], // n[g
		'wf099' => self::$pictograms['se10f'], // Ђ߂
		'wf09a' => self::$pictograms['se536'], // 
		'wf09b' => self::$pictograms['se057'], // Ί
		'wf09c' => self::$pictograms['se015'], // ejX
		'wf09d' => self::$pictograms['se03d'], // f
		'wf09e' => self::$pictograms['se013'], // XL[
		'wf09f' => self::$pictograms['se337'].self::$pictograms['se337'], // !!
		'wf0a0' => self::$pictograms['se337'].self::$pictograms['se336'], // !?
		'wf0a1' => self::$pictograms['se336'], // ?
		'wf0a2' => self::$pictograms['se238'], // ~ ()
		'wf0a3' => self::$pictograms['se236'], // ㏸ ()
		'wf0a4' => self::$pictograms['se00e'], // Obh (ew)
		'wf0a5' => self::$pictograms['se14c'], // ͂
		'wf0a6' => self::$pictograms['se329'], // L[sbg (n[gƖ)
		'wf0a7' => self::$pictograms['se332'], // ܂
		'wf0a8' => self::$pictograms['se443'], // 䕗
		'wf0a9' => self::$pictograms['se43e'], // C
		'wf0aa' => self::$pictograms['se017'], // T[tB
		'wf0ab' => self::$pictograms['se04d'], // R
		'wf0ac' => self::$pictograms['se03b'], // xmR
		'wf0ad' => self::$pictograms['se122'], // Lv
		'wf0ae' => self::$pictograms['se119'], // t
		'wf0af' => self::$pictograms['se159'], // oX
		'wf0b0' => self::$pictograms['se018'], // TbJ[
		'wf0b1' => self::$pictograms['se209'], // S
		'wf0b2' => self::$pictograms['se23d'], // ߂
		'wf0b3' => self::$pictograms['se23c'], // 
		'wf0b4' => '[dv]', // dv
		'wf0b5' => self::$pictograms['se207'], // 18
		'wf0b6' => self::$pictograms['se252'], // 
		'wf0b7' => '[TCN]', // TCN
		'wf0b8' => self::$pictograms['se20b'], // dEx
		'wf0b9' => ')))', // dg (E)
		'wf0ba' => self::$pictograms['se333'], // oc
		'wf0bb' => self::$pictograms['se24e'], // Rs[Cg
		'wf0bc' => self::$pictograms['se24f'], // WX^[hg[h}[N
		'wf0bd' => self::$pictograms['se133'], // X[Zu
		'wf0be' => self::$pictograms['se225'], // 0 (zero)
		'wf0bf' => self::$pictograms['se21c'], // 1 (one)
		'wf0c0' => self::$pictograms['se21d'], // 2 (two)
		'wf0c1' => self::$pictograms['se21e'], // 3 (three)
		'wf0c2' => self::$pictograms['se21f'], // 4 (four)
		'wf0c3' => self::$pictograms['se220'], // 5 (five)
		'wf0c4' => self::$pictograms['se221'], // 6 (six)
		'wf0c5' => self::$pictograms['se222'], // 7 (seven)
		'wf0c6' => self::$pictograms['se223'], // 8 (eight)
		'wf0c7' => self::$pictograms['se224'], // 9 (nine)
		'wf0c8' => self::$pictograms['se23f'], // r
		'wf0c9' => self::$pictograms['se240'], // 
		'wf0ca' => self::$pictograms['se241'], // oq
		'wf0cb' => self::$pictograms['se242'], // I
		'wf0cc' => self::$pictograms['se243'], // q
		'wf0cd' => self::$pictograms['se244'], // 
		'wf0ce' => self::$pictograms['se245'], // V
		'wf0cf' => self::$pictograms['se246'], // 嶍
		'wf0d0' => self::$pictograms['se24b'], // ւт
		'wf0d1' => self::$pictograms['se247'], // ˎ
		'wf0d2' => self::$pictograms['se248'], // Rr
		'wf0d3' => self::$pictograms['se249'], // r
		'wf0d4' => self::$pictograms['se24a'], // 
		'wf0d5' => '[n]', // n
		'wf0d6' => self::$pictograms['se120'], // }Nhih
		'wf0d7' => self::$pictograms['se120'], // Xo[K[
		'wf0d8' => '@', // [gp]
		'wf0d9' => self::$pictograms['se120'], // beA
		'wf0da' => '@', // [gp]
		'wf0db' => self::$pictograms['se045'], // hg[R[q[
		'wf0dc' => '@', // [gp]
		'wf0dd' => '@', // [gp]
		'wf0de' => '@', // [gp]
		'wf0df' => '@', // [gp]
		'wf0e0' => self::$pictograms['se043'], //  (o[~?)
		'wf0e1' => '@', // [gp]
		'wf0e2' => '@', // [gp]
		'wf0e3' => self::$pictograms['se043'], // тhL[
		'wf0e4' => '@', // [gp]
		'wf0e5' => '@', // [gp]
		'wf0e6' => '@', // [gp]
		'wf0e7' => self::$pictograms['se156'], // [\
		'wf0e8' => '@', // [gp]
		'wf0e9' => self::$pictograms['se156'], // am/pm
		'wf0ea' => '@', // [gp]
		'wf0eb' => '@', // [gp]
		'wf0ec' => '@', // [gp]
		'wf0ed' => '@', // [gp]
		'wf0ee' => '@', // [gp]
		'wf0ef' => '@', // [gp]
		'wf0f0' => self::$pictograms['se504'], // 
		'wf0f1' => '@', // [gp]
		'wf0f2' => '@', // [gp]
		'wf0f3' => '@', // [gp]
		'wf0f4' => '@', // [gp]
		'wf0f5' => '@', // [gp]
		'wf0f6' => '@', // [gp]
		'wf0f7' => '@', // [gp]
		'wf0f8' => '@', // [gp]
		'wf0f9' => '@', // [gp]
		'wf0fa' => '@', // [gp]
		'wf0fb' => '@', // [gp]
		'wf0fc' => self::$pictograms['se052'], // n`
		'wf140' => '[C]', // C
		'wf141' => '@', // [gp]
		'wf142' => '@', // [gp]
		'wf143' => '@', // [gp]
		'wf144' => '@', // [gp]
		'wf145' => '@', // [gp]
		'wf146' => '@', // [gp]
		'wf147' => '@', // [gp]
		'wf148' => self::$pictograms['se14d'], // UFJ
		'wf149' => '@', // [gp]
		'wf14a' => '@', // [gp]
		'wf14b' => '@', // [gp]
		'wf14c' => '@', // [gp]
		'wf14d' => '[EXIT]', // 
		'wf14e' => '@', // [gp]
		'wf14f' => '@', // [gp]
		'wf150' => self::$pictograms['se411'], // 
		'wf151' => '@', // [gp]
		'wf152' => '@', // [gp]
		'wf153' => '@', // [gp]
		'wf154' => '@', // [gp]
		'wf155' => '@', // [gp]
		'wf156' => '@', // [gp]
		'wf157' => '@', // [gp]
		'wf158' => '@', // [gp]
		'wf159' => '@', // [gp]
		'wf15a' => '@', // [gp]
		'wf15b' => '@', // [gp]
		'wf15c' => '@', // [gp]
		'wf15d' => '@', // [gp]
		'wf15e' => '@', // [gp]
		'wf15f' => '@', // [gp]
	);
	$translated = apply_filters('ktai_pictogram_table', $translated, __CLASS__, $this->charset);
	$translated = apply_filters('pictogram_table/ktai_style.php', $translated);
	$buffer = preg_replace(
		'!<img localsrc="([^"]+)"( alt="(' . KtaiStyle::DOUBLE_QUOTED_STRING_REGEX . ')")?[^/>]*/?>!se', // <?php /* syntax hilighting fix */
		'isset($translated["$1"]) ? $translated["$1"] : ("$3" ? "$3" : "")', 
		$buffer);
	$entities = array(
		'&spades;' => self::$pictograms['se20e'],
		'&#9824;'  => self::$pictograms['se20e'],
		'&#x2660;' => self::$pictograms['se20e'],
		'&clubs;'  => self::$pictograms['se20f'],
		'&#9827;'  => self::$pictograms['se20f'],
		'&#x2663;' => self::$pictograms['se20f'],
		'&hearts;' => self::$pictograms['se20c'],
		'&#9829;'  => self::$pictograms['se20c'],
		'&#x2665;' => self::$pictograms['se20c'],
		'&#9825;'  => self::$pictograms['se022'], // WHITE HEART
		'&#x2661;' => self::$pictograms['se022'], // WHITE HEART
		'&diams;'  => self::$pictograms['se20d'],
		'&#9830;'  => self::$pictograms['se20d'],
		'&#x2666;' => self::$pictograms['se20d'],
		'&#12336;' => '``', // WAVY DASH
		'&#x3030;' => '``', // WAVY DASH

	);
	$buffer = str_replace(array_keys($entities), $entities, $buffer);

	// ----- shrink escape sequences -----
	$count = version_compare(phpversion(), '5.1', '>=');
	while ($count) {
		$buffer = preg_replace("/(\x1b\\\$[A-Z])([!-z]+)\x0f\\1/", '$1$2', $buffer, -1, $count); // available after PHP 5.1.0
	}
	return parent::convert_pict($buffer);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_post_split($buffer) {
	return parent::shrink_post_split($buffer);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function pickup_pics($buffer) {
	$buffer = $this->pickup_pics_webcode($buffer);
	$buffer = $this->pickup_pics_shift_jis($buffer);
	return $buffer;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
private function pickup_pics_webcode($buffer) {
	$seq_index = array('G' => '0', 'E' => '1', 'F' => '2', 'O' => '3', 'P' => '4', 'Q' => '5');
	for ($offset = 0 , $replace = 'X' ;
	     preg_match('/\x1b.([GEFOPQ])([!-z]+)(\x0f|$)/', $buffer, $webcode, PREG_OFFSET_CAPTURE, $offset) ; 
	     $offset += strlen($replace)) 
	{
		$orig    = $webcode[0][0];
		$offset  = $webcode[0][1];
		$seq     = $webcode[1][0];
		$chars   = $webcode[2][0];
		$replace = '';
		for ($i = 0 ; $i < strlen($chars) ; $i++) {
			if (ord($char[$i]) - 32 <= $this->num_chars[$seq]) {
				$replace .= sprintf('<img localsrc="se%d%02x" />', $seq_index[$seq], ord($chars[$i]) - 32);
			} else {
				$replace .= sprintf('<img localsrc="s" alt="[ESC$%s%dSI]" />', $seq, ord($chars[$i]));
			}
		}
		$buffer = substr_replace($buffer, $replace, $offset, strlen($orig));
	}
	return $buffer;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
private function pickup_pics_shift_jis($buffer) {
	$pict_sjis = array_flip(self::$pict_sjis);
	if (! $pict_sjis || ! function_exists('mb_regex_encoding')) {
		return $buffer;
	}
	mb_regex_encoding($this->charset);
	$replaced = mb_ereg_replace(
		"([\xf7\x40-\xf7\x5b]|[\xf7\x5d-\xf7\xfc]|[\xf9\x40-\xf9\x5b]|[\xf9\x5d-\xf9\xfc]|[\xfb\x40-\xfb\x5b]|[\xfb\x5d-\xfb\xfc])", 
		'isset($pict_sjis["\1"]) ? 
		"<img localsrc=\"" . $pict_sjis["\1"] . "\" />" : 
		"<img localsrc=\"s\" alt=\"" . "[0x" . bin2hex("\1") . "]\" />"', 
		$buffer, 'e');
	if ($replaced) {
		$replaced = mb_ereg_replace("\xf7\x5c", '<img localsrc="' . $pict_sjis["\xf7\x5c"] . '" />', $replaced);
		$replaced = mb_ereg_replace("\xf9\x5c", '<img localsrc="' . $pict_sjis["\xf9\x5c"] . '" />', $replaced);
		$replaced = mb_ereg_replace("\xfb\x5c", '<img localsrc="' . $pict_sjis["\xfb\x5c"] . '" />', $replaced);
	}
	return $replaced ? $replaced : $buffer;
}

// ===== End of class ====================
}

/* ==================================================
 *   KtaiService_Softbank_PDC class
   ================================================== */

class KtaiService_Softbank_PDC extends KtaiService_Softbank {

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	parent::__construct($user_agent);
	// http://creation.mb.softbank.jp/web/web_pic_about.html
	$p = 0;
	foreach ($this->num_chars as $s => $n) {
		for ($i = 1 ; $i <= $n ; $i++) {
			self::$pictograms[sprintf('se%d%02x', $p, $i)] = "\x1b\$$s" . chr(32 + $i) . "\x0f";
		}
		$p++;
	}

	$this->theme     = ks_option('ks_theme_sb_pdc');
	$this->type      = 'PDC';
	$this->flat_rate = false;
	preg_match('!^J-(PHONE|EMULATOR)/(\d\.\d+)/([-_.a-zA-Z0-9]+)/?(SN([-_.a-zA-Z0-9]*) )?!', $user_agent, $specs);
	if ( isset($_SERVER['HTTP_X_JPHONE_MSNAME']) ) {
		$this->term_name = $_SERVER['HTTP_X_JPHONE_MSNAME'];
	} else {
		$this->term_name = isset($specs[3]) ? $specs[3] : NULL;
	}
	$this->term_ID   = isset($specs[5]) ? $specs[5] : NULL;
	$this->sub_ID    = isset($_SERVER['HTTP_X_JPHONE_UID']) ? $_SERVER['HTTP_X_JPHONE_UID'] : NULL;
	$this->cookie_available = false;
	$this->ext_css_available = false;
	$this->available_js_version = false;
	if (isset($_SERVER['x-jphone-display'])) {
		list($this->screen_width, $this->screen_height) = array_map('intval', explode('*', $_SERVER['x-jphone-display']));
	}
	$this->textarea_size = 6000;
	$this->page_size = 6000;
	if ($specs[2] < 4.0) {
		$this->cache_size = 6000;
		$this->sub_ID_available = false;
		$this->require_id_msg = "ERROR: Can't post a comment. We request your terminal's manufacture number but your phone does not available to trasmit it.";
	} else {
		$this->cache_size = 12000;
		$this->sub_ID_available = true;
		$this->require_id_msg = "ERROR: Please allow transmission of user infomation or your terminal's manifacture number.\nGo Yahoo! Japan &gt; My Softbank (User Support) &gt; Misc Application &gt; Transmission of User Infomation / Transmission of Manifacture Number.";
	}
	$this->preamble   = '';
	$this->xhtml_head = '';
	return;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_pre_split($buffer) {
	$buffer = preg_replace('!<h([1-6])([^>]*)>(.*?)</h\\1>!s', '<div$2><p>$3</p></div>', $buffer);
	$buffer = preg_replace('!<img([^>]*?) src=([\'"])([^>]*?)\.gif\\2!s', '<img$1 src=$2$3.png$2', $buffer); //"
	$buffer = preg_replace('!<a([^>]*?) href=([\'"])([^>]*?)\.gif\\2!s', '<a$1 href=$2$3.png$2', $buffer); //"
	return parent::shrink_pre_split($buffer);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_post_split($buffer) {
	$buffer = str_replace('&nbsp;', ' ', $buffer);
	$buffer = preg_replace('!\s*</(li|dt|dd|option)>\s*!', '', $buffer);
	$buffer = preg_replace('! ?/>!', '>', $buffer);
/*	$buffer = preg_replace('!<([-~_= a-zA-Z0-9%.,:;\'"/#*+]+?) ?/>!', '<$1>', $buffer); */
	return parent::shrink_post_split($buffer);
}

// ===== End of class ====================
}

/* ==================================================
 *   KtaiService_Softbank_3G class
   ================================================== */

class KtaiService_Softbank_3G extends KtaiService_Softbank {

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	parent::__construct($user_agent);
	$p = 0;
	foreach ($this->num_chars as $s => $n) {
		for ($i = 1 ; $i <= $n ; $i++) {
			$index = sprintf('se%d%02x', $p, $i);
			self::$pictograms[$index] = parent::$pict_sjis[$index];
		}
		$p++;
	}

	$this->theme     = ks_option('ks_theme_sb_3g');
	$this->type      = '3G';
	$this->flat_rate = true;
	if ( isset($_SERVER['HTTP_X_JPHONE_MSNAME']) ) {
		$this->term_name = $_SERVER['HTTP_X_JPHONE_MSNAME'];
	} else {
		$this->term_name = NULL;
	}
	if (preg_match('!^(Vodafone|SoftBank|[VS]emulator)/\d\.\d+/([-_.a-zA-Z0-9]+)/[-_.a-zA-Z0-9]+(/SN([-_.a-zA-Z0-9]*) )?!', $user_agent, $specs)) {
		$this->term_name = $this->term_name ? $this->term_name : $specs[2];
		$this->term_ID = isset($specs[4]) ? $specs[4] : NULL;
	} elseif (preg_match('!^MOT(EMULATOR)?-([CV]\d+)!', $user_agent, $specs)) {
		$names = array('C980' => '702MO', 'V980' => '702sMO');
		$this->term_name = isset($names[$specs[2]]) ? $names[$specs[2]] : NULL;
	}
	$this->sub_ID_available = is_ssl() ? false : true;
	if ( $this->sub_ID_available && isset($_SERVER['HTTP_X_JPHONE_UID']) ) {
		$this->sub_ID = stripslashes($_SERVER['HTTP_X_JPHONE_UID']);
	} else {
		$this->sub_ID = NULL;
	}
	$this->cookie_available = true;
	$this->ext_css_available = true;
	$this->available_js_version = '3.0';
	if (isset($_SERVER['x-s-display-info']) && preg_match('!^(\d+)\*(\d+)/!', $_SERVER['x-s-display-info'] , $sizes) ) {
		$this->screen_width  = $sizes[1];
		$this->screen_height = $sizes[2];
	} elseif (isset($_SERVER['x-jphone-display'])) {
		list($this->screen_width, $this->screen_height) = array_map('intval', explode('*', $_SERVER['x-jphone-display']));
	}
	$this->textarea_size = 20000;
	$this->page_size  = 20000;
	$this->cache_size = 300000;
	$this->require_id_msg = "ERROR: Please allow transmission of user infomation or your terminal's manifacture number.\nGo Yahoo! Japan &gt; My Softbank (User Support) &gt; Misc Application &gt; Transmission of User Infomation.\nGo Yahoo! Keitai &gt; Common Settings &gt; Security Settings &gt; Manufacture Number.";
	$this->preamble   = '<?xml version="1.0" encoding="__CHARSET__"?>
<!DOCTYPE html PUBLIC "-//J-PHONE//DTD XHTML Basic 1.0 Plus//EN" "xhtml-basic10-plus.dtd">'; // <?php /* syntax hilighting fix */
	$this->xhtml_head = '<html>';
	add_action('ktai_wp_head', array($this, 'paragraph_margin') );
	return;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_post_split($buffer) {
	if ($this->mime_type == 'application/xhtml+xml') {
		$buffer = $this->input_to_style($buffer);
	}
	return parent::shrink_post_split($buffer);
}

/* ==================================================
 * @param	none
 * @return	none
 * @since	2.0.0
 */
public function paragraph_margin() {
	echo '<style type="text/css"><![CDATA[ p {margin:0.5em 0;} ]]></style>' . "\n";
}


// ===== End of class ====================
}
?>