<?php
if ( function_exists('register_sidebar') )
	register_sidebar(array(
        'before_widget' => '<div id="%1$s" class="%2$s widget">',
        'after_widget' => '</div>',
        'before_title' => '<h3 class="widget-header">',
        'after_title' => '</h3>',
    ));
	register_sidebar(array(
		'name'=>'TOPページ：メイン',
        'before_widget' => '<div id="%1$s" class="%2$s widget">',
        'after_widget' => '</div>',
        'before_title' => '<h3 class="widget-header">',
        'after_title' => '</h3>',
    ));


/**
 * Firstserver Tmaplate widgets
 * Version: 1.01 2010/02/17 
 */


$widget_ops = array('classname' => 'widget_welcome', 'description' => __( "TOPページのメインエリアに表示するウェルカムメッセージ") );
wp_register_sidebar_widget('widget_welcome', __('[TOPメイン]ウェルカムメッセージ'), 'wp_widget_welcome', $widget_ops);

$widget_ops = array('classname' => 'widget_new_archive_list', 'description' => __( "TOPページのメインエリアに表示する新着記事一覧。") );
wp_register_sidebar_widget('top-news', __('[TOPメイン]新着記事一覧'), 'wp_widget_new_archive_list', $widget_ops);
wp_register_widget_control('top-news', __('[TOPメイン]新着記事一覧'), 'wp_widget_new_archive_list_control' );

$widget_ops = array('classname' => 'widget_category_archive', 'description' => __( "TOPページのメインエリアに表示するカテゴリ記事一覧。特定のカテゴリのみを表示") );
wp_register_sidebar_widget('category_archive', __('[TOPメイン]カテゴリ記事一覧'), 'wp_widget_category_archive', $widget_ops);
wp_register_widget_control('category_archive', __('[TOPメイン]カテゴリ記事一覧'), 'wp_widget_category_archive_control' );

$widget_ops = array('classname' => 'widget_top_archive', 'description' => __( "TOPページのメインエリアに表示する特定記事。指定した記事を表示") );
wp_register_sidebar_widget('widget_top_archive', __('[TOPメイン]トップ表示記事'), 'wp_widget_top_archive', $widget_ops);

$widget_ops = array('classname' => 'widget_company', 'description' => __( "サイド表示の会社概要") );
wp_register_sidebar_widget('widget_company', __('[サイド]会社概要'), 'wp_widget_company', $widget_ops);

$widget_ops = array('classname' => 'widget_freearea', 'description' => __( "サイド表示のフリーエリア") );
wp_register_sidebar_widget('widget_freearea', __('[サイド]フリーエリア'), 'wp_widget_freearea', $widget_ops);

$widget_ops = array('classname' => 'widget_rss_icon', 'description' => __( "サイド表示のRSSアイコン") );
wp_register_sidebar_widget('widget_rss_icon', __('[サイド]RSSアイコン'), 'wp_widget_rss_icon', $widget_ops);

wp_widget_categories_menu_register();

?>
<?php
/** [サイド]会社概要 */
function wp_widget_company($args) {
?>
<?php include(TEMPLATEPATH . '/w_company.php'); ?>
<?php
}
?>
<?php
/** [サイド]フリーエリア */
function wp_widget_freearea($args) {
?>
<?php include(TEMPLATEPATH . '/w_freearea.php'); ?>
<?php
}
?>
<?php
/** [サイド]RSSアイコン */
function wp_widget_rss_icon($args) {
?>
<?php include(TEMPLATEPATH . '/w_rss_icon.php'); ?>
<?php
}
?>
<?php
/** [TOPメイン]ウェルカムメッセージ */
function wp_widget_welcome($args) {
?>
<?php include(TEMPLATEPATH . '/w_welcome_message.php'); ?>
<?php
}
?>
<?php
/** [TOPメイン]トップ表示記事 */
function wp_widget_top_archive($args) {
?>
<?php include(TEMPLATEPATH . '/w_top_archive.php'); ?>
<?php
}
?>
<?php
/** [TOPメイン]カテゴリ記事一覧*/
function wp_widget_category_archive($args) {
	extract($args);
	$options = get_option('widget_category_archive');
	$title = empty($options['title']) ? __('category_archive') : apply_filters('widget_title', $options['title']);
	$include = empty( $options['include'] ) ? '' : $options['include'];

?>
<?php include(TEMPLATEPATH . '/w_category_archive_list.php'); ?>
<?php
}

/**
 * [TOPメイン]カテゴリ記事一覧
 * Display and process meta widget options form.
 * 2009/07/03
 */
function wp_widget_category_archive_control() {
	$options = $newoptions = get_option('widget_category_archive');
	if ( isset($_POST["category_archive-submit"]) ) {
		$newoptions['title'] = strip_tags(stripslashes($_POST["category_archive-title"]));
		$newoptions['include'] = strip_tags( stripslashes( $_POST['category_archive-include'] ) );
	}
	if ( $options != $newoptions ) {
		$options = $newoptions;
		update_option('widget_category_archive', $options);
	}
	$title = attribute_escape($options['title']);
	$include = attribute_escape( $options['include'] );
?>
			<p><label for="category_archive-title">タイトル： <input class="widefat" id="category_archive-title" name="category_archive-title" type="text" value="<?php echo $title; ?>" /></label></p>
			<p>
				<label for="category_archive-include"><?php echo ( 'カテゴリースラッグ名' ); ?> <input type="text" value="<?php echo $include; ?>" name="category_archive-include" id="category_archive-include" class="widefat" /></label>
				<br />
				<small><?php echo ( 'カテゴリースラッグ名 を入力。' ); ?></small>
			</p>
			<input type="hidden" id="category_archive-submit" name="category_archive-submit" value="1" />
<?php
}
?>
<?php
/** 
 * [TOPメイン]新着記事一覧
 * Display recent entries widget.
 * @param array $args Widget arguments.
 * @return int Displayed cache.
 * 2009/07/03
 */
function wp_widget_new_archive_list($args) {
	if ( '%BEG_OF_TITLE%' != $args['before_title'] ) {
		if ( $output = wp_cache_get('widget_new_archive_list', 'widget') )
			return print($output);
		ob_start();
	}

	extract($args);
	$options = get_option('widget_new_archive_list');
	$title = empty($options['title']) ? __('新着情報') : apply_filters('widget_title', $options['title']);
	if ( !$number = (int) $options['number'] )
		$number = 10;
	else if ( $number < 1 )
		$number = 1;
	else if ( $number > 15 )
		$number = 15;

	$r = new WP_Query(array('showposts' => $number, 'what_to_show' => 'posts', 'nopaging' => 0, 'post_status' => 'publish', 'caller_get_posts' => 1));
	if ($r->have_posts()) :
?>
<?php include(TEMPLATEPATH . '/w_new_archive_list.php'); ?>
<?php
		wp_reset_query();  // Restore global post data stomped by the_post().
	endif;

	if ( '%BEG_OF_TITLE%' != $args['before_title'] )
		wp_cache_add('widget_new_archive_list', ob_get_flush(), 'widget');
}

/**
 * [TOPメイン]新着記事一覧
 * Remove recent entries widget items cache.
 * 2009/07/03
 */
function wp_flush_widget_new_archive_list() {
	wp_cache_delete('widget_new_archive_list', 'widget');
}

/**
 * [TOPメイン]新着記事一覧
 * Display and process recent entries widget options form.
 * 2009/07/03
 */
function wp_widget_new_archive_list_control() {
	$options = $newoptions = get_option('widget_new_archive_list');
	if ( isset($_POST["recent-entries-submit2"]) ) {
		$newoptions['title'] = strip_tags(stripslashes($_POST["recent-entries-title2"]));
		$newoptions['number'] = (int) $_POST["recent-entries-number2"];
	}
	if ( $options != $newoptions ) {
		$options = $newoptions;
		update_option('widget_new_archive_list', $options);
		wp_flush_widget_new_archive_list();
	}
	$title = attribute_escape($options['title']);
	if ( !$number = (int) $options['number'] )
		$number = 5;
?>

			<p><label for="recent-entries-title2">タイトル： <input class="widefat" id="recent-entries-title2" name="recent-entries-title2" type="text" value="<?php echo $title; ?>" /></label></p>
			<p>
				<label for="recent-entries-number2">表示する投稿数： <input style="width: 25px; text-align: center;" id="recent-entries-number2" name="recent-entries-number2" type="text" value="<?php echo $number; ?>" /></label>
				<br />
				<small>(最大 15)</small>
			</p>
			<input type="hidden" id="recent-entries-submit2" name="recent-entries-submit2" value="1" />
<?php
}
?>
<?php
/**
 * [サイド]メインメニュー
 * Display categories widget.
 * Allows multiple category widgets.
 * @param array $args Widget arguments.
 * @param int $number Widget number.
 * 2009/07/03
 */
function wp_widget_categories_menu($args, $widget_args = 1) {
	extract($args, EXTR_SKIP);
	if ( is_numeric($widget_args) )
		$widget_args = array( 'number' => $widget_args );
	$widget_args = wp_parse_args( $widget_args, array( 'number' => -1 ) );
	extract($widget_args, EXTR_SKIP);

	$options = get_option('widget_categories');
	if ( !isset($options[$number]) )
		return;

	$c = $options[$number]['count'] ? '1' : '0';
	$h = $options[$number]['hierarchical'] ? '1' : '0';
	$d = $options[$number]['dropdown'] ? '1' : '0';

	$title = empty($options[$number]['title']) ? __('Categories') : apply_filters('widget_title', $options[$number]['title']);

	$cat_args = array('orderby' => 'name', 'show_count' => $c, 'hierarchical' => $h);

	if ( $d ) {
		echo $before_widget;
		echo $before_title . $title . $after_title;

		$cat_args['show_option_none'] = __('Select Category');
		wp_dropdown_categories($cat_args);
?>
<script type='text/javascript'>
/* <![CDATA[ */
	var dropdown = document.getElementById("cat");
	function onCatChange() {
		if ( dropdown.options[dropdown.selectedIndex].value > 0 ) {
			location.href = "<?php echo get_option('home'); ?>/?cat="+dropdown.options[dropdown.selectedIndex].value;
		}
	}
	dropdown.onchange = onCatChange;
/* ]]> */
</script>
<?php
echo $after_widget;
	} else {
?>
	<div class="widget-main-menu">
	<div class="menu-content">
		<ul class="menu-list">
		<?php
			$cat_args['title_li'] = '';
			wp_list_categories($cat_args);
		?>
		</ul>
	</div>
	</div>
<?php
	}
}

/**
 * [サイド]メインメニュー
 * Display and process categories widget options form.
 * @param int $widget_args Widget number.
 * 2009/07/03
 */
function wp_widget_categories_menu_control( $widget_args ) {
	global $wp_registered_widgets;
	static $updated = false;

	if ( is_numeric($widget_args) )
		$widget_args = array( 'number' => $widget_args );
	$widget_args = wp_parse_args( $widget_args, array( 'number' => -1 ) );
	extract($widget_args, EXTR_SKIP);

	$options = get_option('widget_categories');

	if ( !is_array( $options ) )
		$options = array();

	if ( !$updated && !empty($_POST['sidebar']) ) {
		$sidebar = (string) $_POST['sidebar'];

		$sidebars_widgets = wp_get_sidebars_widgets();
		if ( isset($sidebars_widgets[$sidebar]) )
			$this_sidebar =& $sidebars_widgets[$sidebar];
		else
			$this_sidebar = array();

		foreach ( (array) $this_sidebar as $_widget_id ) {
			if ( 'wp_widget_categories_menu' == $wp_registered_widgets[$_widget_id]['callback'] && isset($wp_registered_widgets[$_widget_id]['params'][0]['number']) ) {
				$widget_number = $wp_registered_widgets[$_widget_id]['params'][0]['number'];
				if ( !in_array( "categories-$widget_number", $_POST['widget-id'] ) ) // the widget has been removed.
					unset($options[$widget_number]);
			}
		}

		foreach ( (array) $_POST['widget-categories'] as $widget_number => $widget_cat ) {
			if ( !isset($widget_cat['title']) && isset($options[$widget_number]) ) // user clicked cancel
				continue;
			$title = trim(strip_tags(stripslashes($widget_cat['title'])));
			$count = isset($widget_cat['count']);
			$hierarchical = isset($widget_cat['hierarchical']);
			$dropdown = isset($widget_cat['dropdown']);
			$options[$widget_number] = compact( 'title', 'count', 'hierarchical', 'dropdown' );
		}

		update_option('widget_categories', $options);
		$updated = true;
	}

	if ( -1 == $number ) {
		$title = '';
		$count = false;
		$hierarchical = true;
		$dropdown = false;
		$number = '%i%';
	} else {
		$title = attribute_escape( $options[$number]['title'] );
		$count = (bool) $options[$number]['count'];
		$hierarchical = (bool) $options[$number]['hierarchical'];
		$dropdown = (bool) $options[$number]['dropdown'];
	}
?>

			<p>
			初期表示はリストで表示されます。
			</p>
			<p>
				ドロップダウン表示に切替え:<br />
				<label for="categories-dropdown-<?php echo $number; ?>">
					<input type="checkbox" class="checkbox" id="categories-dropdown-<?php echo $number; ?>" name="widget-categories[<?php echo $number; ?>][dropdown]"<?php checked( $dropdown, true ); ?> />
					ドロップダウンで表示
				</label>
				<br />
				タイトル：<br />
				<label for="categories-title-<?php echo $number; ?>">
					<input class="widefat" id="categories-title-<?php echo $number; ?>" name="widget-categories[<?php echo $number; ?>][title]" type="text" value="<?php echo $title; ?>" />
<br />
<small>タイトルを入力。</small>
				</label>
			</p>
			<hr />
			<p>
				階層表示:<br />
				<label for="categories-hierarchical-<?php echo $number; ?>">
					<input type="checkbox" class="checkbox" id="categories-hierarchical-<?php echo $number; ?>" name="widget-categories[<?php echo $number; ?>][hierarchical]"<?php checked( $hierarchical, true ); ?> />
					階層で表示
				</label>
				<br />
<!--
				<label for="categories-count-<?php echo $number; ?>">
					<input type="checkbox" class="checkbox" id="categories-count-<?php echo $number; ?>" name="widget-categories[<?php echo $number; ?>][count]"<?php checked( $count, true ); ?> />
					投稿数を表示
				</label>
-->
			</p>

			<input type="hidden" name="widget-categories[<?php echo $number; ?>][submit]" value="1" />
<?php
}

/**
 * [サイド]メインメニュー
 * Register categories widget on startup.
 * 2009/07/03
 */
function wp_widget_categories_menu_register() {
	if ( !$options = get_option( 'widget_categories' ) )
		$options = array();

	if ( isset($options['title']) )
		$options = wp_widget_categories_menu_upgrade();

	$widget_ops = array( 'classname' => 'widget_categories', 'description' => __( "カテゴリーのリストまたはドロップダウン表示" ) );

	$name = __( '[サイド]メインメニュー' );

	$id = false;
	foreach ( (array) array_keys($options) as $o ) {
		// Old widgets can have null values for some reason
		if ( !isset($options[$o]['title']) )
			continue;
		$id = "categories-$o";
		wp_register_sidebar_widget( $id, $name, 'wp_widget_categories_menu', $widget_ops, array( 'number' => $o ) );
		wp_register_widget_control( $id, $name, 'wp_widget_categories_menu_control', array( 'id_base' => 'categories' ), array( 'number' => $o ) );
	}

	// If there are none, we register the widget's existance with a generic template
	if ( !$id ) {
		wp_register_sidebar_widget( 'categories-1', $name, 'wp_widget_categories_menu', $widget_ops, array( 'number' => -1 ) );
		wp_register_widget_control( 'categories-1', $name, 'wp_widget_categories_menu_control', array( 'id_base' => 'categories' ), array( 'number' => -1 ) );
	}
}

/**
 * [サイド]メインメニュー
 * Upgrade previous category widget to current version.
 * @return array
 * 2009/07/03
 */
function wp_widget_categories_menu_upgrade() {
	$options = get_option( 'widget_categories' );

	if ( !isset( $options['title'] ) )
		return $options;

	$newoptions = array( 1 => $options );

	update_option( 'widget_categories', $newoptions );

	$sidebars_widgets = get_option( 'sidebars_widgets' );
	if ( is_array( $sidebars_widgets ) ) {
		foreach ( $sidebars_widgets as $sidebar => $widgets ) {
			if ( is_array( $widgets ) ) {
				foreach ( $widgets as $widget )
					$new_widgets[$sidebar][] = ( $widget == 'categories' ) ? 'categories-1' : $widget;
			} else {
				$new_widgets[$sidebar] = $widgets;
			}
		}
		if ( $new_widgets != $sidebars_widgets )
			update_option( 'sidebars_widgets', $new_widgets );
	}

	return $newoptions;
}

?>